// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/random-walk-test.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.Logger
import com.yandex.xplat.common.TypeSupport
import com.yandex.xplat.common.YSArray
import com.yandex.xplat.testopithecus.common.AccountType2
import com.yandex.xplat.testopithecus.common.BaseUserBehaviourTest
import com.yandex.xplat.testopithecus.common.UserAccount
import com.yandex.xplat.testopithecus.common.UserBehaviour

public open class RandomWalkTest(pathLength: Int, logger: Logger, seed: Int): BaseUserBehaviourTest<MailboxBuilder>("random walk for ${pathLength} steps with seed ${seed}", LoginComponent(), pathLength, logger, seed) {
    open override fun requiredAccounts(): YSArray<AccountType2> {
        return mutableListOf(AccountType2.Yandex)
    }

    open override fun prepareAccounts(mailboxes: YSArray<MailboxBuilder>): Unit {
        mailboxes[0].nextMessage("subj")
    }

    open override fun getUserBehaviour(accounts: YSArray<UserAccount>): UserBehaviour {
        return allActionsBehaviour(accounts).blacklist(SendMessageAction.type).blacklist(AddToAction.type).blacklist(SetSubjectAction.type).blacklist(AppendToBody.type).blacklist(ClearCache.type).blacklist(OpenSettingsAction.type).blacklist(OpenComposeAction.type)
    }

    companion object {
        @JvmStatic
        open fun generate(count: Int, logger: Logger): YSArray<RandomWalkTest> {
            val tests: YSArray<RandomWalkTest> = mutableListOf()
            for (i in (0 until count step 1)) {
                tests.add(RandomWalkTest(5, logger, TypeSupport.asInt32(i)!!))
            }
            return tests
        }

    }
}

