// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/settings-tests.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.testopithecus.common.MBTPlatform
import com.yandex.xplat.testopithecus.common.TestPlan
import com.yandex.xplat.testopithecus.common.TestSettings
import com.yandex.xplat.testopithecus.common.UserAccount

public open class OpenAboutSettingsTest(): RegularYandexMailTestBase("Settings: Открытие экрана About в настройках и проверка версии приложения") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(502).androidCase(6060)
    }

    open override fun prepareAccount(builder: MailboxBuilder): Unit {
        builder.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenAboutSettingsAction())
    }

}

public open class ClearCacheTest(): RegularYandexMailTestBase("Settings. General setting. Удаление кэша") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8318).androidCase(7456)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4").nextMessage("subj5").nextMessage("subj6").nextMessage("subj7").nextMessage("subj8").nextMessage("subj9").createFolder("UserFolder").switchFolder("UserFolder").nextMessage("usr_subj").nextMessage("usr_subj2").nextMessage("usr_subj3").nextMessage("usr_subj4").nextMessage("usr_subj5").nextMessage("usr_subj6").nextMessage("usr_subj7").nextMessage("usr_subj8").nextMessage("usr_subj9")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(ClearCache()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder")).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(ClearCache()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction("UserFolder"))
    }

}

public open class OpenAccountSettingsTest(): RegularYandexMailTestBase("Settings: Открытие настроек первого аккаунта в списке") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.androidCase(6060).ignoreOn(MBTPlatform.IOS)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenAccountSettingsAction(0))
    }

}

public open class ValidateGeneralSettingsTest(): RegularYandexMailTestBase("Settings. General settings. Отображение общих настроек.") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(403).androidCase(6096)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction())
    }

}

public open class ValidateRootSettingsTest(): RegularYandexMailTestBase("Settings. General settings. Отображение главного экрана настроек.") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(499).androidCase(6096)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction())
    }

}

public open class ValidateAccountSettingsTest(): RegularYandexMailTestBase("Settings. Account settings. Отображение настроек аккаунта.") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(409).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenAccountSettingsAction(0))
    }

}

public open class TurningOnOffCompactModeTest(): RegularYandexMailTestBase("Settings. General settings. Включение-отключение компактного режима.") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(21).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("Inbox subj1").nextMessage("Inbox subj2").createFolder("UserFolder").switchFolder("UserFolder").nextMessage("UserFolder subj1").nextMessage("UserFolder subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction("UserFolder")).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOffCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class ChangingActionOnSwipeTest(): RegularYandexMailTestBase("Settings. General settings. Изменение действия по свайпу.") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(406).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("Inbox subj1").nextMessage("Inbox subj2").nextMessage("Inbox subj3").nextMessage("Inbox subj4").nextMessage("Inbox subj5")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(DeleteMessageByLongSwipeAction(1)).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(ArchiveMessageByLongSwipeAction(2))
    }

}

public open class ChangingSignatureTest(): RegularYandexMailTestBase("Settings. General settings. Изменение подписи.") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(412)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("Inbox subj1").nextMessage("Inbox subj2").nextMessage("Inbox subj3").nextMessage("Inbox subj4").nextMessage("Inbox subj5")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(DeleteMessageByLongSwipeAction(1)).then(OpenSettingsAction()).then(OpenAccountSettingsAction(0)).then(ChangeSignatureAction("--\nNew signature")).then(CloseAccountSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(OpenComposeAction())
    }

}

