// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/short-swipe-menu-tests.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.testopithecus.common.*

public open class ShortSwipeMenuMarkAsReadMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма прочитанным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6217).androidCase(6472)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("message1").nextMessage("message2").nextMessage("message3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsReadFromContextMenuAction(1))
    }

}

public open class ShortSwipeMenuMarkAsReadThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка треда прочитанным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6618).androidCase(6631)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 1).nextThread("thread2", 2).nextThread("thread3", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsReadFromContextMenuAction(1))
    }

}

public open class ShortSwipeMenuMarkAsUnreadMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма непрочитанным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6218).androidCase(6473)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextMessage("message1").nextMessage("message2").nextMessage("message3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder")).then(MarkAsRead(0)).then(MarkAsUnreadFromContextMenuAction(0))
    }

}

public open class ShortSwipeMenuMarkAsUnreadThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка треда непрочитанным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6619).androidCase(6632)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 3).nextThread("thread2", 2).nextThread("thread3", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsRead(0)).then(MarkAsUnreadFromContextMenuAction(0))
    }

}

public open class ShortSwipeMenuDeleteMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Удаление письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6221).androidCase(6476)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserSubfolder", mutableListOf("UserFolder")).switchFolder("UserSubfolder", mutableListOf("UserFolder")).nextMessage("message1").nextMessage("message2").nextMessage("message3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("UserSubfolder", mutableListOf("UserFolder"))).then(DeleteMessageFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class ShortSwipeMenuDeleteThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Удаление треда") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6224).androidCase(6478)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(DeleteMessageFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class ShortSwipeMenuMarkAsSpamThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка треда спамом") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6236).androidCase(6490)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserSubfolder", mutableListOf("UserFolder")).switchFolder("UserSubfolder", mutableListOf("UserFolder")).nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("UserSubfolder", mutableListOf("UserFolder"))).then(MarkAsSpamFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam))
    }

}

public open class ShortSwipeMenuMarkAsSpamMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма спамом") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6235).androidCase(6489)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("message1").nextMessage("message2").nextMessage("message3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFilterUnreadAction()).then(MarkAsSpamFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class ShortSwipeMenuMarkAsNotSpamMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма не спамом") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6621).androidCase(6633)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.spam).nextMessage("message1").nextMessage("message2").nextMessage("message3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam)).then(MarkAsNotSpamFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class ShortSwipeMenuImportantMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма важным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6239).androidCase(6493)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.archive).nextMessage("message1").nextMessage("message2").nextMessage("message3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive)).then(MarkAsImportantFromContextMenuAction(2)).then(OpenFolderListAction()).then(GoToFilterImportantAction())
    }

}

public open class ShortSwipeMenuImportantThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка треда важным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6240).androidCase(6494)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsImportantFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFilterImportantAction())
    }

}

public open class ShortSwipeMenuUnImportantMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Снятие метки Важное с письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6241).androidCase(6495)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("message1", 2).nextThread("message2", 2).nextThread("message3", 2)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsImportantFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFilterImportantAction()).then(MarkAsUnImportantFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class ShortSwipeMenuUnImportantThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Снятие метки Важное с треда") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6242).androidCase(6496)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsImportantFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFilterImportantAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox)).then(MarkAsUnImportantFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFilterImportantAction())
    }

}

public open class ShortSwipeMenuMoveToFolderMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Перемещение письма в другую папку") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6244).androidCase(6498)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("message1").nextMessage("message2").nextMessage("message3").createFolder("UserFolder")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MoveToFolderFromContextMenuAction(1, "UserFolder")).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder"))
    }

}

public open class ShortSwipeMenuMoveToFolderThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Перемещение треда в другую папку") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6615).androidCase(6635)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4).createFolder("UserFolder")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MoveToFolderFromContextMenuAction(1, "UserFolder")).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder"))
    }

}

public open class ShortSwipeMenuMoveToInboxFromTrashTest(): RegularYandexMailTestBase("ShortSwipeMenu. Перемещение письма из папки Удаленные в папку Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(26).androidCase(6193)
    }

    open override fun prepareAccount(builder: MailboxBuilder): Unit {
        builder.switchFolder(DefaultFolderName.trash).nextMessage("AutoTestSubj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash)).then(MoveToFolderFromContextMenuAction(0, DefaultFolderName.inbox)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class ShortSwipeMenuDeleteFromTrashTest(): RegularYandexMailTestBase("ShortSwipeMenu. Удаление письма из папки Удаленные") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6620).androidCase(7618)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder("Trash").nextMessage("subject1").nextMessage("subject2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("Trash")).then(DeleteMessageFromContextMenuAction(1))
    }

}

public open class ShortSwipeMenuApplyLabelToThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Добавление пользовательской метки на тред") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6616).androidCase(6636)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4).createLabel("label1")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(ApplyLabelsFromContextMenuAction(1, mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToLabelAction("label1"))
    }

}

public open class ShortSwipeMenuApplyLabelToMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Добавление пользовательской метки на письмо") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6246).androidCase(6500)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextMessage("message1").nextMessage("message2").nextMessage("message3").createLabel("label1")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder")).then(ApplyLabelsFromContextMenuAction(2, mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToLabelAction("label1"))
    }

}

public open class ShortSwipeMenuRemoveLabelFromMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Снятие пользовательской метки с письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6247).androidCase(6501)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.sent).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1")).withSubject("subj1")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1")).withSubject("subj2"))
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.sent)).then(RemoveLabelsFromContextMenuAction(1, mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToLabelAction("label1"))
    }

}

public open class ShortSwipeMenuRemoveLabelFromThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Снятие пользовательской метки с треда") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6617).androidCase(6637)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4).createLabel("label1")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(ApplyLabelsFromContextMenuAction(1, mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToLabelAction("label1")).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox)).then(RemoveLabelsFromContextMenuAction(1, mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToLabelAction("label1"))
    }

}

public open class ShortSwipeMenuReplyOnMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Ответ на письмо") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6196).androidCase(6072)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("message1").nextMessage("message2").nextMessage("message3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenReplyComposeFromContextMenuAction(1))
    }

}

public open class ShortSwipeMenuArchiveMessageFromSpamTest(): RegularYandexMailTestBase("ShortSwipeMenu. Архивация одиночного письма из папки Спам") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6231).androidCase(6485)
    }

    open override fun prepareAccount(builder: MailboxBuilder): Unit {
        builder.switchFolder(DefaultFolderName.spam).nextMessage("AutoTestSubj1").nextMessage("AutoTestSubj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam)).then(ArchiveFromContextMenuAction(0)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class ShortSwipeMenuArchiveThreadFromUserFolderTest(): RegularYandexMailTestBase("ShortSwipeMenu. Архивация треда письма из Пользовательской папки") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6232).androidCase(6486)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextThread("AutoTestSubj1", 2)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder")).then(ArchiveFromContextMenuAction(0)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class ShortSwipeMenuMarkReadUnreadInCompactModeTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма прочитанным-непрочитанным в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(632).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextMessage("message1").nextMessage("message2").nextMessage("message3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction("UserFolder")).then(MarkAsRead(0)).then(MarkAsReadFromContextMenuAction(1)).then(MarkAsUnreadFromContextMenuAction(0)).then(OpenFolderListAction()).then(GoToFilterUnreadAction())
    }

}

public open class ShortSwipeMenuAddLabelInCompactModeTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма важным-неважным в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(635).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1", "label2")).withSubject("inbox_subj1")).switchFolder(DefaultFolderName.sent).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").createLabel("label1")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.sent)).then(ApplyLabelsFromContextMenuAction(1, mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToLabelAction("label1")).then(OpenFolderListAction()).then(GoToLabelAction("label2")).then(RemoveLabelsFromContextMenuAction(0, mutableListOf("label2"))).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class ShortSwipeMenuMarkUnmarkAsSpamInCompactModeTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма спамом-не спамом в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(636).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFilterUnreadAction()).then(MarkAsSpamFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam)).then(MarkAsNotSpamFromContextMenuAction(0)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class ShortSwipeMenuDeleteMessageFromTrashInCompactModeTest(): RegularYandexMailTestBase("ShortSwipeMenu. Удаление письма из папки Удаленные в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(637).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.trash).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.trash)).then(DeleteMessageFromContextMenuAction(1))
    }

}

public open class ShortSwipeMenuArchiveMessageInCompactModeTest(): RegularYandexMailTestBase("ShortSwipeMenu. Архивация письма в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(638).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkImportantSelectedAction()).then(OpenFolderListAction()).then(GoToFilterImportantAction()).then(ArchiveFromContextMenuAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class ShortSwipeMenuUndoSpamMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Отмена отправки в спам письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8625)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.trash).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash)).then(MarkAsSpamFromContextMenuAction(1)).then(UndoSpamAction())
    }

}

public open class ShortSwipeMenuUndoSpamThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Отмена отправки в спам треда") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8632)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextThread("subj1", 2).nextThread("subj2", 3).nextThread("subj3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder")).then(MarkAsSpamFromContextMenuAction(1)).then(UndoSpamAction())
    }

}

public open class ShortSwipeMenuUndoDeleteThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Отмена удаления треда") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8627)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("subj1", 2).nextThread("subj2", 3).nextThread("subj3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(DeleteMessageFromContextMenuAction(1)).then(UndoDeleteAction())
    }

}

public open class ShortSwipeMenuUndoDeleteMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Отмена удаления письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8630)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFilterUnreadAction()).then(DeleteMessageFromContextMenuAction(1)).then(UndoDeleteAction())
    }

}

public open class ShortSwipeMenuUndoArchiveThreadTest(): RegularYandexMailTestBase("ShortSwipeMenu. Отмена архивирования треда") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8629)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("subj1", 2).nextThread("subj2", 3).nextThread("subj3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(ArchiveFromContextMenuAction(0)).then(UndoArchiveAction())
    }

}

public open class ShortSwipeMenuUndoArchiveMessageTest(): RegularYandexMailTestBase("ShortSwipeMenu. Отмена архивирования письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8634)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.sent).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.sent)).then(ArchiveFromContextMenuAction(0)).then(UndoArchiveAction())
    }

}

public open class SearchAndMarkMessageReadByShortSwipeMenuTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма прочитанным в Поиске") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8867)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(MarkAsReadFromContextMenuAction(0)).then(AssertAction()).then(CloseSearchAction())
    }

}

public open class SearchAndDeleteMessageByShortSwipeMenuTest(): RegularYandexMailTestBase("ShortSwipeMenu. Удаление письма в Поиске") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8869)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(DeleteMessageFromContextMenuAction(1)).then(AssertAction()).then(CloseSearchAction()).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class SearchAndMoveMessageToAnotherFolderByShortSwipeMenuTest(): RegularYandexMailTestBase("ShortSwipeMenu. Перемещение письма в другую папку в Поиске") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8876)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").createFolder("UserFolder")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(MoveToFolderFromContextMenuAction(1, "UserFolder")).then(AssertAction()).then(CloseSearchAction()).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder"))
    }

}

public open class MoveMessageFromInboxTabToMailingListTabByShortSwipeMenuTest(): RegularYandexMailTestBase("ShortSwipeMenu. Перемещение одиночного сообщения из таба в таб") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7583)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.turnOnTab().switchFolder(TabBackendName.inbox).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MoveToFolderFromContextMenuAction(1, DefaultFolderName.mailingLists)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.mailingLists))
    }

}

public open class MarkMessageImportantInMailingListTabByShortSwipeMenuTest(): RegularYandexMailTestBase("ShortSwipeMenu. Пометка письма Важным в табе") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7593)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.turnOnTab().switchFolder(TabBackendName.mailingLists).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.mailingLists)).then(MarkAsImportantFromContextMenuAction(1)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFilterImportantAction())
    }

}

public open class MarkMessageUnimportantInSocialNetworksTabByShortSwipeMenuTest(): RegularYandexMailTestBase("ShortSwipeMenu. Снятие метки Важное в табе") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7594)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.turnOnTab().switchFolder(TabBackendName.socialNetworks).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.socialNetworks)).then(MarkAsImportantFromContextMenuAction(1)).then(MarkAsUnImportantFromContextMenuAction(1)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFilterImportantAction())
    }

}

public open class UnmarkLabelInInboxTabByShortSwipeMenuTest(): RegularYandexMailTestBase("ShortSwipeMenu. Снятие пользовательской метки с письма в табе") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7596)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.turnOnTab().switchFolder(TabBackendName.inbox).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1", "label2")).withSubject("subj1")).nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RemoveLabelsFromContextMenuAction(0, mutableListOf("label1"))).then(AssertAction()).then(OpenFolderListAction()).then(GoToLabelAction("label1"))
    }

}

