// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/short-swipe-tests.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.testopithecus.common.*

public open class SwipeToReadMessageTest(): RegularYandexMailTestBase("ShortSwipe. Пометка письма прочитанным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6211).androidCase(6466)
    }

    open override fun prepareAccount(builder: MailboxBuilder): Unit {
        builder.nextMessage("inbox_msg1").nextMessage("inbox_msg2").createFolder("AutotestFolder").switchFolder("AutotestFolder").nextMessage("subj").nextMessage("subj1")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("AutotestFolder")).then(MarkAsRead(0)).then(OpenFolderListAction()).then(GoToFilterUnreadAction()).then(MarkAsRead(2)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class SwipeToUnreadMessageTest(): RegularYandexMailTestBase("ShortSwipe. Пометка письма непрочитанным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6212).androidCase(6467)
    }

    open override fun prepareAccount(builder: MailboxBuilder): Unit {
        builder.switchFolder(DefaultFolderName.archive).nextMessage("subj").nextMessage("subj1")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive)).then(MarkAsRead(0)).then(MarkAsUnread(0))
    }

}

public open class SwipeToReadThreadTest(): RegularYandexMailTestBase("ShortSwipe. Пометка треда прочитанным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6214).androidCase(6469)
    }

    open override fun prepareAccount(builder: MailboxBuilder): Unit {
        builder.nextThread("thread1", 2).nextThread("thread2", 5)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsRead(1))
    }

}

public open class SwipeToUnreadThreadTest(): RegularYandexMailTestBase("ShortSwipe. Пометка треда непрочитанным") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6213).androidCase(6468)
    }

    open override fun prepareAccount(builder: MailboxBuilder): Unit {
        builder.nextThread("thread1", 4).nextThread("thread2", 1)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsRead(0)).then(MarkAsUnread(0))
    }

}

public open class ShortSwipeToDeleteThreadTest(): RegularYandexMailTestBase("ShortSwipe. Удаление коротким свайпом треда, письма которого лежат в разных папках") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6223).androidCase(6477)
    }

    open override fun prepareAccount(builder: MailboxBuilder): Unit {
        builder.nextThread("thread1", 4).nextThread("thread2", 1).createFolder("AutotestFolder")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(MoveMessageToFolderFromMessageViewAction("AutotestFolder")).then(BackToMaillistFromMessageViewAction()).then(DeleteMessageByShortSwipeAction(0)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash)).then(OpenFolderListAction()).then(GoToFolderAction("AutotestFolder"))
    }

}

public open class ShortSwipeToDeleteMessageTest(): RegularYandexMailTestBase("ShortSwipe. Удаление письма коротким свайпом из папки Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(25).androidCase(6192)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(DeleteMessageByShortSwipeAction(0)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class ShortSwipeToArchiveMessageTest(): RegularYandexMailTestBase("ShortSwipe. Архивация письма коротким свайпом из пользовательской подпапки") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6227).androidCase(6481)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("subfolder", mutableListOf("folder")).switchFolder("subfolder", mutableListOf("folder")).nextMessage("subj1").nextMessage("subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction("subfolder", mutableListOf("folder"))).then(ArchiveMessageByShortSwipeAction(0)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive)).then(DeleteMessageByShortSwipeAction(0))
    }

}

public open class ShortSwipeToArchiveThreadTest(): RegularYandexMailTestBase("ShortSwipe. Архивация треда коротким свайпом из папки Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6228).androidCase(6482)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 3).nextThread("thread2", 7).nextThread("thread3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(ArchiveMessageByShortSwipeAction(2)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class ShortSwipeToDeleteFromTrashTest(): RegularYandexMailTestBase("ShortSwipe. Удаление письма коротким свайпом из папки Удаленные") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6563).androidCase(6628)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.trash).nextMessage("subj").nextMessage("subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash)).then(DeleteMessageByShortSwipeAction(1))
    }

}

public open class ShortSwipeToArchiveFromArchiveThreadTest(): RegularYandexMailTestBase("ShortSwipe. Удаление письма из папки Архив при действии по свайпу Архивировать") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6564).androidCase(6629)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.archive).nextMessage("subj").nextMessage("subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.archive)).then(DeleteMessageByShortSwipeAction(1))
    }

}

public open class SwipeToReadMessageInCompactModeTest(): RegularYandexMailTestBase("ShortSwipe. Пометка письма прочитанным-непрочитанным в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(625).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(builder: MailboxBuilder): Unit {
        builder.nextMessage("inbox_msg1").nextMessage("inbox_msg2").nextMessage("inbox_msg3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFilterUnreadAction()).then(MarkAsRead(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox)).then(MarkAsUnread(1))
    }

}

public open class ShortSwipeToDeleteInCompactModeTest(): RegularYandexMailTestBase("ShortSwipe. Удаление письма коротким свайпом в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(627).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.sent).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.sent)).then(DeleteMessageByShortSwipeAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class ShortSwipeToArchiveInCompactModeTest(): RegularYandexMailTestBase("ShortSwipe. Архивация письма коротким свайпом в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(629).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.draft).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.draft)).then(ArchiveMessageByShortSwipeAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class ShortSwipeUndoArchiveMessageTest(): RegularYandexMailTestBase("ShortSwipe. Отмена архивирования письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8631)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(ArchiveMessageByShortSwipeAction(0)).then(UndoArchiveAction())
    }

}

public open class ShortSwipeUndoArchiveThreadTest(): RegularYandexMailTestBase("ShortSwipe. Отмена архивирования треда") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8633)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextThread("subj1", 2).nextThread("subj2", 3).nextThread("subj3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction("UserFolder")).then(ArchiveMessageByShortSwipeAction(1)).then(UndoArchiveAction())
    }

}

public open class ShortSwipeUndoDeleteThreadTest(): RegularYandexMailTestBase("ShortSwipe. Отмена удаления треда") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8623)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("subj1", 2).nextThread("subj2", 3).nextThread("subj3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(DeleteMessageByShortSwipeAction(1)).then(UndoDeleteAction())
    }

}

public open class ShortSwipeUndoDeleteMessageTest(): RegularYandexMailTestBase("ShortSwipe. Отмена удаления письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8622)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.sent).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.sent)).then(DeleteMessageByShortSwipeAction(0)).then(UndoDeleteAction())
    }

}

public open class ShortSwipeMarkMessageAsReadAtSearchTest(): RegularYandexMailTestBase("ShortSwipe. Пометка письма прочитанным в поиске") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8784)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(MarkAsReadFromShortSwipeAction(1)).then(AssertAction()).then(CloseSearchAction())
    }

}

public open class ShortSwipeDeleteMessageAtSearchTest(): RegularYandexMailTestBase("ShortSwipe. Удаление письма в поиске") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8786)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(DeleteMessageByShortSwipeAction(1)).then(AssertAction()).then(CloseSearchAction()).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class ShortSwipeDeleteThreadLandscapeTest(): RegularYandexMailTestBase("ShortSwipe. Удаление треда в лендскейпе") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8795)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("subj1", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(DeleteMessageByShortSwipeAction(0)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class ShortSwipeDeleteMessageAtSearch2paneTest(): RegularYandexMailTestBase("ShortSwipe. Удаление письма в поиске в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8792)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(OpenMessageAction(1)).then(DeleteMessageByShortSwipeAction(1)).then(AssertAction()).then(CloseSearchAction()).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class ShortSwipeArchiveMessageAtSearch2paneTest(): RegularYandexMailTestBase("ShortSwipe. Архивация письма в поиске в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(9124)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(RotateToLandscape()).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(OpenMessageAction(0)).then(ArchiveMessageByShortSwipeAction(0)).then(AssertAction()).then(CloseSearchAction()).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class ShortSwipeMarkMessageAsReadAtSearch2paneTest(): RegularYandexMailTestBase("ShortSwipe. Пометка письма прочитанным в поиске в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(9125)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(MarkAsReadFromShortSwipeAction(1)).then(AssertAction()).then(CloseSearchAction())
    }

}

public open class ShortSwipeDeleteMessage2paneTest(): RegularYandexMailTestBase("ShortSwipe. Удаление письма в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(9153)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(OpenMessageAction(2)).then(DeleteMessageByShortSwipeAction(2)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class ShortSwipeArchiveMessage2paneTest(): RegularYandexMailTestBase("ShortSwipe. Архивация письма в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(9154)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder("UserFolder").nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction("UserFolder")).then(RotateToLandscape()).then(OpenMessageAction(2)).then(ArchiveMessageByShortSwipeAction(2)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class ShortSwipeMarkMessageAsRead2paneTest(): RegularYandexMailTestBase("ShortSwipe. Пометка письма прочитанным в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8793)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(MarkAsReadFromShortSwipeAction(2)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFilterUnreadAction()).then(MarkAsReadFromShortSwipeAction(0))
    }

}

public open class ShortSwipeUndoDeleteMessage2paneTest(): RegularYandexMailTestBase("ShortSwipe. Отмена удаления письма в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8794)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("subj1", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(OpenMessageAction(0)).then(DeleteMessageByShortSwipeAction(0)).then(UndoDeleteAction())
    }

}

public open class ShortSwipeUndoArchiveMessage2paneTest(): RegularYandexMailTestBase("ShortSwipe. Отмена архивации письма в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(9155)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(RotateToLandscape()).then(OpenMessageAction(0)).then(ArchiveMessageByShortSwipeAction(0)).then(UndoArchiveAction())
    }

}

