// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/zero-suggest-tests.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.testopithecus.common.AssertAction
import com.yandex.xplat.testopithecus.common.TestPlan
import com.yandex.xplat.testopithecus.common.TestSettings
import com.yandex.xplat.testopithecus.common.UserAccount

public open class SearchMessagesViaZeroSuggestTest(): RegularYandexMailTestBase("ZeroSuggest. Поиск по тапу на саджест") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(597).androidCase(8292)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj 1").nextMessage("subj 2").nextMessage("subj 3").saveQueryToZeroSuggest("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchByZeroSuggestAction("subj")).then(CloseSearchAction())
    }

}

public open class SearchMessagesViaZeroSuggestIn2PaneTest(): RegularYandexMailTestBase("ZeroSuggest. Поиск по тапу на саджест в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(598).androidCase(8294)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj 1").nextMessage("subj 2").nextMessage("subj 3").saveQueryToZeroSuggest("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(OpenSearchAction()).then(SearchByZeroSuggestAction("subj")).then(CloseSearchAction())
    }

}

public open class RotateDeviceInZeroSuggestTest(): RegularYandexMailTestBase("ZeroSuggest. Изменение ориентации устройства") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(602).androidCase(8300)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj 1").nextMessage("subj 2").nextMessage("subj 3").saveQueryToZeroSuggest("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(RotateToLandscape()).then(AssertAction()).then(RotateToPortrait())
    }

}

public open class SaveQueryToZeroSuggestTest(): RegularYandexMailTestBase("ZeroSuggest. Сохранение запроса в саджест") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(603).androidCase(8293)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj 1").nextMessage("subj 2").nextMessage("subj 3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchByRequestAction("subj")).then(OpenMessageAction(0)).then(BackToMaillistFromMessageViewAction()).then(CloseSearchAction()).then(OpenSearchAction()).then(SearchByZeroSuggestAction("subj"))
    }

}

public open class SearchUnreadMessagesViaZeroSuggestTest(): RegularYandexMailTestBase("ZeroSuggest. Поиск непрочитанного письма по тапу на саджест") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(14).androidCase(6197)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj 1").nextMessage("subj 2").nextMessage("subj 3").saveQueryToZeroSuggest("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsRead(0)).then(OpenSearchAction()).then(SearchByZeroSuggestAction("subj"))
    }

}

public open class ZeroSuggestCaseInsensitiveTest(): RegularYandexMailTestBase("ZeroSuggest. Проверка нечувствительности к регистру при сохранении запросов") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(605)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1")).withSubject("ТЕСТ")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1")).withSubject("тест")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1")).withSubject("ТесТ"))
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToLabelAction("label1")).then(OpenSearchAction()).then(SearchByRequestAction("тест")).then(OpenMessageAction(0)).then(BackToMaillistFromMessageViewAction()).then(ClearTextFieldAction()).then(SearchByRequestAction("ТЕСТ")).then(OpenMessageAction(0)).then(BackToMaillistFromMessageViewAction()).then(ClearTextFieldAction()).then(SearchByRequestAction("ТесТ")).then(OpenMessageAction(0)).then(BackToMaillistFromMessageViewAction()).then(ClearTextFieldAction()).then(CloseSearchAction())
    }

}

