import logging
import os
import smtplib
import sys
from collections import defaultdict
from datetime import datetime
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText

import requests
import urllib3
from retrying import retry
from startrek_client import Startrek

sys.path.append('/set_secret')
import set_secret

urllib3.disable_warnings()

set_secret.set_secrets()
client = Startrek(
    useragent='curl/7.53.1',
    base_url='https://st-api.yandex-team.ru/v2',
    token=os.environ['STARTRECK_TOKEN']
)

assessorsQueue = 'MAILEXP'
subj = 'Тикеты асессорские время пришло разобрать тебе'
fromaddr = "testoviy-test111@yandex.ru"
mypass = "Testoviy1"
toaddr = ['mail-qa-duty@yandex-team.ru']
greeting = 'Приветствую!<br><br>'
st_host = 'https://st-api.yandex-team.ru/v2/'
headers_st = {'Authorization': 'OAuth ' + os.environ['STARTRECK_TOKEN']}


def get_resolution(self): return self.value.resolution


def manageAllOpenTickets():
    issues = client.issues.find(f'Queue: {assessorsQueue} Resolution: handedToDevelopment, known Status: open')
    print('Всего открыто тикетов %s' % len(issues))
    resolutions = defaultdict(list)
    i = 0
    text = ''
    for issue in issues:
        linkTickets = client.issues.find(
            f'(Relates: {issue.key} OR Clone: {issue.key}) AND (Queue: QUINN, DARIA, MAYA, LITEMAIL)'
        )
        if len(linkTickets) == 1:
            if linkTickets[0].status.key == 'closed':
                if linkTickets[0].resolution.key == 'duplicate':
                    duplicateTicket = client.issues.find(f'"Is Duplicated By": {linkTickets[0].key}')
                    if len(duplicateTicket) == 1:
                        if duplicateTicket[0].status.key == 'closed':
                            resolutions[duplicateTicket[0].resolution.key].append(issue.key)
                    else:
                        print(issue.key)
                        print(
                            'Связанный тикет закрыт с резолюцией Дубликат, Оригинал к связному тикету не найден' + '\n')
                        text += f'https://st.yandex-team.ru/{issue.key} Связанный тикет закрыт с резолюцией Дубликат, связный тикет не найден<br>'

                else:
                    resolutions[linkTickets[0].resolution.key].append(issue.key)

        if len(linkTickets) == 0:
            print(issue.key)
            print('Связанных тикетов нет' + '\n')
            text += f'https://st.yandex-team.ru/{issue.key} Связанных тикетов нет<br>'

        if len(linkTickets) > 1:
            closedTickets = []
            for ticket in linkTickets:
                if ticket.status.key == 'closed':
                    closedTickets.append(ticket.resolution.key)
            if len(closedTickets) == len(linkTickets):
                if all(closedTickets[i] == closedTickets[i + 1] for i in range(len(closedTickets) - 1)):
                    resolutions[closedTickets[0]].append(issue.key)
                else:
                    resolutions['fixed'].append(issue.key)

    for resolution in resolutions.values():
        i += len(resolution)
    print('Будет закрыто тикетов: %s' % i)
    update_issues(client, resolutions)
    if datetime.now().isoweekday() == 4 and text != '':
        text = greeting + text + '<br>Возникли вопросы? Загляни в https://github.yandex-team.ru/mariya-murm/mailscripts/blob/master/AssessorsQueueManager/README.md'
        send_message(text)


@retry(stop_max_attempt_number=5, wait_fixed=10000)
def update_issues(client, resolutions):
    for resolution in resolutions:
        print(resolution)
        print(resolutions[resolution])
        if resolution == 'untilNextComplaint':
            bulk_change = client.bulkchange.transition(
                issues=resolutions[resolution],
                transition='close',
                resolution='won\'tFix'
            )
            bulk_change = bulk_change.wait()
            print(bulk_change.status)
        else:
            bulk_change = client.bulkchange.transition(
                issues=resolutions[resolution],
                transition='close',
                resolution=resolution
            )
            bulk_change = bulk_change.wait()
            print(bulk_change.status)


@retry(stop_max_attempt_number=3, wait_fixed=10000)
def send_message(body):
    msg = MIMEMultipart()
    msg['From'] = fromaddr
    msg['To'] = ', '.join(toaddr)
    msg['Subject'] = subj

    msg.attach(MIMEText(body, 'html', 'utf-8'))

    server = smtplib.SMTP_SSL('smtp.yandex.ru', 465, timeout=10)
    server.set_debuglevel(1)
    server.login(fromaddr, mypass)
    text = msg.as_string()
    server.sendmail(fromaddr, toaddr, text)
    server.quit()


def release_empty_versions():
    versions = client.queues[assessorsQueue].versions
    for version in versions:
        if version['archived'] == False and version['released'] == False and version['id'] != 55689:
            # 55689 - возможно, кому-то нужна версия [Известные баги]
            tickets = client.issues.find(
                f'Queue: {assessorsQueue} AND "Fix Version": {version["id"]} AND Resolution: empty()'
            )
            if len(tickets) == 0:
                url = f'{st_host}/versions/{version["id"]}/_release'
                r = requests.post(url, headers=headers_st, verify=False)
                logging.info(' Startrek response: %s' % r.text)


def close_old_tickets_for_testing():
    tickets_for_testing = defaultdict(list)
    issues = client.issues.find(
        f'Queue: {assessorsQueue} Resolution: empty() Status: open Author: "Pinkie Pie" Created: <= now() - 14days'
    )
    for issue in issues:
        sub_tasks = client.issues.find(
            f'("Is Subtask For":{issue.key} Resolution: empty())'
        )
        if len(sub_tasks) == 0:
            tickets_for_testing['fixed'].append(issue.key)
    update_issues(client, tickets_for_testing)


if __name__ == '__main__':
    manageAllOpenTickets()
    release_empty_versions()
    close_old_tickets_for_testing()
