
# Описание

Для нетерпеливых - просто пролистайте в самый низ.
Этот скрипт служит для парсинга логов на тестовых стендах и поиска ошибок, которых нет в проде. На данный момент
реализован парсинг HandlerErrors, JSErrors, ns.events, FatalErrors. Сделаны заготовки для парсинга duffman логов.
Скрипт разделен на две части: клиентскую и серверную. 

Для запуска нужно выполнить в консоли: 

```python ./logParser.py -H [host] -f [file]```

**host** - адрес тестового стенда, с которого будем грепать логи

**file** - файл, который будем грепать ("access.log", "access.log.0", "access.log.1", "access.log.2", 
"access.log.3", "access.log.*")

Если файл не указан, то греп происходит по ```access.log```

## Клиентская часть
Распологается в директории ```Client Part```

Входная точка - скрипт ```logParser.py``` , в нём располагаются базовые функции, функция для загрузки логов,
 функции для первичного парсинга логов, а так же логика по вводу параметров из консоли.

### Алгоритм работы клиентской части
1. Скрипт по ssh идёт на тестовый стенд и скачивает указанный лог файл в ```./logs_pickle```
2. Скрипт по ssh идёт на mailfront4  и забирает оттуда файлы с уникальными ошибками прода (которые обновляются раз в день, см. "Серверная часть"),
 кладёт их в ```./Client Part/logs_prod/```
2. Скачанный лог открывается и парсится в удобный формат (словарь с заранее определёнными информативными ключами),
логи в новом формате кладутся их по пути ```./Client Part/logs/```
3. Затем происходит парсинг каждого типа ошибок отдельно, парсеры и необходимые им функции лежат каждый в своем файле
с названием вида ```[тип ошибки]Parse.py```

#### Структура файла парсинга по типу
В каждом парсере по виду в общем случае есть следующие функции:
* сохранение в файл - ```save_obj(obj, name)```
* загрузка из файла - ```load_obj(obj, name)```
* поиск и подсчет в файле уникальных ошибок заданного типа и запись их в ```./Client Part/logs_prod/``` - ```def parse_[тип ошибки](obj)```
* сортировка ошибок по встречаемости - ```sort_by_count(logs_to_sort)```
* сравнение уникальных ошибок теста с продом и вывод результата - ```def find_equal_[тип ошибки]()```

## Серверная часть
Распологается в директории ```Server Part```. Скрипты этой части раскладываются на mailfront4.yandex.ru и запускаются
по крону в районе 13 часов каждый день. Их суть в том, чтобы выполнить YQL запрос с преобразованиями, идентичными
клиентской части и сохранить все уникальные ошибки продакшена в ```./Server Part/[тип ошибки]_prod``` откуда их заберет 
клиентская часть скрипта.

# Как получить SSH ключ
1. Берём свой ключ для путти, с помощью которого заходим на машинки и открываем его в [puttygen](https://www.chiark.greenend.org.uk/~sgtatham/putty/latest.html)
2. В блоке Parameters выставляем тип ключа SSH-1(RSA)
3. Открывае меню Conversions
4. Жмем Export OpenSSH key
5. Полученный файл кладём в папку Client Part скрипта

# Необходимые импорты
У вас может не быть некоторых библиотек, например, pysftp, установить их можно следующей командой:
```pip install pysftp```

# Я НЕ ХОЧУ ЭТО ВСЁ ЧИТАТЬ, ХОЧУ ПЫЩ-ПЫЩ И СПИСОК УНИКАЛЬНЫХ ОШИБОК! (Или как всё-таки запустить скрипт)
1. Пуль себе проект
2. Заведи файлик SETTINGS.py в ```./Client Part%%```, в нём надо указать параметры с паролем и путём к приватному SSH ключу  :
```
password= '123123123'
dirToKey = './myKey'
token = '124124124124'
username = 'a-koekffswe'
```

2. Вторым питоном запускай ```python ./logParser.py -H [host] --f [file]``` ( **host** - адрес тестового стенда, 
**file** - файл, который будем грепать ("access.log", "access.log.0", "access.log.1", "access.log.2", 
"access.log.3", "access.log.*") )  ПРИМЕР: ```python ./logParser.py -H ub2-qa.yandex.ru -f access.log.*```. Можно
запускать без флагов и просто ввести всё в интерактивном режиме
3. Смотри, что выводится в консоли, красненькое - плохо, зелёненькое - всё ок, если у тебя ни красненького, ни зелененького,
то придётся почитать, что там написано и написать мне(a-zoshchuk), через что ты запускаешь скрипт)

## Если что-то не запустилось
1. Проверь версию питона, которым запускаешь
2. Проверь наличие всех библиотек из главы "Необходимые импорты"
3. Попробуй запустить в PyCharm
4. Проверь корректность местоположения ключа, глава "Как получить SSH ключ"

# Что делать с найденными ошибками
Дока в вики: https://wiki.yandex-team.ru/users/sshelgunova/O-logax-Pochty/Proverka-nalichija-logov-v-prode/





