import builtins
import os
import pickle
import re

scriptPath = os.path.dirname(os.path.abspath(__file__))
message_fatals = []


def print(arg):
    builtins.print(arg)
    message_fatals.append(str(arg))


def save_obj(obj, name):
    with open(scriptPath + '/' + name, 'wb') as f:
        pickle.dump(obj, f, pickle.HIGHEST_PROTOCOL)


def load_obj(name):
    with open(scriptPath + '/' + name, 'rb') as f:
        return pickle.load(f, encoding='UTF-8')


def sort_by_count(logs_to_sort):
    for i in range(len(logs_to_sort) - 1):
        for k in range(len(logs_to_sort) - 1):
            if logs_to_sort[k]["count"] < logs_to_sort[k + 1]["count"]:
                foo = logs_to_sort[k]
                logs_to_sort[k] = logs_to_sort[k + 1]
                logs_to_sort[k + 1] = foo
    return logs_to_sort


def parse_fatalerrors(obj):
    uniq_errors = []
    logs_to_parse = load_obj(obj)
    for log in logs_to_parse:
        if log["errorType"] == "FatalError":
            log["loc"] = fatalerror_loc_optimise(log["loc"])
            found = 0
            for uniq_error in uniq_errors:
                if uniq_error["reason"] == log["reason"]:
                    if uniq_error["loc"] == log["loc"]:
                        uniq_error["count"] += 1
                        found = 1
            if found == 0:
                uniq_errors.append({"count": 1, "reason": log["reason"], "loc": log["loc"]})
    uniq_errors = sort_by_count(uniq_errors)

    save_obj(uniq_errors, 'logs_test/fatalerror_testing')


def fatalerror_loc_optimise(text):
    text = re.sub("=[0-9a-zA-Z\-\.]*", "=", text)
    text = re.sub("t[0-9]*", "=", text)
    text = re.sub("/[0-9]*", "/", text)
    return text


def find_equal_fatalerrors():
    global message_fatals
    message_fatals = []
    print('<br>')
    print('<h3>Fatal errors</h3>')

    parsed_local_handlers = load_obj('logs_test/fatalerror_testing')
    parsed_yql_handlers = load_obj('logs_prod/FatalError_prod')

    if parsed_local_handlers:
        print('<pre>')
        for error in parsed_local_handlers:
            print(str(error["count"]) + '     ' + error["reason"] + '  ' + error["loc"])
        print('</pre>')
    else:
        print('No fatal errors found!')

    print('<pre>')
    for error in parsed_local_handlers:
        is_equal = 0
        for prod_error in parsed_yql_handlers:
            if error["reason"] == prod_error["reason"]:
                if error["loc"] == prod_error["loc"]:
                    is_equal = 1
        if is_equal != 1:
            print('<font color="red">DIDN\'T FIND ERROR IN PROD :')
            print(error)
            print('</font>')
    print('</pre>')

    return message_fatals
