import ast
import builtins
import html
import os
import pickle
import re

from yql.api.v1.client import YqlClient

from set_secret import set_secret

set_secret.set_secrets()
client = YqlClient(db='hahn', token=os.environ["YQL_TOKEN"])

message_handlers = []
scriptPath = os.path.dirname(os.path.abspath(__file__))


def print(arg):
    builtins.print(arg)
    message_handlers.append(str(arg))


def save_obj(obj, name):
    with open(scriptPath + '/' + name, 'wb') as f:
        pickle.dump(obj, f, pickle.HIGHEST_PROTOCOL)


def load_obj(name):
    with open(scriptPath + '/' + name, 'rb') as f:
        return pickle.load(f, encoding='UTF-8')


def sort_by_count(logs_to_sort):
    for i in range(len(logs_to_sort) - 1):
        for k in range(len(logs_to_sort) - 1):
            if logs_to_sort[k]["count"] < logs_to_sort[k + 1]["count"]:
                foo = logs_to_sort[k]
                logs_to_sort[k] = logs_to_sort[k + 1]
                logs_to_sort[k + 1] = foo
    return logs_to_sort


def load_ir():
    request = client.query(
        r"""
    SELECT m, IR, name, text FROM `home/mailfront/qa/logAlerts/ir_table`
    """,
        syntax_version=1
    )
    request.run()
    ir_for_errors = []
    for table in request.get_results():
        column_names = []
        table.fetch_full_data()
        for column_name, column_type in table.columns:
            column_names.append(column_name)
        k = 0
        for row in table.rows:
            ir_for_errors.append({})
            i = 0
            for cell in row:
                ir_for_errors[k][column_names[i]] = cell
                i += 1
            k += 1
    return ir_for_errors


#  HANDLER FUNCTIONS
def parse_handlers(obj):
    uniq_errors = []
    logs_to_parse = load_obj(obj)
    for log in logs_to_parse:
        if log["errorType"] == "HandlerError":
            log["text"] = handler_text_optimise(log["text"])
            found = 0
            for uniq_error in uniq_errors:
                if uniq_error["name"] == log["name"]:
                    if uniq_error["text"] == log["text"]:
                        uniq_error["count"] += 1
                        found = 1
            if found == 0:
                uniq_errors.append({"name": log["name"], "text": log["text"], "count": 1})
    uniq_errors = sort_by_count(uniq_errors)

    save_obj(uniq_errors, 'logs_test/HandlerError_testing')


def handler_text_optimise(text):
    keys = ["reason", "id", "method", "code", "type", "result", "error"]
    text_dict = {}
    if (text.find("SQL") != -1) | (text.find("Sql") != -1):
        text = "Some SQL error (grep it by yourserf using name and words SQL\Sql)"
    if "{" in text:
        try:
            text = re.sub("request_id[\\\"\ \:]*[a-zA-Z0-9]*", "", text)
            text = re.sub("[a-z0-9]{15,}", "", text)
            text = re.sub(",\"\"", "", text)
            try:
                text = ast.literal_eval(text)
                for key in list(text.keys()):
                    if key in keys:
                        text_dict[key] = str(text[key])
            except BaseException:
                return text
        except SyntaxError as e:
            print(e)
            print(text)
            print("-----")
            text_dict["error"] = text
    else:
        text_dict = text
    text_dict = str(text_dict)
    return text_dict


def get_error_color(ir, error):
    color = '#D28000'  # orange
    text = 'can\'t find error in list'
    for ir_error in ir:
        if (error['name'] == ir_error['name']) & (error['text'] in ir_error['text']):
            error_max = float(ir_error['m']) + float(ir_error['IR']) * 2
            error_min = float(ir_error['m']) - float(ir_error['IR']) * 2 if float(ir_error['m']) > float(
                ir_error['IR']) * 2 else 0
            if error['count'] < 4:
                return '', 'not enough data to analyze'
            if error['count'] > float(ir_error['m']) + float(ir_error['IR']) * 2:
                color = 'red'
                text = 'error is more frequent than usual, normal max is: %s' % str(error_max)
            elif error['count'] < float(ir_error['m']) - float(ir_error['IR']) * 2:
                color = 'green'
                text = 'error is more rare than usual, normal min is: %s' % str(error_min)
            else:
                color = 'green'
                text = 'all is fine, boundaries: %s - %s' % (str(error_min), str(error_max))
    return color, text


def find_equal_handler():
    global message_handlers
    message_handlers = []
    print('<h3>Handler errors</h3>')

    parsed_local_handlers = load_obj('logs_test/HandlerError_testing')
    parsed_yql_handlers = load_obj('logs_prod/HandlerError_prod')

    irs = load_ir()

    if parsed_local_handlers:
        print('<pre>')
        for error in parsed_local_handlers:
            color, text = get_error_color(irs, error)
            if color not in ['green', '']:
                print(
                    '<font color="{}">{:<6} {:<20} {:<35} {:<30}</font>'.format(
                        color,
                        error["count"],
                        error["name"],
                        html.escape(str(error["text"])),
                        text
                    )
                )
        print('</pre>')
    else:
        print("No handler errors found!")

    print('<pre>')
    for error in parsed_local_handlers:
        is_equal = 0
        for prod_error in parsed_yql_handlers:
            if error["name"] == prod_error["name"]:
                if error["text"] == prod_error["text"]:
                    is_equal = 1
        if is_equal != 1:
            print('<font color="red">DIDN\'T FIND ERROR IN PROD :')
            print(error)
            print('</font>')
    print('</pre>')

    return message_handlers
