import os
import pickle
import sys

sys.path.append('/set_secret')

import set_secret

from yql.api.v1.client import YqlClient

scriptPath = '/ephemeral/LogParse'
set_secret.set_secrets()
client = YqlClient(db='hahn', token=os.environ["YQL_TOKEN"])

# noinspection PyTypeChecker
request = client.query(
    r"""
$get_day_table_name = @@
import datetime

def get_error_table_name(delta):
    return 'errors-%s' % (datetime.date.today() - datetime.timedelta(days=delta)).strftime("%Y-%m-%d")
@@;

$table_name_days_before = Python::get_error_table_name(Callable<(Int32)->String>, $get_day_table_name);

$parse = Python::parse(Callable<(String?)->String?>, @@
def parse(text):
    import re
    text=str(text)
    text = re.sub("=[0-9a-zA-Z\-\.]*", "=", text)
    text = re.sub("/[0-9]*", "/", text)
    return(text)
@@);

SELECT error_type, name, reason, loc, COUNT(*) as c
FROM RANGE(`//home/mailfront`, $table_name_days_before(3), $table_name_days_before(1)) as T
WHERE error_type="FatalError"
GROUP BY error_type, DictLookup(T.request_dict, "reason") as reason, $parse(loc) as loc, DictLookup(T.request_dict, "name") as name
ORDER BY c DESC;
""",
    syntax_version=1
)

request.run()

for table in request.get_results():
    uniq_errors = []
    column_names = []
    table.fetch_full_data()
    for column_name, column_type in table.columns:
        column_names.append(column_name)
    k = 0
    print(len(table.rows))
    for row in table.rows:
        uniq_errors.append({})
        i = 0
        for cell in row:
            if (column_names[i] == "reason") | (column_names[i] == "loc"):
                uniq_errors[k][column_names[i]] = cell
            i += 1
        k += 1
    print(len(uniq_errors))

    with open(scriptPath + '/FatalError_prod', 'wb') as fp:
        pickle.dump(uniq_errors, fp)

    print('\nFatalErrors DONE!')
