import os
import random
import warnings
from enum import Enum
import urllib3
from sklearn.preprocessing import PolynomialFeatures
from startrek_client import Startrek
from sklearn.linear_model import LinearRegression, Ridge, Lasso, ARDRegression
from sklearn.model_selection import train_test_split, cross_val_score
from statistics import mean

client = Startrek(useragent='curl/7.53.1', token=os.environ['STARTRECK_TOKEN'])

issues = client.issues.find(f'Queue: DARIA "Weight 2": notEmpty() "Sort by": Updated ASC')

class Priority(Enum):
    MINOR = 'minor'
    NORMAL = 'normal'
    NS = 'ns'
    CRIT = 'crit'
    BLOCKER = 'blocker'


class Weight(Enum):
    MINOR = 100
    NORMAL = 250
    NS = 1000
    CRIT = 2000


class Ticket:
    def __init__(self, ticket):
        self.reproduce = ticket.reproducibility
        self.audience = ticket.audience if ticket.audience != 0 else 0.0001
        self.importance = int(ticket.importance)
        self.weight = int(ticket.weightOneHalf)


def get_priority(weight):
    if weight < Weight.MINOR.value:
        return Priority.MINOR

    if weight < Weight.NORMAL.value:
        return Priority.NORMAL

    if weight < Weight.NS.value:
        return Priority.NS

    if weight < Weight.CRIT.value:
        return Priority.CRIT

    return Priority.BLOCKER


def bingo(weight, weight_prediction):
    # """
    # Проверяем совпадает ли расчитанный приоритет тикета с реальным
    # """
    priority = get_priority(weight)
    priority_prediction = get_priority(weight_prediction)

    if priority_prediction == priority:
        return priority, True

    return priority, False


def prediction_and_get_formula(data, result):
    # """
    # Расчитываем формулу
    # """

    data, test_data, result, test_result = train_test_split(data, result, test_size=0.45, random_state=0)
    with open("test_data.txt", 'w') as f:
        f.write(str(test_data))
    f.close()

    # Регрессия Риджа, подбираем alpha
    # for i in range(200):
    #     ridgeR = Ridge(alpha=i * 0.01)
    #     ridgeR.fit(data, result)
    #     y_pred = ridgeR.predict(test_data)
    #     scores = cross_val_score(ridgeR, test_data, test_result, cv=5, scoring='neg_mean_squared_error')
    #     print(f"{str(i * 0.01)} : {str(mean(scores))}")
    #     for i in range(len(list(y_pred))):
    #         print(f"{list(y_pred)[i]} {test_result[i]}")

    # Lasso, подбираем alpha и degree
    # arr_degrees = [2, 3]
    # arr_alphes = [1, 5, 10, 50, 100, 200, 300, 500]
    # for degree in arr_degrees:
    #     for alpha in range(200):
    #         poly = PolynomialFeatures(degree=degree)
    #         data_ = poly.fit_transform(data)
    #         clf = Lasso(alpha=alpha*0.1)
    #         clf.fit(data_, result)
    #         y_pred = clf.predict(poly.fit_transform(test_data))
    #         scores = cross_val_score(clf, test_data, test_result, cv=5, scoring='neg_mean_squared_error')
    #         my_all_sc, sc_minor, sc_normal, sc_ns, sc_crit, sc_blocker = my_score(test_result, y_pred)
    #         print(
    #             f"{alpha}  {degree} : score = {mean(scores)}\t\tmy_score = {my_all_sc}\t\tminor = {sc_minor}\t\tnormal = {sc_normal}\t\tns = {sc_ns}\t\tcrit = {sc_crit}\t\tblocker = {sc_blocker}\n")
            # for i in range(len(list(y_pred))):
            #     print(f"{list(y_pred)[i]} {test_result[i]}")

    # Считаем y_predict, расскоментить нужный метод обучения
    # Линейная регрессия
    # lreg = LinearRegression()
    # lreg.fit(data, result)
    # y_pred = lreg.predict(test_data)
    # Ridge
    # ridgeR = Ridge(alpha=0.21)
    # ridgeR.fit(data, result)
    # y_pred = ridgeR.predict(test_data)
    #############
    # ard = ARDRegression()
    # ard.fit(data, result)
    # y_pred = ard.predict(test_data)
    #########
    poly = PolynomialFeatures(degree=3)
    data_ = poly.fit_transform(data)
    clf = Lasso(alpha=10.9)
    clf.fit(data_, result)
    y_pred = clf.predict(poly.fit_transform(test_data))
    #########
    scores = cross_val_score(clf, test_data, test_result, cv=5, scoring='neg_mean_squared_error')
    print(mean(scores))
    for i in range(len(list(y_pred))):
        print(f"{list(y_pred)[i]} {test_result[i]}")


    function = "F U N C T I O N: \n\n"
    coef = clf.coef_
    name = poly.get_feature_names()
    for i in range(0, len(name)):
        if coef[i]:
            data = '\n\t{} {},'.format(round(float(coef[i]), 5), name[i])
            data = data.replace('^2', '**2')
            data = data.replace('^3', '**3')
            function += data.replace(' ', ' * ')
    print(function)


    # тут считаем вес по новой формуле для тикетов по фильтру issues и записываем его в тикет
    # iss_data =[]
    # iss_results = []
    # iss_results_old = []
    # for iss in issues:
    #     iss_data.append([client.issues[iss.key].audience, client.issues[iss.key].importance,
    #                       float(client.issues[iss.key].reproducibility)])
    #     iss_results.append([client.issues[iss.key].weightOneHalf])
    #     iss_results_old.append([client.issues[iss.key].weightTwo])
    # predict = clf.predict(poly.fit_transform(iss_data))
    # for i in range(len(list(predict))):
    #     print(f"{list(predict)[i]} {iss_results[i]} {iss_results_old[i]}")
    #     bulk_change = client.bulkchange.update(
    #         issues[i],
    #         weightTwo=predict[i]
    #     )
    #     bulk_change = bulk_change.wait()
    #     print(bulk_change.status)


    return mean(scores), test_result, list(y_pred)


def my_score(y, y_test):
    # """
    # Оцениваем процент угаданных приоритетов
    # """
    sum = 0
    type = dict(minor=0, normal=0, ns=0, crit=0, blocker=1)
    score = dict(minor=0, normal=0, ns=0, crit=0, blocker=0)
    for i in range(0, len(y)):
        type_i, flag = bingo(y[i], y_test[i])
        type[type_i.value] += 1
        score[type_i.value] += int(flag)
        sum += int(flag)

    return float(sum / len(y)), \
           float(score['minor'] / type['minor']), \
           float(score['normal'] / type['normal']), \
           float(score['ns'] / type['ns']), \
           float(score['crit'] / type['crit']), \
           float(score['blocker'] / type['blocker'])


def get_weight_by_priority(priority):
    random.seed(1)
    if priority == Priority.MINOR:
        return random.randint(1, Weight.MINOR.value - 1)

    if priority == Priority.NORMAL:
        return random.randint(Weight.MINOR, Weight.NORMAL.value - 1)

    return random.randint(Weight.NORMAL.value, Weight.CRIT.value - 1)


def get_data():
    urllib3.disable_warnings()
    results = []
    data = []

    with open("data1.txt", 'r') as file:
        for line in file:
            data.append([float(x) for x in line.split()])

    with open("results1.txt", 'r') as file:
        for line in file:
            results.extend([float(x) for x in line.split()])

    return data, results


def main():
    warnings.filterwarnings("ignore")
    data, results = get_data()

    f = open('Summary.txt', 'w')
    r2, y_test, y_pred = prediction_and_get_formula(data, results)
    my_all_sc, sc_minor, sc_normal, sc_ns, sc_crit, sc_blocker = my_score(y_test, y_pred)
    f.write(
        f'score = {r2}\t\tmy_score = {my_all_sc}\t\tminor = {sc_minor}\t\tnormal = {sc_normal}\t\tns = {sc_ns}\t\tcrit = {sc_crit}\t\tblocker = {sc_blocker}\n')


if __name__ == "__main__":
    main()
