# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import calendar
import datetime
import json
import os
import time

import requests
import urllib3
import yaml
from retrying import retry
from startrek_client import Startrek

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

scriptPath = os.path.dirname(os.path.abspath(__file__))

QUEUES = {
    'DARIA': 'Почта Веб',
    'QUINN': 'Почта Тач',
    'MOBILEMAIL': 'Почта Моб',
    'CHEMODAN': 'Диск Веб',
    'DISCSW': 'Диск Десктоп',
    'MOBDISK': 'Диск Моб',
    'DOCVIEWER': 'Диск Веб',
    'MAYA': 'Календарь',
    'PASSP': 'Паспорт',
    'MOBDEVAUTH': 'АМ',
    'DV': 'Диск Веб',
    'VAULT': 'Паспорт',
}

TOTAL = "_total_"

QUEUES_WITHOUT_REBUILDS = [
    'CHEMODAN',
    'DISCSW',
    'MOBDISK',
    'DOCVIEWER',
    'MOBDEVAUTH',
    'DV',
]

PERIODS = {
    'January': 'Q1',
    'February': 'Q1',
    'March': 'Q1',
    'April': 'Q2',
    'May': 'Q2',
    'June': 'Q2',
    'July': 'Q3',
    'August': 'Q3',
    'September': 'Q3',
    'October': 'Q4',
    'November': 'Q4',
    'December': 'Q4',
}

ROBOTS = [
    "robot-gerrit",
    "robot-aqua-testpers robot-aqua-testpers",
    "zomb-mobmail-qa",
]

reportConf = yaml.load(open("%s/reportConf.yaml" % scriptPath))
yaconfig = yaml.load(open("%s/config.yaml" % scriptPath))

timeFormat = '%Y-%m-%dT%H:%M:%S'

client = Startrek(useragent="curl/7.53.1", token=yaconfig["myToken"])


def get_releases_info(queue):
    print(queue)
    if queue == 'PASSP':
        issues = client.issues.find(
            'Queue: "' + queue +
            '" AND (Type: release OR "Release Type": notEmpty()) AND Components: "%Фронтенд" AND ((Resolved: >= 01.03.2020 AND '
            'Resolution:! Duplicate AND Resolution:! Invalid AND Resolution:! "Won\'t fix" AND Resolution: ! "Will Not Fix"'
            ' AND Resolution: ! Incomplete) OR Status: Testing OR Status: "In Progress")'
        )
    else:
        issues = client.issues.find(
            'Queue: "' + queue +
            '" AND (Type: Release OR "Release Type": notEmpty()) AND (((Status: changed(to: Resolved date: >= 01.03.2020)'
            ' OR Resolved: >=  01.03.2020) AND Resolution:! Duplicate AND Resolution:! Invalid AND Resolution:! "Won\'t fix"'
            ' AND Resolution: ! "Will Not Fix" AND Resolution: ! Incomplete AND Resolution:! Later) OR Status: Testing OR Status: "In Progress" '
            'OR Status: "Tested" OR Status: "Open")'
            # 'Queue: "' + queue + '" AND Type: release AND Updated: >=now() - 3days AND (Status:Closed OR Status:Released)'
            # ' AND Resolution: Fixed' после отладки и запуска по крону заменить на это
        )
    for issue in issues:
        print(issue)
        fixVersionTickets = affectedVersionTickets = []
        updatesComment = list(client.issues[issue.key].changelog.get_all(type='IssueCommentAdded'))
        updatesWorkflow = list(client.issues[issue.key].changelog.get_all(type='IssueWorkflow'))

        fix_version = get_release_fixVersion(issue)
        # print(fix_version)
        fix_version_for_rqst = fix_version.replace('"', '\\"')

        if fix_version:
            fixVersionTickets = client.issues.find(
                'Queue: "%s" AND "Fix Version": "%s" AND "Key":! "%s" AND '
                'Resolution:! Duplicate AND Resolution:! Invalid AND Resolution:! "Won\'t fix" AND Resolution:! '
                '"Will Not Fix" AND Resolution: ! Incomplete' % (queue, fix_version_for_rqst, issue.key)
            )
            affectedVersionTickets = client.issues.find(
                'Queue: "%s" AND "Fix Version":! "%s" AND "Affected Version": "%s"' % (
                    queue, fix_version_for_rqst, fix_version_for_rqst)
            )

        releaseType = client.issues[issue.key].releaseType
        if not releaseType:
            releaseType = '-'
        qa, qaList = get_qa(issue)

        times = get_release_timings(issue, updatesComment, updatesWorkflow)
        ticketsCount = classify_tickets_in_release(queue, issue, fix_version_for_rqst, times, fixVersionTickets,
                                                   affectedVersionTickets)
        reopenCount = count_reopens(fix_version_for_rqst, updatesWorkflow, fixVersionTickets, affectedVersionTickets)
        if queue not in QUEUES_WITHOUT_REBUILDS:
            rebuildCount = count_rebuilds(updatesComment)
        else:
            rebuildCount = "-"

        if not fix_version:
            fix_version = client.issues[issue.key].summary

        deadline = get_deadline(issue)
        releaseNote = get_release_note(issue)

        data = {
            'release': fix_version,
            'release_type': releaseType,
            'date': times['closeTime'],
            'timing': times['testingTime'],
            'initial_tickets': ticketsCount['initialTicketCount'],
            'testing_bugs': ticketsCount['bugsInTesting'],
            'testing_other_types': ticketsCount['tasksInTesting'],
            'from_test_to_prod': ticketsCount['fromTestToProd'],
            'total_realese_tickets_count': ticketsCount['totalTicketsCountInRelease'],
            'good_tasks_testing': ticketsCount['goodTasksInTesting'],
            'rebuild_count': rebuildCount,
            'reopen_count': reopenCount,
            'ticket': issue.key,
            'qa': qa,
            'release_queue': queue,
            'release_for_rqst': fix_version_for_rqst,
            'deadline': deadline,
            'release_note': releaseNote
        }

        # if times['closeTime']:
        for q in [queue, TOTAL]:
            for period in [times['period'], TOTAL]:
                for month in [times['month'], TOTAL]:
                    for service in [QUEUES[queue], TOTAL]:
                        for tester in qaList:
                            send_to_stat(q, data, period, month, service, tester)
    # else:
    #     for q in [queue, TOTAL]:
    #         for service in [QUEUES[queue], TOTAL]:
    #             for tester in qaList:
    #                 send_to_stat(q, data, TOTAL, TOTAL, service, tester)


@retry(stop_max_attempt_number=1, wait_fixed=3000)
def get_release_fixVersion(issue):
    try:
        fix_version = client.issues[issue.key].fixVersions[0].display
    except IndexError:
        fix_version = ""
    return fix_version


@retry(stop_max_attempt_number=1, wait_fixed=3000)
def get_qa(issue):
    qaList = []
    qa = ''
    for tester in client.issues[issue.key].qa:
        qaList.append(tester.login)
        qa = ', '.join(qaList)
    if not qa:
        qa = '-'
        qaList.append(qa)
    qaList.append(TOTAL)
    return qa, qaList


@retry(stop_max_attempt_number=1, wait_fixed=3000)
def get_release_timings(issue, updatesComment, updatesWorkflow):
    # """
    # Считаем время начала и конца тестирования, выкатки и затраченное на тестирование
    # """
    closeTime = startTime = finishTestingTime = testingTime = 0
    month = period = ""
    exitCloseFlag = exitStartFlag = finishTestingTimeFlag = False
    if client.issues[issue.key].qaStartDate is not None:
        exitStartFlag = True
        startTime = datetime.datetime.strptime(client.issues[issue.key].qaStartDate, '%Y-%m-%d')
    if client.issues[issue.key].qaEndDate is not None:
        finishTestingTimeFlag = True
        finishTestingTime = datetime.datetime.strptime(client.issues[issue.key].qaEndDate, '%Y-%m-%d')
    for update in updatesWorkflow:
        if not exitCloseFlag:
            for field in update.fields:
                if field['field'].id != 'status':
                    continue
                if field['to'].name == 'Закрыт' or field['to'].name == 'Выложили' or field['to'].name == 'Released':
                    closeTime = datetime.datetime.strptime(update.updatedAt[:19], timeFormat)
                    exitCloseFlag = True
                    break
        if not exitStartFlag:
            for field in update.fields:
                if field['field'].id != 'status':
                    continue
                if field['to'].name == 'В работе' or field['to'].name == 'Тестируется':
                    startTime = datetime.datetime.strptime(update.updatedAt[:19], timeFormat)
                    exitStartFlag = True
                    break
        if not finishTestingTimeFlag:
            for field in update.fields:
                if field['field'].id != 'status':
                    continue
                if field['to'].name == 'Закрыт' or field['to'].name == 'Протестировано' \
                        or field['to'].name == 'Ready for Release' or field['to'].key == 'released':
                    finishTestingTime = datetime.datetime.strptime(update.updatedAt[:19], timeFormat)
                    finishTestingTimeFlag = True
                    break
        if exitCloseFlag and exitStartFlag and finishTestingTimeFlag:
            break

    if startTime == 0:  # или первый коммент робота о пакете
        for update in updatesComment:
            if str(update.updatedBy.id) in ROBOTS:
                startTime = datetime.datetime.strptime(update.updatedAt[:19], timeFormat)
                break

    if startTime == 0:  # и на крайний случай дату создания тикета
        startTime = datetime.datetime.strptime(client.issues[issue.key].createdAt[:19], timeFormat)

    # Считаем сколько релиз был в тестировании
    if startTime != 0 and finishTestingTime != 0:
        testingTime = abs(finishTestingTime - startTime).days + \
                      float(abs(finishTestingTime - startTime).seconds) / 86400
    if startTime != 0 and finishTestingTime == 0:
        testingTime = abs(datetime.datetime.now() - startTime).days + \
                      float(abs(datetime.datetime.now() - startTime).seconds) / 86400

    # Получаем месяц и квартал выкатки релиза
    if closeTime:
        month = calendar.month_name[closeTime.month]
        period = ' '.join((PERIODS[month], str(closeTime.year)))
    else:
        month = calendar.month_name[datetime.datetime.now().month]
        period = ' '.join((PERIODS[month], str(datetime.datetime.now().year)))

    return {
        'closeTime': closeTime,
        'startTime': startTime,
        'testingTime': testingTime,
        'month': month,
        'period': period
    }


@retry(stop_max_attempt_number=1, wait_fixed=3000)
def classify_tickets_in_release(queue, issue, fix_version, times, fixVersionTickets, affectedVersionTickets):
    # """
    # Классифицируем все тикеты релиза на: изначальные; баги, найденные в тестировании;
    # таски, заведённые в тестировании, баги, выкаченные в прод
    # Считаем количество тикетов, попавших в релиз
    # """
    goodTasksInTesting = initialTicketCount = bugsInTesting = tasksInTesting = fromTestToProd = totalTicketsCountInRelease = 0
    exitFlag = False
    if not fix_version:
        totalTicketsCountInRelease = initialTicketCount = 1
    else:
        for ticket in fixVersionTickets:
            versionTime = createTime = datetime.datetime.strptime(client.issues[ticket.key].createdAt[:19], timeFormat)
            # Находим количество тикетов, найденных в тестировании
            if createTime >= times['startTime'] and client.issues[ticket.key].type.key == 'bug' \
                    and client.issues[ticket.key].stage == 'Testing':
                bugsInTesting += 1
                continue
            if client.issues[ticket.key].type.key == 'bug' and client.issues[ticket.key].stage == 'Testing' and \
                    (not client.issues[ticket.key].affectedVersions or
                     client.issues[ticket.key].affectedVersions[0].name == fix_version):
                bugsInTesting += 1
                continue

            if createTime >= times['startTime'] and client.issues[ticket.key].type.key != 'bug':
                tags = list(client.issues[ticket.key].tags)
                for tag in tags:
                    if tag == 'тело_релиза':
                        goodTasksInTesting += 1
                    else:
                        tasksInTesting += 1
                continue


            # Находим количество тикетов на начало тестирования
            updates = list(client.issues[ticket.key].changelog.get_all(type='IssueUpdated'))
            for update in updates:
                for field in update.fields:
                    if not field or type(field['to']) != dict:
                        continue
                    if field['field'].id == "fixVersions" and field['to'][0].name == fix_version:
                        versionTime = datetime.datetime.strptime(update.updatedAt[:19], timeFormat)
                        exitFlag = True
                        break
                if exitFlag:
                    break
            if versionTime <= times['startTime']:
                initialTicketCount += 1

        # Находим количество тикетов, вынесенных из релиза
        for ticket in affectedVersionTickets:
            if client.issues[ticket.key].stage == 'Testing' or client.issues[ticket.key].stage == 'FromTestToProd':
                fromTestToProd += 1

        # Находим общее количество тикетов, протестированных в релизе (без релизного тикета)
        totalTicketsCountInRelease = len(client.issues.find(
            'Queue: "%s" AND "Fix Version": "%s" AND (Status: Tested OR Status: Released OR Status: Closed) AND "Key":! "%s"'
            % (queue, fix_version, issue.key)
        ))
        if totalTicketsCountInRelease == 0:
            totalTicketsCountInRelease = 1
        if initialTicketCount == 0 and totalTicketsCountInRelease == 1:
            initialTicketCount = 1


    return {
        'initialTicketCount': initialTicketCount,
        'bugsInTesting': bugsInTesting,
        'tasksInTesting': tasksInTesting,
        'fromTestToProd': fromTestToProd,
        'totalTicketsCountInRelease': totalTicketsCountInRelease,
        'goodTasksInTesting': goodTasksInTesting
    }


@retry(stop_max_attempt_number=1, wait_fixed=3000)  # сколько раз пересобирался пакет(1ая сборка не считается)
def count_rebuilds(updatesComment):
    rebuildCount = 0
    for update in updatesComment:
        if str(update.updatedBy.id) in ROBOTS:
            rebuildCount += 1
    return rebuildCount


@retry(stop_max_attempt_number=1, wait_fixed=3000)
def count_reopens(fix_version, updatesWorkflow, fixVersionTickets, affectedVersionTickets):
    # """
    # Считаем сколько раз переоткрывались все тикеты релиза
    # """
    reopenCount = 0
    if not fix_version:
        inner_loop_for_count_reopens(updatesWorkflow, reopenCount)
    else:
        for ticket in fixVersionTickets:
            updates = list(client.issues[ticket.key].changelog.get_all(type='IssueWorkflow'))
            reopenCount = inner_loop_for_count_reopens(updates, reopenCount)
        for ticket in affectedVersionTickets:
            updates = list(client.issues[ticket.key].changelog.get_all(type='IssueWorkflow'))
            reopenCount = inner_loop_for_count_reopens(updates, reopenCount)
    return reopenCount


def inner_loop_for_count_reopens(updates, reopenCount):
    for update in updates:
        for field in update.fields:
            if field['field'].id == 'status' and (field['to'].key == 'open' or field['to'].key == 'inProgress') and \
                    (field['from'].key == 'testing' or field['from'].key == 'resolved' or field[
                        'from'].key == 'tested' or field['from'].key == 'tesingInDev'):
                reopenCount += 1
    return reopenCount

@retry(stop_max_attempt_number=1, wait_fixed=3000)
def get_deadline(issue):
    deadline = client.issues[issue.key].deadline
    return deadline

@retry(stop_max_attempt_number=1, wait_fixed=3000)
def get_release_note(issue):
    release_note = ''
    release_note = client.issues[issue.key].releaseNotes
    return release_note


@retry(stop_max_attempt_number=3, wait_fixed=3000)
def send_to_stat(queue, info, period, month, service, tester):
    data = [
        {
            "fielddate": time.strftime(str("%Y-%m-%d")),
            "queue": queue.lower(),
            "release": info['release'],
            "month": month,
            "period": period,
            "release_type": info['release_type'],
            "date": str(info['date']),
            "timing": info['timing'],
            "initial_tickets": info['initial_tickets'],
            "total_realese_tickets_count": info['total_realese_tickets_count'],
            "testing_bugs": info['testing_bugs'],
            "testing_other_types": info['testing_other_types'],
            "from_test_to_prod": info['from_test_to_prod'],
            "rebuild_count_new": str(info['rebuild_count']),
            "reopen_count_new": str(info['reopen_count']),
            "ticket": info['ticket'],
            "qa": tester,
            "release_queue": info['release_queue'],
            "release_for_rqst": info['release_for_rqst'],
            "service": service,
            "qa_team": info['qa'],
            "deadline": info['deadline'],
            "release_note": info['release_note'],
            "good_tasks_testing": info['good_tasks_testing']
        }
    ]
    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]},
        data={
            'name': 'Mail/Others/ReleaseStat',
            'scale': 'd',
            'data': json.dumps({'values': data}),
        },
    )
    print (r.status_code)
    attempt_number = 1
    while r.status_code != 200 and attempt_number < 5:
        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]},
            data={
                'name': 'Mail/Others/ReleaseStat',
                'scale': 'd',
                'data': json.dumps({'values': data}),
            },
        )
        print (r.status_code)
        attempt_number += 1
    # print (r.text)


if __name__ == '__main__':
    for project in QUEUES:
        get_releases_info(project)
