import json
import logging
import os
import re
import sys
from pathlib import Path

import requests
import urllib3
from retrying import retry
from startrek_client import Startrek

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

sys.path.append(str(Path(__file__).parent.parent.parent))
from set_secret import set_secret

set_secret.set_secrets()

client = Startrek(useragent='curl/7.53.1', token=os.environ['STARTRECK_TOKEN'])

services = {
    'QUINN': {
        'testpalm_project': 'mail-touch',
        'resp': ['569e51dcc612331b6162ae33'],
        'smokes': [
            '5c86262fbb9745a7302f3347',
            '5c9885bcf77a61a201156725',
        ],
        'smoke_config': {
            'android phone': {'browser': 'yandex browser', 'settings': 'tabs'},
            'android tablet': {'browser': 'chrome', 'settings': ''},
            'ipad': {'browser': 'safari', 'settings': 'tabs'},
            'iphone': {'browser': 'searchApp', 'settings': ''}
        },
        'service': 'touch',
        'version_config_name': ['Тач'],
        'duty': ['oleshko']
    },
    'DARIA': {
        'testpalm_project': 'mail-liza',
        'resp': ['562e38c5e4b0ef8ed6d11333', '5f75915984b71d00116043a5'],
        'smokes': [
            '5c76d647a4847da13784f8c7',
            '5c76d663a4847da13784f8d2',
            '5c76d673bb580fbc93e17c67',
        ],
        'smoke_config': [
            'Firefox',
            'IE',
            'Yandex Browser'
        ],
        'service': 'liza',
        'version_config_name': ['БП'],
    },
    'MAYA': {
        'testpalm_project': 'cal',
        'resp': ['5845612c88955059c6e1d82e', '5f181f3ce1ff18c463378ea1', '5dd3c53d3d42cb93aafbcc95',
                 '5e45091488c6ba16e1671edb', ],
        'smokes': [],
        'smoke_config': {
            'web': ['Yandex Browser'],
            'touch': ['iOS Smart', 'Android Smart']
        },
        'service': 'cal',
        'version_config_name': ['touch', 'pub', 'corp'],
        'duty': ['robot-pinkie-pie']
    },
    'HOMER': {
        'testpalm_project': 'mail-hostroot',
        'resp': ['56797785c612332a9dc0519a', '5a588bc0cb0daea48ade90ed'],
        'smokes': [],
        'service': 'liza',
    }
}

statuses_texts = {
    'autotests': {
        'ok': 'Автотесты запущены на стенде',
        'error': 'Автотесты запустить не удалось Error:'
    },
    'assessors': {
        'ok': 'Ассессоры запущены для',
        'error': 'Не удалось запустить асcессоров'
    },
    'stand': {
        'ok': 'Стенд добавлен в список ночных автотестов',
        'error': 'Добавить стенд в список ночных автотестов не удалось Error:'
    },
    'testpalm': {
        'ok': 'Версия в пальме создана',
        'error': 'С созданием версии в пальме что-то пошло не так. Error:'
    },
    'assign': {
        'error': 'Не удалось заасайнить тикет на'
    },
}

testpalm_host = 'https://testpalm-api.yandex-team.ru/'
st_host = 'https://st-api.yandex-team.ru/v2/'
host = 'https://tomato.mail.yandex.net/'
headers_testpalm = {'Authorization': f'OAuth {os.environ["TESTPALM_OAUTH"]}',
                    'Content-Type': 'application/json'}
headers_st = {'Authorization': 'OAuth ' + os.environ['STARTRECK_TOKEN']}
abc_host = 'https://abc-back.yandex-team.ru/api/v4/'
abc_headers = {'Authorization': 'OAuth ' + os.environ['ABC_TOKEN']}


@retry(stop_max_attempt_number=2)
def assign_ticket(queue, issue):
    """
       Для БП засинкано с календарём дужурств https://abc.yandex-team.ru/services/mail_frontend/duty/?role=2472
       Для тача всегда oleshko
       Для календаря - marchart
    """
    if queue == 'DARIA':
        r = requests.get(
            f'{abc_host}duty/on_duty/?service=1652&schedule__slug=liza_test&fields=person.login',
            headers=abc_headers,
            verify=False
        ).json()
        on_duty_login = r[0]['person']['login']
    else:
        on_duty_login = services[queue]['duty'][0]
    bulk_change = client.bulkchange.update(
        [issue.key],
        assignee=on_duty_login,
        qa=on_duty_login
    )
    bulk_change = bulk_change.wait()
    logging.info(' Startrek response: %s' % bulk_change.status)
    if bulk_change.status == 'COMPLETE':
        comment_text = ''
    else:
        comment_text = statuses_texts['assign']['error'] + f' {on_duty_login} Error: {bulk_change.status} \n\n'
    return comment_text


def get_version(issue):
    try:
        version_name = client.issues[issue.key].fixVersions[0].display
    except IndexError:
        version_name = client.issues[issue.key].summary.replace(u'Релиз ', '')
    return version_name


def create_testpalm_version(queue, issue, is_retry):
    """
    Create version in testpalm
    Add suites
    Create 'responsible for the release' run
    """
    version_name = get_version(issue)

    # add testsuites to version
    url = f'{testpalm_host}version/{services[queue]["testpalm_project"]}'
    data = {
        'id': version_name,
        'suites': services[queue]['smokes'] + services[queue]['resp']
        # 'trackerVersion': {
        #     'groupId': queue,
        #     'title': version_name.display,
        #     'trackerId': 'Startrek',
        #     'versionId': version_name.id,
        #     'url': f'https://st.yandex-team.ru/{queue}/filter?fixVersions={version_name.id}'
        # } Это могло бы провязавать версию в пальме с версией в стартреке, но через апи это сейчас не работает https://st.yandex-team.ru/TESTPALM-2594
    }
    raw_data = json.dumps(data, ensure_ascii=False, separators=(',', ': ')).encode('utf-8')
    r = requests.post(url, headers=headers_testpalm, verify=False, data=raw_data)
    logging.info(' Testpalm response: %s' % r.text)
    if r.status_code != 200 and r.text.find("duplicate key error") == -1:
        if is_retry:
            return ''
        else:
            return statuses_texts['testpalm']['error'] + f' {r.text} \n\n'

    url = f'{testpalm_host}testrun/{services[queue]["testpalm_project"]}/create'
    for suit_id in services[queue]['resp']:
        # get testsuit name
        suit = requests.get(
            f'{testpalm_host}testsuite/{services[queue]["testpalm_project"]}/{suit_id}',
            headers=headers_testpalm,
            verify=False,
        ).json()
        logging.info(' Testpalm response: %s' % r.text)

        # create runs for testsuits
        data = {
            'testSuite': {
                'id': suit_id,
                'ignoreSuiteOrder': 'false'
            },
            'version': version_name,
            'title': f'{version_name}-' + suit['title']
        }
        raw_data = json.dumps(data, ensure_ascii=False, separators=(',', ': ')).encode('utf-8')
        r = requests.post(url, headers=headers_testpalm, verify=False, data=raw_data)
        logging.info(' Testpalm response: %s' % r.text)
        if r.status_code != 200:
            if is_retry:
                return ''
            else:
                return statuses_texts['testpalm']['error'] + f' {r.text} \n\n'

    # create smoke runs
    if queue == 'HOMER':
        return statuses_texts['testpalm']['ok'] + ' \n\n'
    i = 0
    for env in services[queue]['smoke_config']:
        if queue == 'QUINN':
            smoke = requests.get(
                f'{testpalm_host}testsuite/{services[queue]["testpalm_project"]}/{services[queue]["smokes"][i % 2]}',
                headers=headers_testpalm,
                verify=False
            ).json()
            browser = services[queue]['smoke_config'][env]['browser']
            data = {
                'testSuite': {
                    'id': services[queue]['smokes'][i % 2],
                    'ignoreSuiteOrder': 'false'
                },
                'tags': browser,
                'environments': [{
                    'title': env
                }],
                'version': version_name,
                'title': f'{version_name}-{browser}-{smoke["title"]}-{services[queue]["smoke_config"][env]["settings"]}'
            }
        if queue == 'DARIA':
            smoke = requests.get(
                f'{testpalm_host}testsuite/{services[queue]["testpalm_project"]}/{services[queue]["smokes"][i]}',
                headers=headers_testpalm,
                verify=False
            ).json()
            data = {
                'testSuite': {
                    'id': services[queue]['smokes'][i],
                    'ignoreSuiteOrder': 'false'
                },
                'version': version_name,
                'title': f'{version_name}-{smoke["title"]}'
            }
        if queue == 'MAYA':
            break
            # j = random.randint(0, len(services[queue]["smoke_config"][env]) - 1)
            # smoke = requests.get(
            #     f'{testpalm_host}testsuite/{services[queue]["testpalm_project"]}/{services[queue]["smokes"][i]}',
            #     headers=headers_testpalm,
            #     verify=False
            # ).json()
            # data = {
            #     'testSuite': {
            #         'id': services[queue]['smokes'][i],
            #         'ignoreSuiteOrder': 'false'  # не работает https://st.yandex-team.ru/TESTPALM-2344
            #     },
            #     'environments': [{
            #         'title': services[queue]["smoke_config"][env][j]
            #     }],
            #     'version': version_name,
            #     'title': f'{version_name}-{smoke["title"]}'
            # }
        raw_data = json.dumps(data, ensure_ascii=False, separators=(',', ': ')).encode('utf-8')
        r = requests.post(url, headers=headers_testpalm, verify=False, data=raw_data)
        logging.info(' Testpalm response: %s' % r.text)
        i += 1

    if r.status_code == 200:
        return statuses_texts['testpalm']['ok'] + ' \n\n'
    elif is_retry:
        return ''
    else:
        return statuses_texts['testpalm']['error'] + f' {r.text} \n\n'


@retry(stop_max_attempt_number=2)
def change_ticket_status(issue):
    url = f'{st_host}issues/{issue.key}/transitions/testing/_execute'
    r = requests.post(url, headers=headers_st, verify=False)
    logging.info(' Startrek response: %s' % r.text)


@retry(stop_max_attempt_number=2)
def run_autotests(queue, issue, is_retry, category=''):
    url = f'{host}api/run_now'
    if queue == 'MAYA':
        data = {
            'stand': 'calendar.qa.yandex.ru',
            'corp_stand': 'calendar.qa.yandex-team.ru',
            'issueKey': issue.key,
            'service': services[queue]['service'],
            'emails': client.issues[issue.key].assignee.email
        }
    else:
        data = {
            'stand': client.issues[issue.key].standUri,
            'corp_stand': client.issues[issue.key].standUri \
                .replace('https://', '') \
                .replace('yandex', 'yandex-team') \
                .replace('.qa', '-corp.qa'),
            'issueKey': issue.key,
            'service': services[queue]['service'],
            'emails': client.issues[issue.key].assignee.email
        }
    if category != '':
        data['category'] = category
    raw_data = json.dumps(data, ensure_ascii=False, separators=(',', ': ')).encode('utf-8')
    r = requests.post(url, verify=False, data=raw_data)
    logging.info(' Tomato response: %s' % r.text)
    if r.status_code == 200:
        return statuses_texts['autotests']['ok'] + f' {client.issues[issue.key].standUri} \n\n'
    elif is_retry:
        return ''
    else:
        return statuses_texts['autotests']['error'] + f' {r.text} \n\n'


@retry(stop_max_attempt_number=2)
def run_assessors(queue, issue, is_retry):
    version_name = get_version(issue)
    version = client.issues[issue.key].summary.replace(u'Релиз ', '').replace('_', '.')
    url = f'{host}api/run_assessors'
    for version_config_name in services[queue]['version_config_name']:
        data = {
            'testpalm': version_name,
            'service': services[queue]['testpalm_project'],
            'special_conditions': '',
            'stand': client.issues[issue.key].standUri.replace('https://', ''),
            'requester': client.issues[issue.key].assignee.login,
            'version_config_name': version_config_name,
        }
        if queue == 'DARIA':
            data['booking_mode'] = 'regular'
        else:
            data['booking_mode'] = 'new'
        raw_data = json.dumps(data, ensure_ascii=False, separators=(',', ': ')).encode('utf-8')
        r = requests.post(url, verify=False, data=raw_data)
        logging.info(' Tomato response: %s' % r.text)
        if r.status_code == 200:
            return statuses_texts['assessors']['ok'] + f' {version_config_name} \n\n'
        elif is_retry:
            return ''
        else:
            return statuses_texts['assessors']['error'] + f' {version_config_name}, Error:{r.text} \n\n'


@retry(stop_max_attempt_number=2)
def add_stand_to_nightly_runner(queue, is_retry):
    corp_stand = client.issues[issue.key].standUri \
        .replace('https://', '') \
        .replace('yandex', 'yandex-team') \
        .replace('.qa', '-corp.qa')
    url = f'{host}?action=add'
    if queue == 'MAYA':
        data = {
            'stand': 'calendar.qa.yandex.ru',
            'corp_stand': 'calendar.qa.yandex-team.ru',
            'emails': client.issues[issue.key].assignee.email,
            'service': services[queue]['service']
        }
    else:
        data = {
            'stand': client.issues[issue.key].standUri.replace('https://', ''),
            'corp_stand': corp_stand,
            'emails': client.issues[issue.key].assignee.email,
            'service': services[queue]['service']
        }
    r = requests.post(url, verify=False, data=data)
    logging.info(' Tomato response: %s' % r.text)
    if r.status_code == 200:
        return statuses_texts['stand']['ok'] + f' {data["stand"]}\n\n'
    elif is_retry:
        return ''
    else:
        return statuses_texts['stand']['error'] + f' {r.text} \n\n'


def close_tickets_after_release(queue, issue):
    comment_text = ''
    fix_version_for_rqst = get_version(issue).replace('"', '\\"')
    bulk_change = client.bulkchange.transition(
        client.issues.find(
            f'Queue: {queue} AND "Fix Version": {fix_version_for_rqst} AND Resolution: empty()'
        ),
        transition='close',
        resolution='fixed'
    )
    bulk_change = bulk_change.wait()
    if bulk_change.status == 'COMPLETE' and \
            len(client.issues.find(
                f'Queue: {queue} AND "Fix Version": {fix_version_for_rqst} AND Resolution: empty()')) == 0:
        return f'Закрыл все тикеты версии {fix_version_for_rqst}\n\n'
    else:
        return 'Later'


# @retry(stop_max_attempt_number=5)
# def delete_stand_from_nightly_runner(queue):
# todo: delete stand from nightly runner after release

@retry(stop_max_attempt_number=3)
def add_comment(issue, text):
    client.issues[issue.key].comments.create(text=text)
    logging.info('	create comment: %s' % text)


@retry(stop_max_attempt_number=3)
def move_version_to_archive(issue):
    comment_text = ''
    version_id = client.issues[issue.key].fixVersions[0].id
    url = f'{st_host}/versions/{version_id}/_archive'
    r = requests.post(url, headers=headers_st, verify=False)
    logging.info(' Startrek response: %s' % r.text)
    if r.status_code == 200:
        comment_text = 'Версия удалена из списка активных версий \n\n'
    return comment_text


def is_retry(option, all_comments_text):
    if statuses_texts[option]['error'] not in all_comments_text == -1:
        return False
    else:
        return True


if __name__ == '__main__':
    for queue in ['QUINN', 'DARIA', 'MAYA']:
        issues = client.issues.find(
            f'Queue: {queue} AND Type: Release AND (Status: Open OR Status: "Ready for test") AND "Test url": notEmpty() '
            f'AND Components:!Гомер'
        )
        for issue in issues:
            if queue == 'MAYA' or re.match(r'(.*)-rc-(.*).qa.mail.yandex.ru(.*)', client.issues[issue.key].testUrl):
                print(issue.key)
                all_comments_text = ''
                new_comment_text = ''
                comments = list(client.issues[issue.key].comments.get_all())
                for i in range(len(comments)):
                    all_comments_text += comments[i].text
                if queue != 'MAYA':
                    new_comment_text += assign_ticket(queue, issue)
                if statuses_texts['autotests']['ok'] not in all_comments_text:
                    new_comment_text += run_autotests(queue, issue, is_retry('autotests', all_comments_text))
                if statuses_texts['assessors']['ok'] not in all_comments_text and queue != 'MAYA':
                    new_comment_text += run_assessors(queue, issue, is_retry('assessors', all_comments_text))
                    # todo: перезапускать только окружение с ошибкой
                if statuses_texts['stand']['ok'] not in all_comments_text:
                    new_comment_text += add_stand_to_nightly_runner(queue, is_retry('stand', all_comments_text))
                if statuses_texts['testpalm']['ok'] not in all_comments_text:
                    new_comment_text += create_testpalm_version(queue, issue, is_retry('testpalm', all_comments_text))
                if new_comment_text != '':
                    add_comment(issue, new_comment_text)
                    if 'Error' not in new_comment_text:
                        change_ticket_status(issue)

        issues = client.issues.find(
            f'Queue: {queue} AND Type: Release AND (Status: Open OR Status: "Ready for test") AND "Test url": notEmpty() '
            f'AND Components:Гомер'
        )
        for issue in issues:
            if re.match(r'(.*)-rc-(.*).qa.mail.yandex.ru(.*)', client.issues[issue.key].testUrl):
                all_comments_text = ''
                new_comment_text = ''
                comments = list(client.issues[issue.key].comments.get_all())
                for i in range(len(comments)):
                    all_comments_text += comments[i].text
                new_comment_text += assign_ticket(queue, issue)
                if statuses_texts['autotests']['ok'] not in all_comments_text:
                    new_comment_text += run_autotests('DARIA', issue, is_retry('autotests', all_comments_text), 'homer')
                if statuses_texts['testpalm']['ok'] not in all_comments_text:
                    new_comment_text += create_testpalm_version('HOMER', issue, is_retry('testpalm', all_comments_text))
                if new_comment_text != '':
                    add_comment(issue, new_comment_text)
                if 'Error' not in new_comment_text:
                    change_ticket_status(issue)

        issues = client.issues.find(
            f'Queue: {queue} AND Type: Release AND Status: Closed AND "resolved":  >= now() - 1day'
        )
        for issue in issues:
            all_comments_text = ''
            new_comment_text = ''
            comments = list(client.issues[issue.key].comments.get_all())
            for comment in comments:
                all_comments_text += comment.text
            try:
                version_name = client.issues[issue.key].fixVersions[0]
                if 'Закрыл все тикеты версии' not in all_comments_text:
                    new_comment_text += close_tickets_after_release(queue, issue)
                if new_comment_text == 'Later':
                    continue
                if 'Версия удалена из списка'not in all_comments_text:
                    new_comment_text += move_version_to_archive(issue)
            except IndexError:
                if 'У релизного тикета нет версии' not in all_comments_text == -1:
                    new_comment_text = 'У релизного тикета нет версии, заполни поле Fix version!'
            if new_comment_text != '':
                add_comment(issue, new_comment_text)
