# -*- coding: utf-8 -*-

import calendar
import datetime
import json
import os

import requests
import yaml
from startrek_client import Startrek

import config

scriptPath = os.path.dirname(os.path.abspath(__file__))

yaconfig = yaml.load(open(os.path.dirname(scriptPath) + "/StartrekStat/config.yaml"))
projects = yaml.load(open(os.path.dirname(scriptPath) + "/StartrekStat/reportConfSum.yaml"))

project_settings = config.project_settings

client = Startrek(useragent="curl/7.53.1", token=yaconfig["AUTH_ST"])


def send_to_stat():
    data = [
        {
            "fielddate": str(month_date),
            "tested_feature": tested_feature,
            "tested_bug": tested_bug,
            "create_test_bug": create_test_bug,
            "create_prod_bug": create_prod_bug,
            "create_case": create_case,
            "auto_case": auto_case,
            "tested_release": tested_release,
            "run_case": run_case,
            "asessor": asessor,
            "run_auto": run_auto,
            "run_manual": run_manual,
            "run_asessor": run_asessor,
            "av_runned_autotests": av_runned_autotests,
            "create_case_asessor": create_case_asessor,
            "create_case_intern": create_case_intern,
            "auto_case_intern": auto_case_intern,
            "auto_case_dev": auto_case_dev,
            "review": review,
            "infra_qa": infra_qa,
            "infra_dev": infra_dev,
            "infra_intern": infra_intern,
            "auto_qa": auto_qa,
            "auto_dev": auto_dev,
            "auto_intern": auto_intern,
            "analytics_qa": analytics_qa,
            "analytics_dev": analytics_dev,
            "analytics_intern": analytics_intern,
            "internal_qa": internal_qa,
            "internal_dev": internal_dev,
            "internal_intern": internal_intern,
            "tested_asessor": tested_asessor,
            "asessors_prod_bugs": asessors_prod_bugs,
            "support": support
        }
    ]
    print data

    attempt_number = 1
    while attempt_number < 5:
        req = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]},
            data={
                'name': 'Adhoc/testing_time_sum',
                'scale': 'm',
                'data': json.dumps({'values': data}),
            },
        )
        print req.status_code
        if req.status_code == 200:
            break
        attempt_number += 1


if __name__ == '__main__':

    for i in xrange(config.month, config.month + 1, 1):
        # for i in xrange(4, 13, 1):

        month = i

        if month == 0:
            month = datetime.datetime.now().month

        year = datetime.datetime.now().year
        # year = config.year

        date_today = datetime.datetime.now()
        last_month_day = calendar.monthrange(year, month)[1]
        month_first_day = date_today.replace(month=month, year=year, day=1, hour=0, minute=0, second=0, microsecond=0)
        month_date = datetime.date.today().replace(month=month, year=year, day=1)
        date_max = datetime.date.today().replace(month=month, year=year, day=last_month_day)

        r = requests.get(
            'https://upload.stat.yandex-team.ru/_api/statreport/json/Adhoc/test-mail?scale=m&date_mах=%s' %
            date_max,
            headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]}).json()

        summary_list = []
        tested_feature = 0
        create_prod_bug = 0
        tested_bug = 0
        create_test_bug = 0
        create_case = 0
        tested_release = 0
        run_case = 0
        asessor = 0
        auto_case = 0
        run_auto = 0
        run_manual = 0
        run_asessor = 0
        av_runned_autotests = 0
        auto_case_intern = 0
        auto_case_dev = 0
        create_case_asessor = 0
        create_case_intern = 0
        infra_qa = 0
        infra_dev = 0
        infra_intern = 0
        auto_qa = 0
        auto_dev = 0
        auto_intern = 0
        analytics_qa = 0
        analytics_dev = 0
        analytics_intern = 0
        internal_qa = 0
        internal_dev = 0
        internal_intern = 0
        tested_asessor = 0
        asessors_prod_bugs = 0
        support = 0

        createTime = 0.5
        createTimeTesting = 0.25
        testBug = 4
        testFeature = 8
        createTC = 0.25
        automateTC = 2.5
        release = 5
        runTC = 0.05
        review = 1

        for i in r.get('values'):
            if i.get('fielddate') == str(month_first_day):
                if i.get('project') != u'MOBILEMAIL iOS' and i.get('project') != u'MOBILEMAIL Android' and i.get(
                        'project') != u'MOBDISK iOS' and i.get('project') != u'MOBDISK Android':
                    tested_feature += i.get('tested_feature') * testFeature
                    create_prod_bug += i.get('create_prod_bug') * createTime
                    tested_bug += i.get('tested_bug') * testBug
                    create_test_bug += i.get('create_test_bug') * createTimeTesting
                    create_case += i.get('create_case') * createTC
                    tested_release += i.get('tested_release') * release
                    asessor += i.get('asessor') / 60
                    run_case += i.get('run_case') * runTC
                    run_auto += i.get('run_auto') * runTC
                    run_manual += i.get('run_manual') * runTC
                    run_asessor += i.get('run_asessor') * runTC
                    av_runned_autotests += i.get('av_runned_autotests') * runTC
                    if i.get('project') == 'MOBILEMAIL' or i.get('project') == 'MOBDISK':
                        if i.get('auto_case_intern') is None:
                            auto_case_intern += 0
                        else:
                            auto_case_intern += i.get('auto_case_intern') * 4
                        if i.get('auto_case_dev') is None:
                            auto_case_dev += 0
                        else:
                            auto_case_dev += i.get('auto_case_dev') * 4
                        auto_case += i.get('auto_case') * 4
                    else:
                        if i.get('auto_case_intern') is None:
                            auto_case_intern = 0
                        else:
                            auto_case_intern += i.get('auto_case_intern') * 2.5
                        if i.get('auto_case_dev') is None:
                            auto_case_dev = 0
                        else:
                            auto_case_dev += i.get('auto_case_dev') * 2.5
                        auto_case += i.get('auto_case') * 2.5

                    if i.get('create_case_asessor') is None:
                        create_case_asessor = +0
                    else:
                        create_case_asessor += i.get('create_case_asessor') * 0.25
                    if i.get('create_case_intern') is None:
                        create_case_intern += 0
                    else:
                        create_case_intern += i.get('create_case_intern') * 0.25
                    if i.get('project') == 'MOBILEMAIL' or i.get('project') == 'MOBDISK' or i.get(
                            'project') == 'CHEMODAN, DOCVIEWER':
                        review += i.get('review')
                    elif i.get('project') == 'DISCSW':
                        review += 0
                    else:
                        review += i.get('review') * 2
                    infra_qa += i.get('infra_qa')
                    infra_dev += i.get('infra_dev')
                    infra_intern += i.get('infra_intern')

                    auto_qa += i.get('auto_qa')
                    auto_dev += i.get('auto_dev')
                    auto_intern += i.get('auto_intern')

                    analytics_qa += i.get('analytics_qa')
                    analytics_dev += i.get('analytics_dev')
                    analytics_intern += i.get('analytics_intern')

                    internal_qa += i.get('internal_qa')
                    internal_dev += i.get('internal_dev')
                    internal_intern += i.get('internal_intern')

                    tested_asessor += i.get('tested_asessor')
                    asessors_prod_bugs += i.get('asessors_prod_bugs') * createTime
                    support += i.get('support')

        send_to_stat()
