# -*- coding: utf-8 -*-

import datetime
import json
import os
import calendar

import requests
import yaml
from startrek_client import Startrek

import configIntern as config

scriptPath = os.path.dirname(os.path.abspath(__file__))

yaconfig = yaml.load(open(os.path.dirname(scriptPath) + "/StartrekStat/config.yaml"))
projects = yaml.load(open(os.path.dirname(scriptPath) + "/StartrekStat/reportConfSum.yaml"))

project_settings = config.project_settings

client = Startrek(useragent="curl/7.53.1", token=yaconfig["AUTH_ST"])

month = config.month

if month == 0:
    month = datetime.datetime.now().month

date_today = datetime.datetime.now()
last_month_day = calendar.monthrange(datetime.datetime.now().year, month)[1]
month_first_day = date_today.replace(month=month, day=1, hour=0, minute=0, second=0, microsecond=0)
month_date = datetime.date.today().replace(month=month, day=1)
date_max = datetime.date.today().replace(month=month, day=last_month_day)

r = requests.get(
    'https://upload.stat.yandex-team.ru/_api/statreport/json/Adhoc/test-mail-intern?scale=m&date_mах=%s' %
    date_max,
    headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]}).json()

summary_list = []
tested_feature = 0
create_prod_bug = 0
tested_bug = 0
create_test_bug = 0
create_case = 0
tested_release = 0
run_case = 0
asessor = 0
auto_case = 0
run_auto = 0
run_manual = 0
run_asessor = 0
av_runned_autotests = 0
employee_num = 0

for i in r.get('values'):
    if i.get('fielddate') == str(month_first_day):
        if i.get('project') != u'MOBILEMAIL iOS' and i.get('project') != u'MOBILEMAIL Android' and i.get('project') != u'MOBDISK iOS' and i.get('project') != u'MOBDISK Android':
            tested_feature += i.get('tested_feature') * 8
            create_prod_bug += i.get('create_prod_bug') * 0.5
            tested_bug += i.get('tested_bug') * 4
            create_test_bug += i.get('create_test_bug') * 0.25
            create_case += i.get('create_case') * 0.25
            run_manual += i.get('run_manual') * 0.05
            if i.get('project') == 'MOBILEMAIL' or i.get('project') == 'MOBDISK':
                auto_case += i.get('auto_case') * 4
            else:
                auto_case += i.get('auto_case') * 2.5
            employee_num = i.get('employees_num')


def send_to_stat():
    data = [
        {
            "fielddate": str(month_date),
            "tested_feature": tested_feature,
            "tested_bug": tested_bug,
            "create_test_bug": create_test_bug,
            "create_prod_bug": create_prod_bug,
            "create_case": create_case,
            "auto_case": auto_case,
            "run_manual": run_manual,
            "employees_num": employee_num
        }
    ]
    print data

    attempt_number = 1
    while attempt_number < 5:
        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]},
            data={
                'name': 'Adhoc/testing_time_sum_intern',
                'scale': 'm',
                'data': json.dumps({'values': data}),
            },
        )
        print r.status_code
        if r.status_code == 200:
            break
        attempt_number += 1


send_to_stat()
