# -*- coding: utf-8 -*-

import calendar
import datetime
import os
import sys

import requests
import yaml

reload(sys)
sys.setdefaultencoding('utf-8')

scriptPath = os.path.dirname(os.path.abspath(__file__))

yaconfig = yaml.load(open(os.path.dirname(scriptPath) + "/StartrekStat/config.yaml"))

month = 0

if month == 0:
    month = datetime.datetime.now().month

year = datetime.datetime.now().year
# year = 2020

date_today = datetime.datetime.now()
last_month_day = calendar.monthrange(year, month)[1]
month_first_day = date_today.replace(month=month, day=1, year=year, hour=0, minute=0, second=0, microsecond=0)
month_date = datetime.date.today().replace(month=month, year=year, day=1)
date_max = datetime.date.today().replace(month=month, year=year, day=last_month_day)

date_filter = '%s-%s-%s .. %s-%s-%s' % (1, month, year, last_month_day, month, year)


def get_staff_logins():
    headers = {"Authorization": "OAuth %s" % yaconfig["STAFF_TOKEN"]}
    r = requests.get(
        'https://staff-api.yandex-team.ru/v3/persons?_query=department_group.department.url=="yandex_infra_tech_testing_framework_personal"%20or%20department_group.ancestors.department.url=="yandex_infra_tech_testing_framework_personal"&_fields=login&_limit=1000',
        headers=headers)

    logins_list = []
    a = r.json().get('result')
    for i in a:
        b = i.get('login')
        logins_list.append(b)

    return logins_list


def make_tested_filter(logins):
    filter_str = ""
    j = 0
    for i in logins:
        filter_str += 'Status: changed(to: "Протестировано" date: %s by: %s)' % (date_filter, i)
        j += 1
        if j < len(logins):
            filter_str += " OR "
    return filter_str


def make_tested_filter_passp(logins):
    filter_str = ""
    j = 0
    for i in logins:
        filter_str += 'Status: changed(to: "Готов к выкладке" date: %s by: %s)' % (date_filter, i)
        j += 1
        if j < len(logins):
            filter_str += " OR "
    return filter_str


def make_created_filter(logins):
    filter_str = ""
    j = 0
    for i in logins:
        filter_str += i
        j += 1
        if j < len(logins):
            filter_str += ","
    return filter_str


staff_logins_list = get_staff_logins()
logins_tested = make_tested_filter(staff_logins_list)
logins_created = make_created_filter(staff_logins_list)
logins_tested_passp = make_tested_filter_passp(staff_logins_list)

project_settings = {
    'DARIA': [
        {
            "Протестировано фичей": 'Queue: DARIA (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s) ' % logins_tested},
        {
            "Протестировано багов": 'Queue: DARIA Type: Ошибка AND (%s) ' % logins_tested},
        {
            "Заведено багов тестинга": 'Queue: DARIA (Type: Ошибка OR Type: Task OR Type: Impovement) Created: %s AND (Stage: Testing OR Stage: FromTestToProd) AND (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Заведено багов прода": 'Queue: DARIA Type: Ошибка Created: %s AND Stage: Production AND "Bug Detection Method": Manually (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Протестировано релизов": 'Queue: DARIA Type: Release Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'QUINN': [
        {
            "Протестировано фичей": 'Queue: QUINN (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s) ' % logins_tested},
        {
            "Протестировано багов": 'Queue: QUINN Type: Ошибка AND (%s) ' % logins_tested},
        {
            "Заведено багов тестинга": 'Queue: QUINN (Type: Ошибка OR Type: Task OR Type: Impovement) Created: %s AND (Stage: Testing OR Stage: FromTestToProd) AND (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Заведено багов прода": 'Queue: QUINN Type: Ошибка Created: %s AND Stage: Production AND "Bug Detection Method": Manually AND (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Протестировано релизов": 'Queue: QUINN Type: Release  Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'MAYA': [
        {
            "Протестировано фичей": 'Queue: MAYA (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s) ' % logins_tested},
        {
            "Протестировано багов": 'Queue: MAYA Type: Ошибка AND (%s) ' % logins_tested},
        {
            "Заведено багов тестинга": 'Queue: MAYA (Type: Ошибка OR Type: Task OR Type: Impovement) Created: %s AND (Stage: Testing OR Stage: FromTestToProd) AND (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Заведено багов прода": 'Queue: MAYA Type: Ошибка Created: %s AND Stage: Production AND "Bug Detection Method": Manually (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Протестировано релизов": 'Queue: MAYA Type: Release  Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'MOBILEMAIL': [
        # {
        #     "Протестировано фичей": 'Queue: MOBILEMAIL, MMAPI (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s) ' % logins_tested_mobmail},
        # {
        #     "Протестировано багов": 'Queue: MOBILEMAIL, MMAPI Type: Ошибка AND (%s) ' % logins_tested_mobmail},
        {
            "Заведено багов тестинга": 'Queue: MOBILEMAIL, MMAPI (Type: Ошибка OR Type: Task OR Type: Impovement) Created: %s AND (Stage: Testing OR Stage: FromTestToProd OR Stage: Development) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Заведено багов прода": 'Queue: MOBILEMAIL, MMAPI Type: Ошибка Created: %s AND Stage: Production AND "Bug Detection Method": Manually (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Протестировано релизов": 'Queue: MOBILEMAIL, MMAPI  Type: Release Status: changed(to: Закрыт date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'CHEMODAN, DOCVIEWER': [
        {
            "Протестировано фичей": 'Queue: CHEMODAN, DOCVIEWER (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s) ' % logins_tested},
        {
            "Протестировано багов": 'Queue: CHEMODAN, DOCVIEWER Type: Ошибка AND (%s) ' % logins_tested},
        {
            "Заведено багов тестинга": 'Queue: CHEMODAN, DOCVIEWER (Type: Ошибка OR Type: Task OR Type: Impovement) Created: %s AND (Stage: Testing OR Stage: FromTestToProd) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Заведено багов прода": 'Queue: CHEMODAN, DOCVIEWER Type: Ошибка Created: %s AND Stage: Production AND "Bug Detection Method": Manually  (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Протестировано релизов": 'Queue: CHEMODAN, DOCVIEWER Type: Release  Status: changed(to: Закрыт  date: %s ) Components: "Disk Frontend", "Frontend" and Resolution: Решен' % date_filter
        }
    ],
    'DISCSW': [
        {
            "Протестировано фичей": 'Queue: DISCSW (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s) ' % logins_tested},
        {
            "Протестировано багов": 'Queue: DISCSW Type: Ошибка AND (%s) ' % logins_tested},
        {
            "Заведено багов тестинга": 'Queue: DISCSW (Type: Ошибка OR Type: Task OR Type: Impovement) Created: %s AND (Stage: Testing OR Stage: FromTestToProd) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Заведено багов прода": 'Queue: DISCSW Type: Ошибка Created: %s AND Stage: Production AND "Bug Detection Method": Manually (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Протестировано релизов": 'Queue: DISCSW Type: Release  Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'MOBDISK': [
        {
            "Протестировано фичей": 'Queue: MOBDISK (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s) ' % logins_tested},
        {
            "Протестировано багов": 'Queue: MOBDISK Type: Ошибка AND (%s) ' % logins_tested},
        {
            "Заведено багов тестинга": 'Queue: MOBDISK (Type: Ошибка OR Type: Task OR Type: Impovement) Created: %s AND (Stage: Testing OR Stage: FromTestToProd OR Stage: Development) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Заведено багов прода": 'Queue: MOBDISK Type: Ошибка Created: %s AND Stage: Production AND "Bug Detection Method": Manually (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Протестировано релизов": 'Queue: MOBDISK Type: Release  Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'PASSP': [
        {
            "Протестировано фичей": 'Queue: PASSP (Type: Task OR Type: New Feature OR Type: Impovement) AND Components: "%%Фронтенд" AND (%s) ' % logins_tested_passp},
        {
            "Протестировано багов": 'Queue: PASSP Type: Ошибка AND Components: "%%Фронтенд"  AND (%s) ' % logins_tested_passp},
        {
            "Заведено багов тестинга": 'Queue: PASSP (Type: Ошибка OR Type: Task OR Type: Impovement) Created: %s AND (Stage: Testing OR Stage: FromTestToProd) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Components: "%%Фронтенд" AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Заведено багов прода": 'Queue: PASSP Type: Ошибка Created: %s AND Stage: Production AND "Bug Detection Method": Manually  (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Components: "%%Фронтенд" AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Протестировано релизов": 'Queue: PASSP Type: Release  Status: changed(to: Закрыт  date: %s ) Components: "%%Фронтенд" and Resolution: Решен' % date_filter
        }
    ],
    'MOBDEVAUTH': [
        {
            "Протестировано фичей": 'Queue: MOBDEVAUTH (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s) ' % logins_tested_passp},
        {
            "Протестировано багов": 'Queue: MOBDEVAUTH Type: Ошибка  AND (%s) ' % logins_tested_passp},
        {
            "Заведено багов тестинга": 'Queue: MOBDEVAUTH (Type: Ошибка OR Type: Task OR Type: Impovement) Created: %s AND (Stage: Testing OR Stage: FromTestToProd) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Заведено багов прода": 'Queue: MOBDEVAUTH Type: Ошибка Created: %s AND Stage: Production AND "Bug Detection Method": Manually (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)AND Author: %s' % (
                date_filter, logins_created)},
        {
            "Протестировано релизов": 'Queue: MOBDEVAUTH Type: Release  Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ]
}

project_releases = {
    'DARIA': [
        {
            "Протестировано релизов-хотфиксов": 'Queue: DARIA Type: Release "Release Type": "Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        },
        {
            "Протестировано обычных релизов": 'Queue: DARIA Type: Release "Release Type": !"Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'QUINN': [
        {
            "Протестировано релизов-хотфиксов": 'Queue: QUINN Type: Release "Release Type": "Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        },
        {
            "Протестировано обычных релизов": 'Queue: QUINN Type: Release "Release Type": !"Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }

    ],
    'MAYA': [
        {
            "Протестировано релизов-хотфиксов": 'Queue: MAYA Type: Release "Release Type": "Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        },
        {
            "Протестировано обычных релизов": 'Queue: MAYA Type: Release "Release Type": !"Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }

    ],
    'MOBILEMAIL': [
        {
            "Протестировано релизов-хотфиксов": 'Queue: MOBILEMAIL, MMAPI Type: Release "Release Type": "Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        },
        {
            "Протестировано обычных релизов": 'Queue: MOBILEMAIL, MMAPI Type: Release "Release Type": !"Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'CHEMODAN, DOCVIEWER': [
        {
            "Протестировано релизов-хотфиксов": 'Queue: CHEMODAN, DOCVIEWER Type: Release "Release Type": "Hotfix" Components: "Disk Frontend", "Frontend" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        },
        {
            "Протестировано обычных релизов": 'Queue: CHEMODAN, DOCVIEWER Type: Release "Release Type": !"Hotfix" Components: "Disk Frontend", "Frontend" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'DISCSW': [

        {
            "Протестировано релизов-хотфиксов": 'Queue: DISCSW Type: Release "Release Type": "Hotfix" AND Tags: windows Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        },
        {
            "Протестировано обычных релизов": 'Queue: DISCSW Type: Release "Release Type": !"Hotfix" AND Tags: windows Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'MOBDISK': [
        {
            "Протестировано релизов-хотфиксов": 'Queue: MOBDISK Type: Release "Release Type": "Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        },
        {
            "Протестировано обычных релизов": 'Queue: MOBDISK Type: Release "Release Type": !"Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'PASSP': [

        {
            "Протестировано релизов-хотфиксов": 'Queue: PASSP Type: Release "Release Type": "Hotfix" Components: "%%Фронтенд" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        },
        {
            "Протестировано обычных релизов": 'Queue: PASSP Type: Release "Release Type": !"Hotfix" Components: "%%Фронтенд" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ],
    'MOBDEVAUTH': [

        {
            "Протестировано релизов-хотфиксов": 'Queue: MOBDEVAUTH Type: Release "Release Type": "Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        },
        {
            "Протестировано обычных релизов": 'Queue: MOBDEVAUTH Type: Release "Release Type": !"Hotfix" Status: changed(to: Закрыт  date: %s ) and Resolution: Решен' % date_filter
        }
    ]
}

project_asessors_tested = {
    'DARIA': [
        {
            "Протестировано тикетов асессорами": 'Queue: DARIA Tags: changed(to: finishedInYang date: %s )' % date_filter
        }
    ],
    'QUINN': [
        {
            "Протестировано тикетов асессорами": 'Queue: QUINN Tags: changed(to: finishedInYang date: %s )' % date_filter
        }
    ],
    'MAYA': [
        {
            "Протестировано тикетов асессорами": 'Queue: MAYA Tags: changed(to: finishedInYang date: %s )' % date_filter
        }
    ],
    'MOBILEMAIL': [
        {
            "Протестировано тикетов асессорами": 'Queue: MOBILEMAIL, MMAPI Tags: changed(to: finishedInYang date: %s )' % date_filter
        }
    ],
    'CHEMODAN, DOCVIEWER': [
        {
            "Протестировано тикетов асессорами": 'Queue: CHEMODAN, DOCVIEWER Components: "Disk Frontend", "Frontend" Tags: changed(to: finishedInYang date: %s )' % date_filter
        }
    ],
    'DISCSW': [
        {
            "Протестировано тикетов асессорами": 'Queue: DISCSW Tags: changed(to: finishedInYang date: %s )' % date_filter
        }
    ],
    'MOBDISK': [
        {
            "Протестировано тикетов асессорами": 'Queue: MOBDISK Tags: changed(to: finishedInYang date: %s )' % date_filter
        }
    ],
    'PASSP': [
        {
            "Протестировано тикетов асессорами": 'Queue: PASSP Components: "%%Фронтенд" Tags: changed(to: finishedInYang date: %s )' % date_filter
        }
    ],
    'MOBDEVAUTH': [
        {
            "Протестировано тикетов асессорами": 'Queue: MOBDEVAUTH Tags: changed(to: finishedInYang date: %s )' % date_filter
        }
    ]
}

project_asessors_prod_bugs = {
    'DARIA': [
        {
            "Заведено багов прода асессорами": 'Queue: DARIA Type: Ошибка Created: %s AND Stage: Production AND ("Bug Detection Method": Asessor OR "Bug Detection Method": Asessors OR "Bug Detection Method": Assessors) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)' %
                                               date_filter
        }
    ],
    'QUINN': [
        {
            "Заведено багов прода асессорами": 'Queue: QUINN Type: Ошибка Created: %s AND Stage: Production AND ("Bug Detection Method": Asessor OR "Bug Detection Method": Asessors OR "Bug Detection Method": Assessors) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)' %
                                               date_filter
        }
    ],
    'MAYA': [
        {
            "Заведено багов прода асессорами": 'Queue: MAYA Type: Ошибка Created: %s AND Stage: Production AND ("Bug Detection Method": Asessor OR "Bug Detection Method": Asessors OR "Bug Detection Method": Assessors) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)' %
                                               date_filter
        }
    ],
    'MOBILEMAIL': [
        {
            "Заведено багов прода асессорами": 'Queue: MOBILEMAIL, MMAPI Type: Ошибка Created: %s AND Stage: Production AND ("Bug Detection Method": Asessor OR "Bug Detection Method": Asessors OR "Bug Detection Method": Assessors) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)' %
                                               date_filter
        }
    ],
    'CHEMODAN, DOCVIEWER': [
        {
            "Заведено багов прода асессорами": 'Queue: CHEMODAN, DOCVIEWER Type: Ошибка Created: %s AND Stage: Production AND ("Bug Detection Method": Asessor OR "Bug Detection Method": Asessors OR "Bug Detection Method": Assessors) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)' %
                                               date_filter
        }
    ],
    'DISCSW': [
        {
            "Заведено багов прода асессорами": 'Queue: DISCSW Type: Ошибка Created: %s AND Stage: Production AND ("Bug Detection Method": Asessor OR "Bug Detection Method": Asessors OR "Bug Detection Method": Assessors) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)' %
                                               date_filter
        }
    ],
    'MOBDISK': [
        {
            "Заведено багов прода асессорами": 'Queue: MOBDISK Type: Ошибка Created: %s AND Stage: Production AND ("Bug Detection Method": Asessor OR "Bug Detection Method": Asessors OR "Bug Detection Method": Assessors) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)' %
                                               date_filter
        }
    ],
    'PASSP': [
        {
            "Заведено багов прода асессорами": 'Queue: PASSP Type: Ошибка Created: %s AND Stage: Production AND ("Bug Detection Method": Asessor OR "Bug Detection Method": Asessors OR "Bug Detection Method": Assessors) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат) AND Components: "%%Фронтенд"' %
                                               date_filter
        }
    ],
    'MOBDEVAUTH': [
        {
            "Заведено багов прода асессорами": 'Queue: MOBDEVAUTH Type: Ошибка Created: %s AND Stage: Production AND ("Bug Detection Method": Asessor OR "Bug Detection Method": Asessors OR "Bug Detection Method": Assessors) (Resolution: !Позже Resolution: !Некорректный Resolution: !"Не будет исправлено" Resolution: !"Не воспроизводится" Resolution: !"До следующего обращения" Resolution: !Дубликат)' %
                                               date_filter
        }
    ]
}

# projects_tp = {
#     'QUINN': ['mail-touch']
# }

projects_tp = {
    'DARIA': ['mail-liza'],
    'QUINN': ['mail-touch'],
    'MAYA': ['cal'],
    'MOBILEMAIL': ['mobmail_ios', 'mobmail_android', 'mobilemail'],
    'CHEMODAN, DOCVIEWER': ['diskclient', 'diskfront', 'diskpublic'],
    'DISCSW': ['diskdesktop', 'disc3'],
    'MOBDISK': ['adisk', 'idisk'],
    'PASSP': ['passport'],
    'MOBDEVAUTH': ['am-ios', 'am-android']
}

robots = ['robot-venatu', 'robot-aqua-testpers', 'robot-pinkie-pie', 'zomb-persmob-qa']

groups_qa = ['yandex_infra_tech_testing_framework_personal_mailint', 'yandex_infra_tech_testing_framework_personal_mob',
             'yandex_infra_tech_testing_framework_personal_disk',
             'yandex_infra_tech_testing_framework_personal_dep22939',
             'yandex_infra_tech_testing_framework_personal_2619_5095',
             'yandex_infra_tech_testing_framework_personal_passp']

groups_dev = ['yandex_personal_interdev', 'yandex_personal_cloud_dev', 'yandex_rkub_mobdev_pers',
              'yandex_search_tech_searchinfradev_dep33739']

staff_groups = {
    'DARIA': 'yandex_infra_tech_testing_framework_personal_mailint',
    'QUINN': 'yandex_infra_tech_testing_framework_personal_mailint',
    'MAYA': 'yandex_infra_tech_testing_framework_personal_mailint',
    'MOBILEMAIL': 'yandex_infra_tech_testing_framework_personal_mob',
    'CHEMODAN, DOCVIEWER': 'yandex_infra_tech_testing_framework_personal_disk',
    'DISCSW': 'yandex_infra_tech_testing_framework_personal_dep22939',
    'MOBDISK': 'yandex_infra_tech_testing_framework_personal_2619_5095',
    'PASSP': 'yandex_infra_tech_testing_framework_personal_passp',
    'MOBDEVAUTH': 'yandex_infra_tech_testing_framework_personal_passp'
}

testpers_tags = {
    'DARIA': 'daria',
    'QUINN': 'quinn',
    'MAYA': 'maya',
    'MOBILEMAIL': 'mobilemail',
    'CHEMODAN, DOCVIEWER': 'chemodan',
    'DISCSW': 'discsw',
    'MOBDISK': 'mobdisk',
    'PASSP': 'passp',
    'MOBDEVAUTH': 'mobdevauth'
}

tsp = {
    'DARIA': 0.5,
    'QUINN': 0.5,
    'MAYA': 0.5,
    'MOBILEMAIL': 6,
    'CHEMODAN, DOCVIEWER': 0.25,
    'DISCSW': 0.25,
    'MOBDISK': 1,
    'PASSP': 0,
    'MOBDEVAUTH': 0
}

created_keys = {
    'mail-liza': 'attributes.5df78fae0c32bc91eef6c8a9',
    'mail-touch': 'attributes.5df930559fcbfa31fc1584e9',
    'mobilemail': 'attributes.5e0323d527a990afebefd39f',
    'mobmail_ios': 'attributes.5e03249027a990afebefd40d',
    'adisk': 'attributes.5df79d7af97f2493de4e97e1',
    'idisk': 'attributes.5df79ddc8d2030e9c87f9678',
    'diskclient': 'attributes.5e20ca50f97f2493de5a4dbd',
    'cal': 'attributes.5e295d5d8d2030e9c88ccd84',
    'am-ios': 'attributes.5e31ad0227a9906d4802194b',
    'am-android': 'attributes.5e31ac4c0c32bca86bab1f9d',
    'passport': 'attributes.5e31ab4a9fcbfa69df3c36d0'
}

automated_keys = {
    'mail-liza': 'attributes.5df77e490c32bc91eef6bee4',
    'mail-touch': 'attributes.5df92fa327a990afebec5b0d',
    'mobilemail': 'attributes.5e03240f8d2030e9c883d4fd',
    'mobmail_ios': 'attributes.5e0324710c32bc91eef9c2b3',
    'adisk': 'attributes.5df79d508d2030e9c87f964c',
    'idisk': 'attributes.5df79dc48d2030e9c87f966e',
    'diskclient': 'attributes.5e20ca1f9fcbfa31fc1f3693',
    'cal': 'attributes.5e295d3f9fcbfa31fc2190d0',
    'am-ios': 'attributes.5e31acd227a9906d48021933',
    'am-android': 'attributes.5df8f4769fcbfa31fc1577fa',
    'passport': 'attributes.5e01afc58d2030e9c8834bfe'
}
