# -*- coding: utf-8 -*-

import calendar
import datetime
import json
import os
import re
import sys
import time
import urllib
import numpy
import requests
import yaml
from retrying import retry
from startrek_client import Startrek

import config

reload(sys)
sys.setdefaultencoding('utf-8')

requests.urllib3.disable_warnings(requests.urllib3.exceptions.InsecureRequestWarning)

scriptPath = os.path.dirname(os.path.abspath(__file__))

yaconfig = yaml.load(open(os.path.dirname(scriptPath) + "/StartrekStat/config.yaml"))
projects = yaml.load(open(os.path.dirname(scriptPath) + "/StartrekStat/reportConf.yaml"))

project_settings = config.project_settings
robots = config.robots

client = Startrek(useragent="curl/7.53.1", token=yaconfig["AUTH_ST"])

update_only_startrek = 0

month = config.month

if month == 0:
    month = datetime.datetime.now().month

year = config.year

date_today = datetime.datetime.now()
last_month_day = calendar.monthrange(datetime.datetime.now().year, month)[1]
month_first_day = date_today.replace(month=month, year=year, day=1, hour=0, minute=0, second=0, microsecond=0)
month_eleven_day = date_today.replace(month=2, year=2020, day=11, hour=0, minute=0, second=0, microsecond=0)
month_last_day = date_today.replace(month=month, year=year, day=last_month_day, hour=23, minute=59, second=59,
                                    microsecond=0)
month_twelve_day = date_today.replace(month=2, year=2020, day=12, hour=23, minute=59, second=59,
                                      microsecond=0)
month_date = datetime.date.today().replace(month=month, day=1, year=year)
date_max = datetime.date.today().replace(month=month, day=last_month_day, year=year)

month_first_day_date = datetime.date(year, month, 1)
month_last_day_date = datetime.date(year, month, last_month_day)
min_time = datetime.datetime.min.time()
max_time = datetime.datetime.max.time()

month_first_day_datetime = datetime.datetime.combine(month_first_day_date, min_time)
month_last_day_datetime = datetime.datetime.combine(month_last_day_date, max_time)

date_filter = '%s-%s-%s .. %s-%s-%s' % (1, month, year, last_month_day, month, year)

firstDayTS = str(int(time.mktime(month_first_day.timetuple()) * 1000))
nowTS = str(int(time.mktime(datetime.datetime.now().timetuple()) * 1000))
lastDayTS = str(int(time.mktime(month_last_day.timetuple()) * 1000))

firstDayIntTS = int(time.mktime(month_first_day.timetuple()) * 1000)
lastDayIntTS = int(time.mktime(month_last_day.timetuple()) * 1000)

ElevenFebDayTS = str(int(time.mktime(month_eleven_day.timetuple()) * 1000))
TwelveFebDayTS = str(int(time.mktime(month_twelve_day.timetuple()) * 1000))

print month_first_day
print month_last_day
print date_today

no_auto_data = ['CHEMODAN, DOCVIEWER', 'DISCSW', 'PASSP', 'MOBDEVAUTH']

ROBOTS = [
    "robot-gerrit",
    "robot-aqua-testpers robot-aqua-testpers",
    "zomb-mobmail-qa",
]

cal = ['annrid', 'olga-ganchikova']

mail_touch = ['oleshko', 'sshelgunova', 'mastugan']

leads = ['cosmopanda', 'alena', 'olyd', 'yaroslavna', 'kateogar', 'gladnik']

mobdevauth = ['oafashokov']

developers = ['vasily-k', 'madhypnofrog', 'pavponn', 'kidyankin']

cal_and_touch = []
cal_and_touch.extend(mail_touch)
cal_and_touch.extend(cal)

staff_logins_list = config.get_staff_logins()


def created_cases_interns(first_day, last_day, key):
    time_filter = {
        "type": "AND",
        "left": {
            "type": "CONTAIN",
            "key": key,
            "value": "стажер"},
        "right": {
            "type": "AND",
            "left": {
                "type": "GT",
                "key": "createdTime",
                "value": first_day
            },
            "right": {
                "type": "LT",
                "key": "createdTime",
                "value": last_day
            }
        }
    }

    return time_filter


def created_cases_asessors(first_day, last_day, key):
    time_filter = {
        "type": "AND",
        "left": {
            "type": "CONTAIN",
            "key": key,
            "value": "асессор"},
        "right": {
            "type": "AND",
            "left": {
                "type": "GT",
                "key": "createdTime",
                "value": first_day
            },
            "right": {
                "type": "LT",
                "key": "createdTime",
                "value": last_day
            }
        }
    }

    return time_filter


def automated_cases_interns(key):
    time_filter = {
        "type": "CONTAIN",
        "key": key,
        "value": "стажер"}

    return time_filter


def automated_cases_dev(key):
    time_filter = {
        "type": "CONTAIN",
        "key": key,
        "value": "разработчик"}

    return time_filter


def created_cases(first_day, last_day):
    time_filter = {
        "type": "AND",
        "left": {
            "type": "GT",
            "key": "createdTime",
            "value": first_day
        },
        "right": {
            "type": "LT",
            "key": "createdTime",
            "value": last_day
        }
    }
    return time_filter


def finished_run(first_day, last_day):
    time_filter = {
        "type": "AND",
        "left": {
            "type": "GT",
            "key": "finishedTime",
            "value": first_day
        },
        "right": {
            "type": "LT",
            "key": "finishedTime",
            "value": last_day
        }
    }
    return time_filter


def get_automated():
    request = {
        "type": "EQ",
        "key": "isAutotest",
        "value": "true"
    }
    return request


finished_run_filter = finished_run(firstDayTS, lastDayTS)
created_cases_filter = created_cases(firstDayTS, lastDayTS)
automated_cases_filter = get_automated()


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_created_cases(project_name):
    created_cases_num = 0

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    run_filter = json.dumps(created_cases_filter, ensure_ascii=False, separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    for queue in config.projects_tp.get(project_name):
        url = "https://testpalm-api.yandex-team.ru/testcases/%s?include=id&expression=%s" % (queue, url_body)
        res = requests.get(url, headers=headers, verify=False)

        cases = json.loads(res.text)
        created_cases_num += len(cases)

    return created_cases_num


def get_created_cases_interns(project_name):
    created_cases_num = 0
    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    for queue in config.projects_tp.get(project_name):
        key = config.created_keys.get(queue)
        if key is None:
            return 0
        created_cases_filter_interns = created_cases_interns(firstDayTS, lastDayTS, key)
        run_filter = json.dumps(created_cases_filter_interns, ensure_ascii=False, separators=(",", ": "))
        url_body = urllib.quote(run_filter)
        url = "https://testpalm-api.yandex-team.ru/testcases/%s?include=id&expression=%s" % (queue, url_body)
        res = requests.get(url, headers=headers, verify=False)

        cases = json.loads(res.text)
        created_cases_num += len(cases)

    return created_cases_num


def get_created_cases_asessors(project_name):
    created_cases_num = 0
    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    for queue in config.projects_tp.get(project_name):
        key = config.created_keys.get(queue)
        if key is None:
            return 0
        created_cases_filter_asessors = created_cases_asessors(firstDayTS, lastDayTS, key)
        run_filter = json.dumps(created_cases_filter_asessors, ensure_ascii=False, separators=(",", ": "))
        url_body = urllib.quote(run_filter)
        url = "https://testpalm-api.yandex-team.ru/testcases/%s?include=id&expression=%s" % (queue, url_body)
        res = requests.get(url, headers=headers, verify=False)

        cases = json.loads(res.text)
        created_cases_num += len(cases)

    return created_cases_num


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def num_of_automated_cases(project_name):
    auto_cases = 0

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    run_filter = json.dumps(automated_cases_filter, ensure_ascii=False, separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    for queue in config.projects_tp.get(project_name):
        if queue != 'diskdesktop':
            url = "https://testpalm-api.yandex-team.ru/testcases/%s/?include=id&expression=%s" % (queue, url_body)

            res = requests.get(url, headers=headers, verify=False)

            cases = json.loads(res.text)
            auto_cases += len(cases)

    return auto_cases


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_num_autotests(project_name):
    st_stat = get_startrek_releases_stat(project_name)
    autotests_num = num_of_automated_cases(project_name)
    data = st_stat[0] * autotests_num + st_stat[1] * 2 * autotests_num

    return data


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_startrek_releases_stat(project_name):
    filters = config.project_releases.get(project_name)
    st_data = []
    for i in filters:
        for name, st_filter in i.items():
            issues = client.issues.find(st_filter.encode('utf8'))
            st_data.append(len(issues))
    return st_data


timeFormat = '%Y-%m-%dT%H:%M:%S'


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_release_timings(issue, updatesComment, updatesWorkflow):
    # """
    # Считаем время начала и конца тестирования, выкатки и затраченное на тестирование
    # """
    closeTime = startTime = finishTestingTime = testingTime = 0
    exitCloseFlag = exitStartFlag = finishTestingTimeFlag = False
    for update in updatesWorkflow:
        if not exitCloseFlag:
            for field in update.fields:
                if field['field'].id != 'status':
                    continue
                if field['to'].name == 'Закрыт' or field['to'].name == 'Выложили' or field['to'].name == 'Released':
                    closeTime = datetime.datetime.strptime(update.updatedAt[:19], timeFormat)
                    exitCloseFlag = True
                    break
        if not exitStartFlag:
            for field in update.fields:
                if field['field'].id != 'status':
                    continue
                if field['to'].name == 'В работе' or field['to'].name == 'Тестируется':
                    startTime = datetime.datetime.strptime(update.updatedAt[:19], timeFormat)
                    exitStartFlag = True
                    break
        if not finishTestingTimeFlag:
            for field in update.fields:
                if field['field'].id != 'status':
                    continue
                if field['to'].name == 'Закрыт' or field['to'].name == 'Протестировано' \
                        or field['to'].name == 'Ready for Release' or field['to'].key == 'released':
                    finishTestingTime = datetime.datetime.strptime(update.updatedAt[:19], timeFormat)
                    finishTestingTimeFlag = True
                    break
        if exitCloseFlag and exitStartFlag and finishTestingTimeFlag:
            break

    if startTime == 0:  # или первый коммент робота о пакете
        for update in updatesComment:
            if str(update.updatedBy.id) in ROBOTS:
                startTime = datetime.datetime.strptime(update.updatedAt[:19], timeFormat)
                break

    if startTime == 0:  # и на крайний случай дату создания тикета
        startTime = datetime.datetime.strptime(client.issues[issue.key].createdAt[:19], timeFormat)

    # Считаем сколько релиз был в тестировании
    if startTime != 0 and finishTestingTime != 0:
        testingTime = abs(finishTestingTime - startTime).days
    if startTime != 0 and finishTestingTime == 0:
        testingTime = abs(datetime.datetime.now() - startTime).days

    return testingTime


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_release_info(issue):
    updatesComment = list(client.issues[issue.key].changelog.get_all(type='IssueCommentAdded'))
    updatesWorkflow = list(client.issues[issue.key].changelog.get_all(type='IssueWorkflow'))

    times = get_release_timings(issue, updatesComment, updatesWorkflow)

    return times


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_releases_info(project_name):
    days = 0
    if project_name in no_auto_data:
        filter_st = project_settings.get(project_name)[4].get('Протестировано релизов')
        issues = client.issues.find(filter_st.encode('utf8'))
        for issue in issues:
            days += get_release_info(issue)

    return days


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_run_cases_num(project_name):
    run_cases = 0

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    run_filter = json.dumps(finished_run_filter, ensure_ascii=False, separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    for queue in config.projects_tp.get(project_name):
        url = "https://testpalm-api.yandex-team.ru/testrun/%s?include=finishedTime,resolution&expression=%s" % (
            queue, url_body)

        res = requests.get(url, headers=headers, verify=False)

        runs = json.loads(res.text)
        for run in runs:
            run_cases += run.get('resolution').get('counter').get('total')
    return run_cases


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_auto_cases(project_name):
    auto_cases = 0
    auto_interns = 0
    auto_dev = 0

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    run_filter = json.dumps(automated_cases_filter, ensure_ascii=False, separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    for queue in config.projects_tp.get(project_name):
        url = "https://testpalm-api.yandex-team.ru/testcases/%s/?include=id&expression=%s" % (queue, url_body)

        res = requests.get(url, headers=headers, verify=False)
        automated_cases_list = []
        automated_in_month = []

        cases = json.loads(res.text)
        for case in cases:
            automated_cases_list.append(case.get('id'))
            if is_case_automated_in_month(queue, case.get('id')) == 1:
                automated_in_month.append(case.get('id'))
        automated_by_interns = list(set(get_automated_by_interns(queue)) & set(automated_in_month))
        automated_by_dev = list(set(get_automated_by_dev(queue)) & set(automated_in_month))

        auto_cases += len(automated_in_month)
        auto_interns += len(automated_by_interns)
        auto_dev += len(automated_by_dev)

    return [auto_cases - auto_interns - auto_dev, auto_interns, auto_dev]


def get_automated_by_interns(queue):
    cases_list = []
    if config.automated_keys.get(queue) is None:
        return []

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    run_filter = json.dumps(automated_cases_interns(key=config.automated_keys.get(queue)), ensure_ascii=False,
                            separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    url = "https://testpalm-api.yandex-team.ru/testcases/%s?include=id&expression=%s" % (queue, url_body)
    res = requests.get(url, headers=headers, verify=False)

    cases = json.loads(res.text)
    for case in cases:
        cases_list.append(case.get('id'))
    return cases_list


def get_automated_by_dev(queue):
    cases_list = []
    if config.automated_keys.get(queue) is None:
        return []
    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    run_filter = json.dumps(automated_cases_dev(key=config.automated_keys.get(queue)), ensure_ascii=False,
                            separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    url = "https://testpalm-api.yandex-team.ru/testcases/%s?include=id&expression=%s" % (queue, url_body)
    res = requests.get(url, headers=headers, verify=False)

    cases = json.loads(res.text)
    for case in cases:
        cases_list.append(case.get('id'))
    return cases_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_startrek_stat(project_name):
    filters = project_settings.get(project_name)
    st_data = []
    for i in filters:
        for name, st_filter in i.items():
            issues = client.issues.find(st_filter.encode('utf8'))
            st_data.append(len(issues))
    return st_data


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_asessor_time(project_name):
    r = requests.get(
        'https://upload.stat.yandex-team.ru/_api/statreport/json/Mail/Others/regression?scale=m',
        headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]},
    ).json()
    asessor_time = 0
    for i in r.get('values'):
        if i.get('fielddate') == str(month_first_day):
            queue = i.get('queue')
            if queue in config.projects_tp.get(project_name):
                if i.get('assessor_failed'):
                    asessor_time += i.get('assessor_failed')
    return asessor_time


def is_not_empty(testruns):
    if not testruns:
        return False
    return True


def is_assessor_version(version):
    if 'asses' in version.lower() or 'ases' in version.lower() or 'acces' in version.lower() \
            or 'асес'.decode('utf-8') in version.lower():
        return True


def is_last_month(finished_date):
    if finished_date >= firstDayIntTS and finished_date < lastDayIntTS:
        return True
    return False


def is_finished(single_run):
    if single_run['status'] == 'FINISHED':
        return True
    return False


@retry(stop_max_attempt_number=3, wait_fixed=100)
def get_suites(parentId):
    url = 'https://testpalm.yandex-team.ru/api/testsuite/' + parentId
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    all_suites = requests.get(url, headers=req_headers).json()

    ass_tag = 'AssessorReg'

    assessor_suites = list()

    for suite in all_suites:
        if 'tags' in suite and suite['tags']:
            tags = suite['tags']
            if ass_tag in tags:
                assessor_suites.append(suite['id'])
        else:
            continue

    return assessor_suites


queues_list = {'mail-liza': 0, 'cal': 1, 'mail-touch': 2, 'diskfront': 3, 'diskclient': 4, 'diskpublic': 5,
               'passport': 6, 'am-ios': 7, 'am-android': 8, 'adisk': 9, 'idisk': 10, 'mobmail_ios': 11,
               'mobmail_android': 12, 'diskdesktop': 13, 'disc3': 14, 'mobilemail': 15}


@retry(stop_max_attempt_number=3, wait_fixed=100)
def assessor_failed_data(queue_name, index):
    queue_params = yaconfig['parentId'][index][queue_name]
    tc_list = queue_params['tc_list']
    parce_time_case = queue_params['parce_time_case']
    parce_time_max = queue_params['parce_time_max']

    all_suites = get_suites(queue_name)
    assessor_testplan = all_suites

    url = 'https://testpalm.yandex-team.ru:443/api/version/' + queue_name
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    all_versions = requests.get(url, headers=req_headers).json()
    versions = list()
    assessor_failed = list()

    for single_version in all_versions:
        if is_last_month(single_version['finishedTime']) and is_not_empty(single_version['suites']) \
                and is_assessor_version(single_version['title']):
            versions.append(single_version['title'])

        else:
            continue

    for assessor_version in versions:
        url = 'https://testpalm.yandex-team.ru:443/api/version/' + queue_name + '/overview/' + assessor_version
        req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
        response = requests.get(url, headers=req_headers)
        runs = response.json()
        failed = 0

        for single_run in runs['testruns']:
            if is_finished(single_run) and 'testSuite' in single_run and 'id' in single_run['testSuite'] and \
                    single_run['testSuite']['id'] in assessor_testplan:
                execution_time = int(single_run['executionTime'])

                if execution_time > 0:
                    failed_tc = int(single_run['resolution']['counter']['failed'])
                    broken_tc = int(single_run['resolution']['counter']['broken'])
                    knownbug_tc = int(single_run['resolution']['counter']['knownbug'])
                    skipped_tc = int(single_run['resolution']['counter']['skipped'])
                    total_tc = int(single_run['resolution']['counter']['total'])

                    if 'failed_tc' in tc_list:
                        failed += failed_tc
                    if 'broken_tc' in tc_list:
                        failed += broken_tc
                    if 'knownbug_tc' in tc_list:
                        failed += knownbug_tc
                    if 'skipped_tc' in tc_list and skipped_tc != total_tc:
                        failed += skipped_tc
                else:
                    continue

        failed = failed * parce_time_case
        if failed > parce_time_max:
            assessor_failed.append(parce_time_max)
        else:
            assessor_failed.append(failed)

    if assessor_failed:
        return int(numpy.sum(assessor_failed))
    return 0


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_asessor_time_sum(project_name):
    asessors_time = 0
    for queue in config.projects_tp.get(project_name):
        asessors_time += assessor_failed_data(queue, queues_list.get(queue))

    return asessors_time


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def is_case_automated_in_month(project_name, case_id):
    req_headers = {"TestPalm-Api-Token": yaconfig["AUTH_TP"], "Content-Type": "application/json"}
    url = "https://testpalm.yandex-team.ru/api/eventslog/%s/preview?limit=100&skip=0&testcaseId=%s&type=UPDATED" % (
        project_name, case_id)
    flag = 0
    res = requests.get(url, headers=req_headers)
    events = json.loads(res.text)
    for event in events:
        if 'changes' in event.keys() and event.get('lastModifiedTime') >= int(firstDayTS) and event.get(
                'lastModifiedTime') <= int(lastDayTS):
            if 'changedProperties' in event.get('changes'):
                if 'isAutotest' in event.get('changes').get('changedProperties'):
                    if event.get('lastModifiedTime') < int(ElevenFebDayTS) or event.get(
                            'lastModifiedTime') > int(TwelveFebDayTS):
                        flag = 1
                        break
        # else:
        #     break
    return flag


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_all_runs_ids(project_name):
    runs_id_list = []

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    run_filter = json.dumps(finished_run_filter, ensure_ascii=False, separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    url = "https://testpalm-api.yandex-team.ru/testrun/%s?include=id&expression=%s" % (
        project_name, url_body)

    res = requests.get(url, headers=headers, verify=False)

    runs = json.loads(res.text)

    for run in runs:
        runs_id_list.append(run.get('id'))

    return runs_id_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def divide_run(project_name, run_id):
    run_stat = []

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    run_type = 'DONT KNOW'

    url = "https://testpalm-api.yandex-team.ru/testrun/%s/%s?" \
          "include=launcherInfo,createdBy,title,testSuite,parentIssue,resolution" % (project_name, run_id)

    res = requests.get(url, headers=headers, verify=False)

    run_info = json.loads(res.text)

    cases_count = run_info.get('resolution').get('counter').get('total')

    if 'smoke' in run_info.get('title').lower():
        run_type = 'manual'

    if run_info.get('testSuite'):
        if 'tags' in run_info.get('testSuite'):
            if 'AssessorReg' in run_info.get('testSuite').get('tags'):
                run_type = 'ases'

    if run_info.get('testSuite'):
        if 'tags' in run_info.get('testSuite'):
            if 'ManualReg' in run_info.get('testSuite').get('tags'):
                run_type = 'manual'

    if run_info.get('launcherInfo').get('external') and run_info.get('createdBy') in robots:
        run_type = 'auto'

    if 'asses' in run_info.get('title').lower() or 'ases' in run_info.get('title').lower() \
            or 'acces' in run_info.get('title').lower() or 'асес'.decode('utf-8') in run_info.get('title').lower():
        run_type = 'ases'

    if 'autotest' in run_info.get('title').lower() or 'auto' in run_info.get('title').lower():
        run_type = 'auto'

    if run_info.get('parentIssue'):
        if 'groupId' in run_info.get('parentIssue'):
            if 'exp' in run_info.get('parentIssue').get('groupId').lower() or 'asess' in run_info.get(
                    'parentIssue').get('groupId').lower() or 'amtest' in run_info.get('parentIssue').get(
                'groupId').lower() or 'mobmailios' in run_info.get('parentIssue').get(
                'groupId').lower() or 'mobmailandriod' in run_info.get('parentIssue').get(
                'groupId').lower() or 'mobdiskaa' in run_info.get('parentIssue').get(
                'groupId').lower() or 'mobdiskia' in run_info.get('parentIssue').get('groupId').lower():
                run_type = 'ases'

    if 'toloka' in run_info.get('title').lower():
        run_type = 'ases'

    if 'ответственному'.decode('utf-8') in run_info.get('title').lower() or 'release check list' in run_info.get(
            'title').lower():
        run_type = 'manual'

    if run_type == 'DONT KNOW':
        run_type = 'manual'

    run_stat.append(run_type)
    run_stat.append(cases_count)

    return run_stat


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_all_runs_divide(project_name):
    runs_count = []
    auto_run = 0
    manual_run = 0
    asessor_run = 0

    for project in config.projects_tp.get(project_name):

        runs_list = get_all_runs_ids(project)

        for run_id in runs_list:
            stat = divide_run(project, run_id)
            if stat[0] == 'auto':
                auto_run += stat[1]
            if stat[0] == 'ases':
                asessor_run += stat[1]
            if stat[0] == 'manual':
                manual_run += stat[1]

    runs_count.append(auto_run)
    runs_count.append(manual_run)
    runs_count.append(asessor_run)

    return runs_count


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_current_stat(project_name):
    current_data = requests.get(
        'https://upload.stat.yandex-team.ru/_api/statreport/json/Adhoc/test-mail?scale=m&date_mах=%s&project=%s' %
        (date_max, project_name),
        headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]}).json()
    current_data_list = []
    for i in current_data.get('values'):
        if i.get('fielddate') == str(month_first_day):
            current_data_list.extend(
                [i.get('tested_feature'), i.get('tested_bug'), i.get('create_test_bug'), i.get('create_prod_bug'),
                 i.get('tested_release'), i.get('create_case'), i.get('auto_case'), i.get('run_case'),
                 i.get('asessor'),
                 i.get('run_auto'), i.get('run_manual'), i.get('run_asessor'), i.get('av_runned_autotests'),
                 i.get('employees_num'), i.get('create_case_asessor'), i.get('create_case_intern'),
                 i.get('auto_case_intern'), i.get('auto_case_dev'), i.get('infra_qa'), i.get('infra_dev'),
                 i.get('infra_intern'), i.get('auto_qa'), i.get('auto_dev'), i.get('auto_intern'),
                 i.get('analytics_qa'), i.get('analytics_dev'), i.get('analytics_intern'),
                 i.get('internal_qa'), i.get('internal_dev'), i.get('internal_intern'), i.get('tested_asessor'),
                 i.get('asessors_prod_bugs'), i.get('support')])
    if current_data_list == []:
        current_data_list = [0] * 34
    return current_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_st_stat(project_name):
    new_data_list = []
    if project_name == 'MOBILEMAIL':
        new_data_list.extend(get_st_stat_mobmail())
    else:
        new_data_list.extend(get_startrek_stat(project_name))
    new_data_list.extend(get_current_stat(project_name)[5:])

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_av_auto(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[12] = get_num_autotests(project_name)

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_auto_case(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[6] = get_auto_cases(project_name)

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_asessors(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[8] = get_asessor_time_sum(project_name)

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_employees_num(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[13] = worked_sum(get_employees_list(project_name))

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_created_cases(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    intern_cases = get_created_cases_interns(project_name)
    asessor_cases = get_created_cases_asessors(project_name)
    new_data_list[5] = get_created_cases(project_name) - intern_cases - asessor_cases
    new_data_list[15] = intern_cases
    new_data_list[14] = asessor_cases

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_auto_cases(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    auto_stat = get_auto_cases(project_name)
    new_data_list[6] = auto_stat[0]
    new_data_list[16] = auto_stat[1]
    new_data_list[17] = auto_stat[2]

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_asessors_prod_bugs(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[31] = get_asessors_prod_bugs(project_name)

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_infra(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    infra_qa = get_startrek_infra_tasks(project_name, 'qa')
    print "Infra by qa done", infra_qa
    infra_dev = get_startrek_infra_tasks(project_name, 'dev')
    print "Infra by dev done", infra_dev
    infra_intern = get_startrek_infra_tasks(project_name, 'intern')
    print "Infra by intern done", infra_intern
    auto_qa = get_startrek_auto_tasks(project_name, 'qa')
    print "Auto by qa done", auto_qa
    auto_dev = get_startrek_auto_tasks(project_name, 'dev')
    print "Auto by dev done", auto_dev
    auto_intern = get_startrek_auto_tasks(project_name, 'intern')
    print "Auto by intern done", auto_intern
    analytics_qa = get_startrek_analytics_tasks(project_name, 'qa')
    print "Analytics by qa done", analytics_qa
    analytics_dev = get_startrek_analytics_tasks(project_name, 'dev')
    print "Analytics by dev done", analytics_dev
    analytics_intern = get_startrek_analytics_tasks(project_name, 'intern')
    print "Analytics by intern done", analytics_intern
    internal_qa = get_startrek_internal_tasks(project_name, 'qa')
    print "internal by qa done", internal_qa
    internal_dev = get_startrek_internal_tasks(project_name, 'dev')
    print "internal by dev done", internal_dev
    internal_intern = get_startrek_internal_tasks(project_name, 'intern')
    print "internal by intern done", internal_intern
    new_data_list[18] = infra_qa
    new_data_list[19] = infra_dev
    new_data_list[20] = infra_intern
    new_data_list[21] = auto_qa
    new_data_list[22] = auto_dev
    new_data_list[23] = auto_intern
    new_data_list[24] = analytics_qa
    new_data_list[25] = analytics_dev
    new_data_list[26] = analytics_intern
    new_data_list[27] = internal_qa
    new_data_list[28] = internal_dev
    new_data_list[29] = internal_intern

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_tested_asessor(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[30] = get_asessors_tested(project_name)

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_support(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[32] = support_time

    return new_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_tested_tasks_mobmail(staff_logins):
    issues_list = []
    issues_list_keys = []
    fltr1 = 'Протестировано'
    fltr2 = 'Ready for RC'
    st_filter = make_tested_tasks_filter_mobmail(staff_logins, fltr1)
    issues = client.issues.find(st_filter.encode('utf8'))
    issues_list.extend(issues)
    st_filter = make_tested_tasks_filter_mobmail(staff_logins, fltr2)
    issues = client.issues.find(st_filter.encode('utf8'))
    issues_list.extend(issues)
    for i in issues_list:
        issues_list_keys.append(i.key)

    return len(set(issues_list_keys))


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_tested_bugs_mobmail(staff_logins):
    issues_list = []
    issues_list_keys = []
    fltr1 = 'Протестировано'
    fltr2 = 'Ready for RC'
    st_filter = make_tested_bugs_filter_mobmail(staff_logins, fltr1)
    issues = client.issues.find(st_filter.encode('utf8'))
    issues_list.extend(issues)
    st_filter = make_tested_bugs_filter_mobmail(staff_logins, fltr2)
    issues = client.issues.find(st_filter.encode('utf8'))
    issues_list.extend(issues)
    for i in issues_list:
        issues_list_keys.append(i.key)

    return len(set(issues_list_keys))


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def make_tested_tasks_filter_mobmail(logins, stage):
    filter_str = ""
    j = 0
    for i in logins:
        filter_str += 'Status: changed(to: "%s" date: %s by: %s)' % (stage, date_filter, i)
        j += 1
        if j < len(logins):
            filter_str += " OR "
    output_str = "Queue: MOBILEMAIL, MMAPI (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s)" % filter_str

    return output_str


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def make_tested_bugs_filter_mobmail(logins, stage):
    filter_str = ""
    j = 0
    for i in logins:
        filter_str += 'Status: changed(to: "%s" date: %s by: %s)' % (stage, date_filter, i)
        j += 1
        if j < len(logins):
            filter_str += " OR "
    output_str = "Queue: MOBILEMAIL, MMAPI (Type: Bug) AND (%s)" % filter_str

    return output_str


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_st_stat_mobmail():
    filters = project_settings.get('MOBILEMAIL')
    st_data = []
    st_data.append(get_tested_tasks_mobmail(staff_logins_list))
    st_data.append(get_tested_bugs_mobmail(staff_logins_list))
    for i in filters:
        for name, st_filter in i.items():
            issues = client.issues.find(st_filter.encode('utf8'))
            st_data.append(len(issues))
    return st_data


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_staff_worked_logins(group):
    headers = {"Authorization": "OAuth %s" % yaconfig["STAFF_TOKEN"]}
    url = 'https://staff-api.yandex-team.ru/v3/persons?_query=department_group.department.url=="{0}"%20or%20department_group.ancestors.department.url=="{0}"&_fields=login&_limit=1000'.format(
        group)
    r = requests.get(url, headers=headers)
    a = r.json().get('result')
    logins_worked_list = []

    for i in a:
        login = i.get('login')
        logins_worked_list.append(login)

    return logins_worked_list


def make_filter_staff(groups):
    j = 0
    filter_str = ""
    for i in groups:
        filter_str += 'department_group.department.url=="{0}"%20or%20department_group.ancestors.department.url=="{0}"'.format(
            i)
        j += 1
        if j < len(groups):
            filter_str += "%20or%20"
    return filter_str


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_staff_qa_logins():
    headers = {"Authorization": "OAuth %s" % yaconfig["STAFF_TOKEN"]}
    url = 'https://staff-api.yandex-team.ru/v3/persons?_query={0}&_fields=login&_limit=1000'.format(
        make_filter_staff(config.groups_qa))
    r = requests.get(url, headers=headers)
    a = r.json().get('result')
    logins_worked_list = ['nogert@']

    for i in a:
        login = i.get('login')
        if login != 'pavponn' and login != 'vasily-k' and login != 'nataliepash' and login != 'madhypnofrog':
            logins_worked_list.append(login + '@')

    return logins_worked_list


def make_logins_list(logins):
    filter_str = ""
    j = 0
    for i in logins:
        filter_str += i
        j += 1
        if j < len(logins):
            filter_str += ","
    return filter_str


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_employees_list(project_name):
    group = config.staff_groups.get(project_name)

    all_logins_list = get_staff_worked_logins(group)

    for lead in leads:
        if lead in all_logins_list:
            all_logins_list.remove(lead)

    for developer in developers:
        if developer in all_logins_list:
            all_logins_list.remove(developer)

    if project_name == 'DARIA':
        for user in cal_and_touch:
            if user in all_logins_list:
                all_logins_list.remove(user)
        return all_logins_list

    elif project_name == 'QUINN':
        logins = list(set(all_logins_list) & set(mail_touch))
        return logins

    elif project_name == 'MAYA':
        logins = list(set(all_logins_list) & set(cal))
        return logins
    elif project_name == 'MOBDEVAUTH':
        logins = list(set(all_logins_list) & set(mobdevauth))
        return logins
    elif project_name == 'PASSP':
        for user in mobdevauth:
            if user in all_logins_list:
                all_logins_list.remove(user)
        return all_logins_list

    else:
        return all_logins_list


def get_dev_logins_list():
    headers = {"Authorization": "OAuth %s" % yaconfig["STAFF_TOKEN"]}
    url = 'https://staff-api.yandex-team.ru/v3/persons?_query={0}&_fields=login,official.is_trainee&_limit=1000'.format(
        make_filter_staff(config.groups_dev))
    r = requests.get(url, headers=headers)
    a = r.json().get('result')
    logins_dev_list = []
    logins_intern_list = ['nataliepash@', 'pavponn@', 'madhypnofrog@', 'vasily-k@']

    for i in a:
        login = i.get('login')
        if login + '@' not in qa and login != 'alena' and login != 'kateogar':
            if i.get('official').get('is_trainee') == True:
                logins_intern_list.append(login + '@')
            else:
                logins_dev_list.append(login + '@')

    return logins_intern_list, logins_dev_list


def worked_sum(logins_list):
    worked_total = 0
    for login in logins_list:
        work_time = how_much_worked_in_month(login)
        worked_total += work_time
    return worked_total


def how_much_worked_in_month(login):
    headers = {"Authorization": "OAuth %s" % yaconfig["STAFF_TOKEN"]}
    url = 'https://staff-api.yandex-team.ru/v3/persons?login="{0}"&_fields=login,created_at,official.is_dismissed,official.contract_ended_at&_limit=1000'.format(
        login)
    r = requests.get(url, headers=headers)
    a = r.json().get('result')[0]
    ended = a.get('official').get('contract_ended_at')
    created = a.get('created_at')
    if ended is not None:
        ended_string = re.match(r'\d{4}-\d{2}-\d{2}', ended).group(0)
        ended_ts = datetime.datetime.strptime(ended_string, '%Y-%m-%d')
    else:
        ended_ts = None
    created_string = re.match(r'\d{4}-\d{2}-\d{2}', created).group(0)
    created_ts = datetime.datetime.strptime(created_string, '%Y-%m-%d')
    if ended_ts is None and created_ts <= month_first_day_datetime:
        return 1
    if ended_ts is None and created_ts > month_last_day_datetime:
        return 0
    if ended_ts is not None and ended_ts < month_first_day_datetime:
        return 0
    if created_ts > month_first_day_datetime and created_ts <= month_last_day_datetime:
        worked_days = float(last_month_day - int(created_ts.day)) / float(last_month_day)
        return worked_days
    if ended_ts is not None and ended_ts >= month_first_day_datetime and ended_ts <= month_last_day_datetime:
        worked_days = float(ended_ts.day) / float(last_month_day)
        return worked_days
    return 1


def get_startrek_infra_tasks(project_name, employer_type):
    if employer_type == 'qa':
        logins_list = qa
    if employer_type == 'intern':
        logins_list = dev_and_interns[0]
    if employer_type == 'dev':
        logins_list = dev_and_interns[1]
    if project == 'MOBILEMAIL':
        filter_st = make_infra_filter(project_name + ',MOBMAILQA', logins_list, "infra_ps")
    elif project == 'MOBDISK':
        filter_st = make_infra_filter(project_name + ',MOBDISKQA', logins_list, "infra_ps")
    else:
        filter_st = make_infra_filter(project_name, logins_list, "infra_ps")
    s_size = 0
    m_size = 0
    l_size = 0
    issues = client.issues.find(filter_st.encode('utf8'))
    for issue in issues:
        if issue.sizeOfRelease == 'S':
            s_size += 1
        if issue.sizeOfRelease == 'M':
            m_size += 1
        if issue.sizeOfRelease == 'L':
            l_size += 1
    return s_size * 8 + m_size * 8 * 7 + l_size * 8 * 7 * 2


def get_startrek_auto_tasks(project_name, employer_type):
    if employer_type == 'qa':
        logins_list = qa
    if employer_type == 'intern':
        logins_list = dev_and_interns[0]
    if employer_type == 'dev':
        logins_list = dev_and_interns[1]
    if project == 'MOBILEMAIL':
        filter_st = make_infra_filter(project_name + ',MOBMAILQA', logins_list, "auto_ps")
    elif project == 'MOBDISK':
        filter_st = make_infra_filter(project_name + ',MOBDISKQA', logins_list, "auto_ps")
    else:
        filter_st = make_infra_filter(project_name, logins_list, "auto_ps")
    s_size = 0
    m_size = 0
    l_size = 0
    xl_size = 0
    issues = client.issues.find(filter_st.encode('utf8'))
    for issue in issues:
        if issue.sizeOfRelease == 'S':
            s_size += 1
        if issue.sizeOfRelease == 'M':
            m_size += 1
        if issue.sizeOfRelease == 'L':
            l_size += 1
        if issue.sizeOfRelease == 'XL':
            xl_size += 1

    return s_size * 8 + m_size * 8 * 7 + l_size * 8 * 7 * 2 + xl_size * 8 * 7 * 4


def get_startrek_analytics_tasks(project_name, employer_type):
    if employer_type == 'qa':
        logins_list = qa
    if employer_type == 'intern':
        logins_list = dev_and_interns[0]
    if employer_type == 'dev':
        logins_list = dev_and_interns[1]
    if project == 'MOBILEMAIL':
        filter_st = make_infra_filter(project_name + ',MOBMAILQA', logins_list, "analytics_ps")
    elif project == 'MOBDISK':
        filter_st = make_infra_filter(project_name + ',MOBDISKQA', logins_list, "analytics_ps")
    else:
        filter_st = make_infra_filter(project_name, logins_list, "analytics_ps")
    s_size = 0
    m_size = 0
    l_size = 0
    xl_size = 0
    issues = client.issues.find(filter_st.encode('utf8'))
    for issue in issues:
        if issue.sizeOfRelease == 'S':
            s_size += 1
        if issue.sizeOfRelease == 'M':
            m_size += 1
        if issue.sizeOfRelease == 'L':
            l_size += 1
        if issue.sizeOfRelease == 'XL':
            xl_size += 1

    return s_size * 8 + m_size * 8 * 7 + l_size * 8 * 7 * 2 + xl_size * 8 * 7 * 4


def get_startrek_internal_tasks(project_name, employer_type):
    if employer_type == 'qa':
        logins_list = qa
    if employer_type == 'intern':
        logins_list = dev_and_interns[0]
    if employer_type == 'dev':
        logins_list = dev_and_interns[1]
    if project == 'MOBILEMAIL':
        filter_st = make_infra_filter(project_name + ',MOBMAILQA', logins_list, "internal_ps")
    elif project == 'MOBDISK':
        filter_st = make_infra_filter(project_name + ',MOBDISKQA', logins_list, "internal_ps")
    else:
        filter_st = make_infra_filter(project_name, logins_list, "internal_ps")
    s_size = 0
    m_size = 0
    l_size = 0
    xl_size = 0
    issues = client.issues.find(filter_st.encode('utf8'))
    for issue in issues:
        if issue.sizeOfRelease == 'S':
            s_size += 1
        if issue.sizeOfRelease == 'M':
            m_size += 1
        if issue.sizeOfRelease == 'L':
            l_size += 1
        if issue.sizeOfRelease == 'XL':
            xl_size += 1

    return s_size * 8 + m_size * 8 * 7 + l_size * 8 * 7 * 2 + xl_size * 8 * 7 * 4


def make_infra_filter(project, logins, tag):
    return '((Queue: %s) OR (Queue: TESTPERS, TESTOPITHECUS and Tags:%s)) AND Type: Task, Bug AND ((Status: changed(to: Закрыт  date: %s ) AND "QA End Date": empty()) OR "QA End Date": %s) and Resolution: Решен and Assignee: %s and Tags: %s and "Size Of Release": notEmpty()' % (
        project, config.testpers_tags.get(project), date_filter, date_filter, make_logins_list(logins), tag)


def get_asessors_tested(project_name):
    filters = config.project_asessors_tested.get(project_name)
    tsp = 0
    for i in filters:
        for name, st_filter in i.items():
            issues = client.issues.find(st_filter.encode('utf8'))
            for issue in issues:
                if issue.testingStoryPoints is not None:
                    tsp += issue.testingStoryPoints
    return tsp * config.tsp.get(project_name)


def get_asessors_prod_bugs(project_name):
    filters = config.project_asessors_prod_bugs.get(project_name)
    for i in filters:
        for name, st_filter in i.items():
            issues = client.issues.find(st_filter.encode('utf8'))

    return len(issues)


def get_support_time():
    support = 16
    if config.year == datetime.datetime.now().year and config.month == datetime.datetime.now().month:
        if datetime.datetime.now().day <= 7:
            support = 4
        elif datetime.datetime.now().day <= 14:
            support = 8
        elif datetime.datetime.now().day <= 21:
            support = 12
    return support


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_all_values(project_name):
    data_list = []
    print project_name
    if project_name == 'MOBILEMAIL':
        stat = get_st_stat_mobmail()
    else:
        stat = get_startrek_stat(project_name)
    print "Stat done"
    auto = get_auto_cases(project_name)
    print "Auto done"
    created = get_created_cases(project_name)
    print "Created done"
    runned = get_run_cases_num(project_name)
    print "Runned done"
    asessor = get_asessor_time_sum(project_name)
    print "Asessor done"
    runs_divide = get_all_runs_divide(project_name)
    print "Divide done"
    average_runned_auto_cases = get_num_autotests(project_name)
    print "Average runned autotests done"
    employees_num = worked_sum(get_employees_list(project_name))
    print "Employees number done"
    created_interns = get_created_cases_interns(project_name)
    print "Created by interns done"
    created_asessors = get_created_cases_asessors(project_name)
    print "Created by asessors done"
    infra_qa = get_startrek_infra_tasks(project_name, 'qa')
    print "Infra by qa done"
    infra_dev = get_startrek_infra_tasks(project_name, 'dev')
    print "Infra by dev done"
    infra_intern = get_startrek_infra_tasks(project_name, 'intern')
    print "Infra by intern done"
    auto_qa = get_startrek_auto_tasks(project_name, 'qa')
    print "Auto by qa done"
    auto_dev = get_startrek_auto_tasks(project_name, 'dev')
    print "Auto by dev done"
    auto_intern = get_startrek_auto_tasks(project_name, 'intern')
    print "Auto by intern done"
    analytics_qa = get_startrek_analytics_tasks(project_name, 'qa')
    print "Analytics by qa done"
    analytics_dev = get_startrek_analytics_tasks(project_name, 'dev')
    print "Analytics by dev done"
    analytics_intern = get_startrek_analytics_tasks(project_name, 'intern')
    print "Analytics by intern done"
    internal_qa = get_startrek_internal_tasks(project_name, 'qa')
    print "internal by qa done"
    internal_dev = get_startrek_internal_tasks(project_name, 'dev')
    print "internal by dev done"
    internal_intern = get_startrek_internal_tasks(project_name, 'intern')
    print "internal by intern done"
    tested_asessor = get_asessors_tested(project_name)
    print "Tested by asessors done"
    asessors_prod_bugs = get_asessors_prod_bugs(project_name)
    data_list.extend(stat)
    data_list.append(created - created_asessors - created_interns)
    data_list.append(auto[0])
    data_list.append(runned)
    data_list.append(asessor)
    data_list.extend(runs_divide)
    data_list.append(average_runned_auto_cases)
    data_list.append(employees_num)
    data_list.append(created_asessors)
    data_list.append(created_interns)
    data_list.append(auto[1])
    data_list.append(auto[2])
    data_list.append(infra_qa)
    data_list.append(infra_dev)
    data_list.append(infra_intern)
    data_list.append(auto_qa)
    data_list.append(auto_dev)
    data_list.append(auto_intern)
    data_list.append(analytics_qa)
    data_list.append(analytics_dev)
    data_list.append(analytics_intern)
    data_list.append(internal_qa)
    data_list.append(internal_dev)
    data_list.append(internal_intern)
    data_list.append(tested_asessor)
    data_list.append(asessors_prod_bugs)
    data_list.append(support_time)
    print data_list

    return data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def send_to_stat(project_name, list_data):
    data = [
        {
            "fielddate": str(month_date),
            "project": project_name,
            "tested_feature": list_data[0],
            "tested_bug": list_data[1],
            "create_test_bug": list_data[2],
            "create_prod_bug": list_data[3],
            "create_case": list_data[5],
            "auto_case": list_data[6],
            "tested_release": list_data[4],
            "run_case": list_data[7],
            "asessor": list_data[8],
            "run_auto": list_data[9],
            "run_manual": list_data[10],
            "run_asessor": list_data[11],
            "av_runned_autotests": list_data[12],
            "employees_num": list_data[13],
            "create_case_asessor": list_data[14],
            "create_case_intern": list_data[15],
            "auto_case_intern": list_data[16],
            "auto_case_dev": list_data[17],
            "infra_qa": list_data[18],
            "infra_dev": list_data[19],
            "infra_intern": list_data[20],
            "auto_qa": list_data[21],
            "auto_dev": list_data[22],
            "auto_intern": list_data[23],
            "analytics_qa": list_data[24],
            "analytics_dev": list_data[25],
            "analytics_intern": list_data[26],
            "internal_qa": list_data[27],
            "internal_dev": list_data[28],
            "internal_intern": list_data[29],
            "tested_asessor": list_data[30],
            "asessors_prod_bugs": list_data[31],
            "support": list_data[32]
        }
    ]
    print data

    attempt_number = 1
    while attempt_number < 5:
        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]},
            data={
                'name': 'Adhoc/test-mail',
                'scale': 'm',
                'data': json.dumps({'values': data}),
            },
        )
        print r.status_code
        if r.status_code == 200:
            break
        attempt_number += 1


if __name__ == '__main__':
    print(time.strftime("%Y-%m-%d"))
    support_time = get_support_time()
    qa = get_staff_qa_logins()
    dev_and_interns = get_dev_logins_list()
    for project in config.projects_tp.keys():
        # print project
        # data_to_stat = update_infra(project)
        if update_only_startrek == 0:
            print("Update all")
            data_to_stat = update_all_values(project)
        else:
            print("Update only startrek")
            data_to_stat = update_st_stat(project)

        send_to_stat(project, data_to_stat)
