# -*- coding: utf-8 -*-

import calendar
import datetime
import json
import os
import re
import sys
import time
import urllib

import requests
import yaml
from retrying import retry
from startrek_client import Startrek

import configIntern as config

reload(sys)
sys.setdefaultencoding('utf-8')

requests.urllib3.disable_warnings(requests.urllib3.exceptions.InsecureRequestWarning)

scriptPath = os.path.dirname(os.path.abspath(__file__))

yaconfig = yaml.load(open(os.path.dirname(scriptPath) + "/StartrekStat/config.yaml"))
projects = yaml.load(open(os.path.dirname(scriptPath) + "/StartrekStat/reportConf.yaml"))

project_settings = config.project_settings
robots = config.robots

client = Startrek(useragent="curl/7.53.1", token=yaconfig["AUTH_ST"])

update_only_startrek = 0

month = config.month

if month == 0:
    month = datetime.datetime.now().month

date_today = datetime.datetime.now()
last_month_day = calendar.monthrange(datetime.datetime.now().year, month)[1]
month_first_day = date_today.replace(month=month, day=1, hour=0, minute=0, second=0, microsecond=0)
month_last_day = date_today.replace(month=month, day=last_month_day, hour=23, minute=59, second=59, microsecond=0)
month_date = datetime.date.today().replace(month=month, day=1)
date_max = datetime.date.today().replace(month=month, day=last_month_day)
year = datetime.datetime.now().year

month_first_day_date = datetime.date(year, month, 1)
month_last_day_date = datetime.date(year, month, last_month_day)
month_15_day_date = datetime.date(year, month, 15)
min_time = datetime.datetime.min.time()
max_time = datetime.datetime.max.time()

month_first_day_datetime = datetime.datetime.combine(month_first_day_date, min_time)
month_last_day_datetime = datetime.datetime.combine(month_last_day_date, max_time)
month_15_day_datetime = datetime.datetime.combine(month_15_day_date, min_time)

date_filter = '%s-%s-%s .. %s-%s-%s' % (1, month, year, last_month_day, month, year)

firstDayTS = str(int(time.mktime(month_first_day.timetuple()) * 1000))
nowTS = str(int(time.mktime(datetime.datetime.now().timetuple()) * 1000))
lastDayTS = str(int(time.mktime(month_last_day.timetuple()) * 1000))

firstDayIntTS = int(time.mktime(month_first_day.timetuple()) * 1000)
lastDayIntTS = int(time.mktime(month_last_day.timetuple()) * 1000)

print month_first_day
print month_last_day
print date_today

no_auto_data = ['CHEMODAN, DOCVIEWER', 'DISCSW', 'PASSP', 'MOBDEVAUTH']

ROBOTS = [
    "robot-gerrit",
    "robot-aqua-testpers robot-aqua-testpers",
    "zomb-mobmail-qa",
]

cal = ['annrid', 'olga-ganchikova']

mail_touch = ['oleshko', 'sshelgunova', 'mastugan']

leads = ['cosmopanda', 'alena', 'olyd', 'yaroslavna', 'kateogar', 'gladnik']

mobdevauth = ['oafashokov']

developers = ['vasily-k', 'madhypnofrog', 'pavponn', 'kidyankin']

cal_and_touch = []
cal_and_touch.extend(mail_touch)
cal_and_touch.extend(cal)

staff_logins_list = config.get_staff_logins_intern()


def created_cases(first_day, last_day):
    time_filter = {
        "type": "AND",
        "left": {
            "type": "GT",
            "key": "createdTime",
            "value": first_day
        },
        "right": {
            "type": "LT",
            "key": "createdTime",
            "value": last_day
        }
    }
    return time_filter


def created_cases_intern(login, first_day, last_day):
    time_filter = {
        "type": "AND",
        "left": {
            "type": "EQ",
            "key": "createdBy",
            "value": login
        },
        "right": {
            "type": "AND",
            "left": {
                "type": "GT",
                "key": "createdTime",
                "value": first_day
            },
            "right": {
                "type": "LT",
                "key": "createdTime",
                "value": last_day
            }
        }
    }
    return time_filter


def finished_run(first_day, last_day):
    time_filter = {
        "type": "AND",
        "left": {
            "type": "GT",
            "key": "finishedTime",
            "value": first_day
        },
        "right": {
            "type": "LT",
            "key": "finishedTime",
            "value": last_day
        }
    }
    return time_filter


def get_automated():
    request = {
        "type": "EQ",
        "key": "isAutotest",
        "value": "true"
    }
    return request


finished_run_filter = finished_run(firstDayTS, lastDayTS)
created_cases_filter = created_cases(firstDayTS, lastDayTS)
automated_cases_filter = get_automated()


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_created_cases(project_name):
    created_cases_num = 0

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    run_filter = json.dumps(created_cases_filter, ensure_ascii=False, separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    for queue in config.projects_tp.get(project_name):
        url = "https://testpalm-api.yandex-team.ru/testcases/%s?include=id&expression=%s" % (queue, url_body)
        res = requests.get(url, headers=headers, verify=False)

        cases = json.loads(res.text)
        created_cases_num += len(cases)

    return created_cases_num


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def num_of_automated_cases(project_name):
    auto_cases = 0

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    run_filter = json.dumps(automated_cases_filter, ensure_ascii=False, separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    for queue in config.projects_tp.get(project_name):
        if queue != 'diskdesktop':
            url = "https://testpalm-api.yandex-team.ru/testcases/%s/?include=id&expression=%s" % (queue, url_body)

            res = requests.get(url, headers=headers, verify=False)

            cases = json.loads(res.text)
            auto_cases += len(cases)

    return auto_cases


def get_num_autotests(project_name):
    st_stat = get_startrek_releases_stat(project_name)
    autotests_num = num_of_automated_cases(project_name)
    data = st_stat[0] * autotests_num + st_stat[1] * 2 * autotests_num

    return data


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_startrek_releases_stat(project_name):
    filters = config.project_releases.get(project_name)
    st_data = []
    for i in filters:
        for name, st_filter in i.items():
            issues = client.issues.find(st_filter.encode('utf8'))
            st_data.append(len(issues))
    return st_data


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_auto_cases(project_name):
    auto_cases = 0

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    run_filter = json.dumps(automated_cases_filter, ensure_ascii=False, separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    for queue in config.projects_tp.get(project_name):
        url = "https://testpalm-api.yandex-team.ru/testcases/%s/?include=id&expression=%s" % (queue, url_body)

        res = requests.get(url, headers=headers, verify=False)
        automated_cases_list = []
        automated_in_month = []

        cases = json.loads(res.text)
        for case in cases:
            automated_cases_list.append(case.get('id'))
            if is_case_automated_in_month(queue, case.get('id')) == 1:
                automated_in_month.append(case.get('id'))
        auto_cases += len(automated_in_month)

    return auto_cases


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_startrek_stat(project_name):
    filters = project_settings.get(project_name)
    st_data = []
    for i in filters:
        for name, st_filter in i.items():
            issues = client.issues.find(st_filter.encode('utf8'))
            st_data.append(len(issues))
    return st_data


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def is_case_automated_in_month(project_name, case_id):
    req_headers = {"TestPalm-Api-Token": yaconfig["AUTH_TP"], "Content-Type": "application/json"}
    url = "https://testpalm.yandex-team.ru/api/eventslog/%s/preview?limit=100&skip=0&testcaseId=%s&type=UPDATED" % (
        project_name, case_id)
    flag = 0
    res = requests.get(url, headers=req_headers)
    events = json.loads(res.text)
    for event in events:
        if 'changes' in event.keys() and event.get('lastModifiedTime') >= int(firstDayTS) and event.get(
                'lastModifiedTime') <= int(lastDayTS):
            if 'changedProperties' in event.get('changes'):
                if 'isAutotest' in event.get('changes').get('changedProperties'):
                    flag = 1
                    break
        # else:
        #     break
    return flag


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_all_runs_ids(project_name):
    runs_id_list = []

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    run_filter = json.dumps(finished_run_filter, ensure_ascii=False, separators=(",", ": "))
    url_body = urllib.quote(run_filter)

    url = "https://testpalm-api.yandex-team.ru/testrun/%s?include=id&expression=%s" % (
        project_name, url_body)

    res = requests.get(url, headers=headers, verify=False)

    runs = json.loads(res.text)

    for run in runs:
        runs_id_list.append(run.get('id'))

    return runs_id_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def divide_run(project_name, run_id):
    cases = 0

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}

    run_type = 'DONT KNOW'

    url = "https://testpalm-api.yandex-team.ru/testrun/%s/%s?" \
          "include=launcherInfo,createdBy,title,testSuite,parentIssue,resolution" % (project_name, run_id)

    res = requests.get(url, headers=headers, verify=False)

    run_info = json.loads(res.text)

    if 'smoke' in run_info.get('title').lower():
        run_type = 'manual'

    if run_info.get('testSuite'):
        if 'tags' in run_info.get('testSuite'):
            if 'AssessorReg' in run_info.get('testSuite').get('tags'):
                run_type = 'ases'

    if run_info.get('testSuite'):
        if 'tags' in run_info.get('testSuite'):
            if 'ManualReg' in run_info.get('testSuite').get('tags'):
                run_type = 'manual'

    if run_info.get('launcherInfo').get('external') and run_info.get('createdBy') in robots:
        run_type = 'auto'

    if 'asses' in run_info.get('title').lower() or 'ases' in run_info.get('title').lower() \
            or 'acces' in run_info.get('title').lower() or 'асес'.decode('utf-8') in run_info.get('title').lower():
        run_type = 'ases'

    if 'autotest' in run_info.get('title').lower() or 'auto' in run_info.get('title').lower():
        run_type = 'auto'

    if run_info.get('parentIssue'):
        if 'groupId' in run_info.get('parentIssue'):
            if 'exp' in run_info.get('parentIssue').get('groupId').lower() or 'asess' in run_info.get(
                    'parentIssue').get('groupId').lower() or 'amtest' in run_info.get('parentIssue').get(
                'groupId').lower() or 'mobmailios' in run_info.get('parentIssue').get(
                'groupId').lower() or 'mobmailandriod' in run_info.get('parentIssue').get(
                'groupId').lower() or 'mobdiskaa' in run_info.get('parentIssue').get(
                'groupId').lower() or 'mobdiskia' in run_info.get('parentIssue').get('groupId').lower():
                run_type = 'ases'

    if 'toloka' in run_info.get('title').lower():
        run_type = 'ases'

    if 'ответственному'.decode('utf-8') in run_info.get('title').lower() or 'release check list' in run_info.get(
            'title').lower():
        run_type = 'manual'

    if run_type == 'DONT KNOW':
        run_type = 'manual'

    if run_type == 'manual':
        cases = get_cases_run_by_interns(project_name, run_id)
        print cases

    return cases


def get_cases_run_by_interns(project_name, run_id):
    cases_count = 0
    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    url = "https://testpalm-api.yandex-team.ru/testrun/%s/%s?" \
          "include=participants,testGroups" % (project_name, run_id)
    res = requests.get(url, headers=headers, verify=False)
    run_info = json.loads(res.text)
    for user in staff_logins_list:
        if user in run_info.get("participants"):
            cases_list = run_info.get('testGroups')[0].get('testCases')
            for case in cases_list:
                if case.get('finishedBy') in staff_logins_list:
                    cases_count += 1
        else:
            continue
    return cases_count


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_all_runs_divide(project_name):
    manual_run = 0

    for project in config.projects_tp.get(project_name):

        runs_list = get_all_runs_ids(project)

        for run_id in runs_list:
            stat = divide_run(project, run_id)
            manual_run += stat

    return manual_run


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def get_current_stat(project_name):
    current_data = requests.get(
        'https://upload.stat.yandex-team.ru/_api/statreport/json/Adhoc/test-mail-intern?scale=m&date_mах=%s&project=%s' %
        (date_max, project_name),
        headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]}).json()
    current_data_list = []
    for i in current_data.get('values'):
        if i.get('fielddate') == str(month_first_day):
            current_data_list.extend(
                [i.get('tested_feature'), i.get('tested_bug'), i.get('create_test_bug'), i.get('create_prod_bug'),
                 i.get('create_case'), i.get('auto_case'), i.get('run_manual'),
                 i.get('employees_num')])
    if current_data_list == []:
        current_data_list = [0] * 9
    return current_data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_st_stat(project_name):
    new_data_list = []
    if project_name == 'MOBILEMAIL':
        new_data_list.extend(get_st_stat_mobmail())
    else:
        new_data_list.extend(get_startrek_stat(project_name))
    new_data_list.extend(get_current_stat(project_name)[4:])

    return new_data_list


def update_av_auto(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[12] = get_num_autotests(project_name)

    return new_data_list


def update_auto_case(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[6] = get_auto_cases(project_name)

    return new_data_list


def update_employees_num(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[7] = worked

    return new_data_list


def update_created_cases(project_name):
    new_data_list = []
    new_data_list.extend(get_current_stat(project_name))
    new_data_list[5] = get_created_cases(project_name)

    return new_data_list


def get_tested_tasks_mobmail(staff_logins):
    issues_list = []
    issues_list_keys = []
    fltr1 = 'Протестировано'
    fltr2 = 'Ready for RC'
    st_filter = make_tested_tasks_filter_mobmail(staff_logins, fltr1)
    issues = client.issues.find(st_filter.encode('utf8'))
    issues_list.extend(issues)
    st_filter = make_tested_tasks_filter_mobmail(staff_logins, fltr2)
    issues = client.issues.find(st_filter.encode('utf8'))
    issues_list.extend(issues)
    for i in issues_list:
        issues_list_keys.append(i.key)

    return len(set(issues_list_keys))


def get_tested_bugs_mobmail(staff_logins):
    issues_list = []
    issues_list_keys = []
    fltr1 = 'Протестировано'
    fltr2 = 'Ready for RC'
    st_filter = make_tested_bugs_filter_mobmail(staff_logins, fltr1)
    issues = client.issues.find(st_filter.encode('utf8'))
    issues_list.extend(issues)
    st_filter = make_tested_bugs_filter_mobmail(staff_logins, fltr2)
    issues = client.issues.find(st_filter.encode('utf8'))
    issues_list.extend(issues)
    for i in issues_list:
        issues_list_keys.append(i.key)

    return len(set(issues_list_keys))


def make_tested_tasks_filter_mobmail(logins, stage):
    filter_str = ""
    j = 0
    for i in logins:
        filter_str += 'Status: changed(to: "%s" date: %s by: %s)' % (stage, date_filter, i)
        j += 1
        if j < len(logins):
            filter_str += " OR "
    output_str = "Queue: MOBILEMAIL, MMAPI (Type: Task OR Type: New Feature OR Type: Impovement) AND (%s)" % filter_str

    return output_str


def make_tested_bugs_filter_mobmail(logins, stage):
    filter_str = ""
    j = 0
    for i in logins:
        filter_str += 'Status: changed(to: "%s" date: %s by: %s)' % (stage, date_filter, i)
        j += 1
        if j < len(logins):
            filter_str += " OR "
    output_str = "Queue: MOBILEMAIL, MMAPI (Type: Bug) AND (%s)" % filter_str

    return output_str


def get_st_stat_mobmail():
    filters = project_settings.get('MOBILEMAIL')
    st_data = []
    st_data.append(get_tested_tasks_mobmail(staff_logins_list))
    st_data.append(get_tested_bugs_mobmail(staff_logins_list))
    for i in filters:
        for name, st_filter in i.items():
            issues = client.issues.find(st_filter.encode('utf8'))
            st_data.append(len(issues))
    return st_data


def get_staff_worked_logins():
    headers = {"Authorization": "OAuth %s" % yaconfig["STAFF_TOKEN"]}
    url = 'https://staff-api.yandex-team.ru/v3/persons?_query=department_group.department.url=="yandex_infra_tech_testing_framework_personal_dep54922"%20or%20department_group.ancestors.department.url=="yandex_infra_tech_testing_framework_personal_dep54922"%20or%20login=="nataliepash"&_fields=login,created_at,official.is_dismissed,official.contract_ended_at&_limit=1000'
    r = requests.get(url, headers=headers)
    a = r.json().get('result')
    worked_in_month = 0

    for i in a:
        ended = i.get('official').get('contract_ended_at')
        created = i.get('created_at')
        worked_in_month += how_much_worked_in_month(ended, created)

    return worked_in_month


def how_much_worked_in_month(ended, created):
    if ended is not None:
        ended_string = re.match(r'\d{4}-\d{2}-\d{2}', ended).group(0)
        ended_ts = datetime.datetime.strptime(ended_string, '%Y-%m-%d')
    else:
        ended_ts = None
    created_string = re.match(r'\d{4}-\d{2}-\d{2}', created).group(0)
    created_ts = datetime.datetime.strptime(created_string, '%Y-%m-%d')
    if ended_ts is None and created_ts <= month_first_day_datetime:
        return 1
    if ended_ts is None and created_ts > month_last_day_datetime:
        return 0
    if ended_ts is not None and ended_ts < month_first_day_datetime:
        return 0
    if created_ts > month_first_day_datetime and created_ts <= month_last_day_datetime:
        worked_days = float(last_month_day - int(created_ts.day)) / float(last_month_day)
        return worked_days
    if ended_ts >= month_first_day_datetime and ended_ts <= month_last_day_datetime:
        worked_days = float(ended_ts.day) / float(last_month_day)
        return worked_days
    return 1


def created_cases_by_intern(project_name):
    created_cases_num = 0
    for user in staff_logins_list:
        created_cases_intern_filter = created_cases_intern(user, firstDayTS, lastDayTS)

        headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
        run_filter = json.dumps(created_cases_intern_filter, ensure_ascii=False, separators=(",", ": "))
        url_body = urllib.quote(run_filter)

        for queue in config.projects_tp.get(project_name):
            url = "https://testpalm-api.yandex-team.ru/testcases/%s?include=id&expression=%s" % (queue, url_body)
            res = requests.get(url, headers=headers, verify=False)

            cases = json.loads(res.text)
            created_cases_num += len(cases)

    return created_cases_num


worked = get_staff_worked_logins()


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def update_all_values(project_name):
    data_list = []
    print project_name
    if project_name == 'MOBILEMAIL':
        stat = get_st_stat_mobmail()
    else:
        stat = get_startrek_stat(project_name)
    print "Stat done"
    auto = 0
    # auto = get_auto_cases(project_name)
    print "Auto done"
    created = 0
    # created = created_cases_by_intern(project_name)
    print "Created done"
    runs_divide = get_all_runs_divide(project_name)
    print "Divide done"
    employees_num = worked
    print "Interns number done"
    data_list.extend(stat)
    data_list.append(created)
    data_list.append(auto)
    data_list.append(runs_divide)
    data_list.append(employees_num)
    print data_list

    return data_list


@retry(stop_max_attempt_number=2, wait_fixed=3000)
def send_to_stat(project_name, list_data):
    data = [
        {
            "fielddate": str(month_date),
            "project": project_name,
            "tested_feature": list_data[0],
            "tested_bug": list_data[1],
            "create_test_bug": list_data[2],
            "create_prod_bug": list_data[3],
            "create_case": list_data[4],
            "auto_case": list_data[5],
            "run_manual": list_data[6],
            "employees_num": list_data[7]
        }
    ]
    print data

    attempt_number = 1
    while attempt_number < 5:
        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig["AUTH_STAT"]},
            data={
                'name': 'Adhoc/test-mail-intern',
                'scale': 'm',
                'data': json.dumps({'values': data}),
            },
        )
        print r.status_code
        if r.status_code == 200:
            break
        attempt_number += 1


if __name__ == '__main__':
    print(time.strftime("%Y-%m-%d"))
    for project in config.projects_tp.keys():
        if update_only_startrek == 0:
            print("Update all")
            data_to_stat = update_all_values(project)
        else:
            print("Update only startrek")
            data_to_stat = update_st_stat(project)

        send_to_stat(project, data_to_stat)
