# -*- coding: utf-8 -*-

from datetime import timedelta, date
from pathlib import Path
from startrek_client import Startrek
from yql.api.v1.client import YqlClient
import os
import sys

sys.path.append(str(Path(__file__).parent.parent.parent))
from set_secret import set_secret

set_secret.set_secrets()
clientYt = YqlClient(db='hahn', token=os.environ["YQL_TOKEN"])

client = Startrek(useragent='curl/7.53.1', token=os.environ['STARTRECK_TOKEN'])
headers_st = {'Authorization': 'OAuth ' + os.environ['STARTRECK_TOKEN']}
st_host = 'https://st-api.yandex-team.ru/v2/'


def get_linked_exps():
    issues = client.issues.find(
        f'Queue: DARIA AND Status: !Закрыт AND Type: Epic'
    )
    for issue in issues:
        percent_list = []
        links_exps = []
        links_mailqa = []
        ticket_for_cases = ""
        ticket_for_ac = ""
        ticket_for_bl = ""
        for item in issue.links.get_all():
            if item.object.key.startswith(u'MAILQA'):
                links_mailqa.extend([item.object.key])
                if item.object.summary.startswith(u'Кейсы'):
                    ticket_for_cases = item.object.key
                if item.object.summary.startswith(u'BL автотесты'):
                    ticket_for_bl = item.object.key
                if item.object.summary.startswith(u'AC автотесты'):
                    ticket_for_ac = item.object.key
        links_exps.extend(
            [item.object.key for item in issue.links.get_all() if item.object.key.startswith(u'EXPERIMENTS')])

        if links_mailqa and links_exps:
            for exp_ticket in links_exps:
                percent = get_exp_info_from_table(exp_ticket)
                if percent != 0:
                    percent_list.append(percent)
            if 10 < min(percent_list) < 30:
                set_deadline(ticket_for_cases, 14)
            elif 30 <= min(percent_list) < 50:
                set_deadline(ticket_for_cases, 14)
                set_deadline(ticket_for_ac, 14)
            elif 50 <= min(percent_list) <= 100:
                set_deadline(ticket_for_cases, 7)
                set_deadline(ticket_for_ac, 14)
                set_deadline(ticket_for_bl, 21)


def get_exp_info_from_table(ticket):
    request = clientYt.query(
        """
        SELECT sum(percent) FROM `home/mailfront/qa/exp-config` as T
         WHERE (title NOT LIKE "%контроль%" AND title NOT LIKE "%Контроль%" AND title NOT LIKE "%корп%"
         AND title NOT LIKE "%Корп%" AND title NOT LIKE "%Corp%" AND title NOT LIKE "%corp%" AND
         ticket = "{}" )""".format(
            ticket),
        syntax_version=1
    )
    request.run()

    for table in request.get_results():
        if table.rows[0][0] is None:
            return 0
        else:
            return int(table.rows[0][0])


def set_deadline(ticket, delta):
    if ticket != "":
        ticket_info = client.issues.find("Key: {}".format(ticket))[0]
        if ticket_info.status.key != 'closed' and ticket_info.deadline is None:
            deadline = date.today() + timedelta(days=delta)
            issues = client.issues.find("Key: {}".format(ticket))
            client.bulkchange.update(
                issues[0].key,
                deadline=deadline.strftime('%Y-%m-%d')
            )


if __name__ == '__main__':
    get_linked_exps()
