# -*- coding: utf-8 -*-

import os
import sys
from pathlib import Path

from startrek_client import Startrek

sys.path.append(str(Path(__file__).parent.parent.parent))
from set_secret import set_secret

set_secret.set_secrets()

client = Startrek(useragent='curl/7.53.1', token=os.environ['STARTRECK_TOKEN'])
headers_st = {'Authorization': 'OAuth ' + os.environ['STARTRECK_TOKEN']}
st_host = 'https://st-api.yandex-team.ru/v2/'


def create_ticket_for_writing_cases():
    issues = client.issues.find(
        f'(Queue: DARIA) AND (Status: !Закрыт) and Type: Epic and Tags: need_qa_internal_tasks'
    )
    for issue in issues:
        response1 = client.issues.create(
            queue='MAILQA',
            summary='Кейсы для задачи ' + issue.summary,
            type={'name': 'Task'},
            tags='cases'
        )
        response1.links.create(
            issue=issue,
            relationship='relates'
        )
        response2 = client.issues.create(
            queue='MAILQA',
            summary='AC автотесты для задачи ' + issue.summary,
            type={'name': 'Task'},
            tags='automation'
        )
        response2.links.create(
            issue=issue,
            relationship='relates'
        )
        response3 = client.issues.create(
            queue='MAILQA',
            summary='BL автотесты для задачи ' + issue.summary,
            type={'name': 'Task'},
            tags='automation')
        response3.links.create(
            issue=issue,
            relationship='relates'
        )
        client.bulkchange.update(
            issue.key,
            tags={'remove': ['need_qa_internal_tasks']}
        )


if __name__ == '__main__':
    create_ticket_for_writing_cases()
