# -*- coding: utf-8 -*-
import os
import logging

import urllib3
from startrek_client import Startrek
from set_secret import set_secret

set_secret.set_secrets()

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s',
    level=logging.INFO)

scriptPath = os.path.dirname(os.path.abspath(__file__) + '/AsessorQueueMonitoring')
client = Startrek(useragent='curl/7.53.1', token=os.environ['STARTRECK_TOKEN'])


def version_is_empty(link):
    issue = client.issues[link.object.key]
    fix_version = client.issues[issue.key].fixVersions
    if not fix_version:
        return True
    return False


def update_version():
    issues = client.issues.find('Queue: MAILEXP AND Type: task AND Resolution: empty()')
    logging.info(' found issues %s' % issues)
    for issue in issues:
        version = client.issues[issue.key].fixVersions[0].display
        logging.info(' found issues for version %s' % version)
        links = client.issues[issue.key].links.get_all()
        for link in links:
            if version_is_empty(link):
                linked_issue = client.issues[link.object.key]
                linked_issue.update(fixVersions=version)
                logging.info(' add version %s to issue %s' % (version, linked_issue.key))


update_version()
