# -*- coding: utf-8 -*-
import datetime
import json
import logging
import os
import time
from collections import defaultdict
from datetime import timedelta, date

import pytz
import requests
import yaml
from yql.api.v1.client import YqlClient

scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
client = YqlClient(db='hahn', token=yaconfig['YQL_TOKEN'])
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)

month = date.today() - timedelta(days=(date.today().day - 1))
dateLimit = int(time.mktime(month.timetuple())) * 1000
# dateLimit = int(time.mktime(month.replace(month=5, day=1, year=2020).timetuple())) * 1000
# dateFinish = int(time.mktime(month.replace(month=6, day=1, year=2020).timetuple())) * 1000
local_tz = pytz.timezone('Europe/Moscow')


def get_waiting_time_with_yt(vers_name, queue_name, start_timestamp):
    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    if (queue_name == 'diskpublic' and vers_name == u'web_rc_public_tech_47_desktop'):
        vers_name = u'web_rc_public_tech_47'
    if (queue_name == 'diskclient' and vers_name == u'NK_exp_NoAutoTests_desktop'):
        vers_name = u'NK_exp_NoAutoTests_disktop'
    url = "https://testpalm-api.yandex-team.ru/version/%s/%s/?include=startedTime" % (queue_name, vers_name)
    res = requests.get(url, headers=headers, verify=False)
    times = json.loads(res.text)

    waiting_time_yt = (float(times.get('startedTime')) - float(start_timestamp)) / (1000 * 60 * 60)

    return waiting_time_yt


projects_12_24 = ['mobmail_android', 'mobmail_ios', 'mobilemail', 'adisk', 'idisk', 'cal', 'passport', 'diskclient',
                  'diskpublic', 'am-android', 'am-ios', 'disk_win', 'diskfront', 'diskdesktop', 'mail-lite']
projects_24_36 = ['disk_mac']
projects_6 = ['mail-touch', 'mail-liza']


def is_deadline_ok(queue_name, st_timestamp, fin_timestamp):
    st_timestamp /= 1000.0
    fin_timestamp /= 1000.0
    flag = 'True'
    data_start = datetime.datetime.fromtimestamp(st_timestamp)
    data_fin = datetime.datetime.fromtimestamp(fin_timestamp)
    data_start_local = local_tz.localize(data_start)
    data_fin_local = local_tz.localize(data_fin)
    day = datetime.datetime.weekday(data_start_local)
    hour = data_start_local.hour

    closest_monday_date = data_start_local.replace(hour=0, minute=0, second=0) + datetime.timedelta(days=7 - day)
    next_day = data_start_local.replace(hour=10, minute=0, second=0) + datetime.timedelta(days=1)
    day_after_tomorrow = data_start_local.replace(hour=10, minute=0, second=0) + datetime.timedelta(days=2)

    if queue_name in projects_6:
        if (day == 4 and hour >= 16) or day == 5 or day == 6 or (day == 0 and hour < 4):
            if data_fin_local > closest_monday_date.replace(hour=10):
                flag = 'False'
        elif (fin_timestamp - st_timestamp) / 3600 > 6:
            flag = 'False'

    if queue_name in projects_12_24:
        if (day == 4 and hour >= 10) or day == 5 or (day == 6 and hour < 10):
            if data_fin_local > closest_monday_date.replace(hour=10):
                flag = 'False'
        elif hour >= 22 or hour < 10:
            if (fin_timestamp - st_timestamp) / 3600 > 12:
                flag = 'False'
        elif hour >= 10 or hour < 22:
            if data_fin_local > next_day:
                flag = 'False'

    if queue_name in projects_24_36:
        if (day == 4 and hour >= 10) or day == 5 or (day == 6 and hour < 10):
            if data_fin_local > closest_monday_date.replace(hour=10):
                flag = 'False'
        elif hour >= 22 or hour < 10:
            if (fin_timestamp - st_timestamp) / 3600 > 24:
                flag = 'False'
        elif hour >= 10 or hour < 22:
            if data_fin_local > day_after_tomorrow:
                flag = 'False'

    return flag


def is_assessor_version(version):
    if 'мониторинг' in version.lower() or 'monitor' in version.lower() or 'feature' in version.lower() \
            or 'регулярный' in version.lower():
        return False
    return True


request = client.query(r"""
    SELECT namespace, version, started_ts, finished_ts
    FROM `home/assessor-production/qa/testing/link551/regress/main_2/versions` as T
    WHERE namespace LIKE "%mail%" AND finished_ts >=  """ + str(dateLimit) +
                       """OR namespace LIKE "cal" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "diskpublic" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "adisk" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "idisk" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "diskfront" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "diskclient" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "%passport%" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "am-ios" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "am-android" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "diskdesktop" AND finished_ts >= """ + str(dateLimit) +
                       """OR namespace LIKE "disc3" AND finished_ts >= """ + str(dateLimit)
                       , syntax_version=1)

request.run()

request2 = client.query(r"""
    SELECT namespace, version, started_ts, finished_ts
    FROM `home/assessor-production/qa/testing/link551/regress/main_2/archived_data/versions` as T
    WHERE namespace LIKE "%mail%" AND finished_ts >=  """ + str(dateLimit) +
                        """OR namespace LIKE "cal" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "diskpublic" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "adisk" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "idisk" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "diskfront" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "diskclient" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "%passport%" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "am-ios" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "am-android" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "diskdesktop" AND finished_ts >= """ + str(dateLimit) +
                        """OR namespace LIKE "disc3" AND finished_ts >= """ + str(dateLimit)
                        , syntax_version=1)

request2.run()

# Собираем из таблицы список ранов в формате [очередь, версия, начало, конец]
assessor_runs = list()
for table in request.get_results():
    table.fetch_full_data()
    for row in table.rows:
        runs = list()
        for cell in row:
            runs.append(cell)
        assessor_runs.append(runs)

for table in request2.get_results():
    table.fetch_full_data()
    for row in table.rows:
        runs = list()
        for cell in row:
            runs.append(cell)
        assessor_runs.append(runs)

assessor_versions = {
    'mail-touch': [], 'mail-liza': [], 'cal': [],
    'adisk': [], 'idisk': [], 'diskfront': [],
    'am-android': [], 'am-ios': [], 'passport': [],
    'mobmail_android': [], 'mobmail_ios': [],
    'diskdesktop': [], 'disk_mac': [], 'disk_win': [],
    'mail-lite': [], 'diskclient': [], 'diskpublic': []
}

# Для каждой очереди формируем словарь: {очередь: [версия, начало, конец]}
for i in range(len(assessor_runs)):
    version = assessor_runs[i]
    queue = version[0]
    version_name = version[1].replace('%20', ' ').encode('utf-8')
    wait_time = get_waiting_time_with_yt(version[1], queue, version[2])
    if queue == 'passport-asessors':
        queue = 'passport'
    if queue == 'disc3':
        queue = 'diskdesktop'
    # if queue == 'diskclient':
    #     queue = 'diskfront'
    # if queue == 'diskpublic':
    #     queue = 'diskfront'
    if queue == 'diskdesktop':
        if 'mac' in version_name or 'Mac' in version_name:
            queue = 'disk_mac'
        if 'Win' in version_name or 'win' in version_name or 'Notes' in version_name:
            queue = 'disk_win'
    if queue == 'mobilemail':
        if 'android' in version_name.lower():
            queue = 'mobmail_android'
        else:
            queue = 'mobmail_ios'

    # Фильтр по названию версии
    if is_assessor_version(version_name):
        run = [version_name, version[2], version[3], wait_time]
        assessor_versions[queue].append(run)
    else:
        continue

# Расчитываем длительность каждой версии и делим их по месяцам
assessor_data = dict()
for queue in assessor_versions:
    versions = assessor_versions[queue]
    runs_month = defaultdict(list)
    for i in range(len(versions)):
        single_ver = versions[i]
        reportDate = str(date.fromtimestamp(single_ver[1] / 1000))
        duration = int(single_ver[2] - single_ver[1]) / 1000 / 60
        version_name = single_ver[0]
        waiting_time = single_ver[3]
        start_ts = str(datetime.datetime.fromtimestamp(single_ver[1] / 1000))
        deadline = is_deadline_ok(queue, single_ver[1], single_ver[2])
        version_stat = [reportDate, duration, version_name, deadline, waiting_time, start_ts]

        if queue in assessor_data:
            assessor_data[queue].append(version_stat)
        else:
            assessor_data[queue] = [version_stat]

for queue in assessor_data:
    versions = assessor_data[queue]
    for single_version in range(len(versions)):
        version = versions[single_version]
        data = [
            {
                'fielddate': version[5],
                'queue': queue,
                'duration': version[1],
                'version': version[2],
                'deadline': version[3],
                'waiting': version[4]
            }
        ]
        print(data)
        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
            data={
                'name': 'Adhoc/test_asessors_sec',
                'scale': 's',
                'data': json.dumps({'values': data})
            }
        )
        logging.info(' Stat response: %s' % r.text)
