# -*- coding: utf-8 -*-
import logging
import os
import time
import json
from datetime import datetime, timedelta, date

import numpy
import requests
import urllib3
import yaml
from retrying import retry
from yql.api.v1.client import YqlClient

from SuitesByTag import get_suites

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/RegressionStatGraph')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
client = YqlClient(db='hahn', token=yaconfig['YQL_TOKEN'])
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)

# получаем дату: 1 число текущего месяца и переводим ее в миллисекунды
month = date.today() - timedelta(days=(date.today().day - 1))
dateLimit = int(time.mktime(month.timetuple())) * 1000
# dateLimit = int(time.mktime(month.replace(month=3, day=1, year=2020).timetuple())) * 1000
# dateFinish = int(time.mktime(month.replace(month=4, day=1, year=2020).timetuple())) * 1000
reportDate = str(date.fromtimestamp(dateLimit / 1000))
robots = yaconfig['robots']


def is_assessor_version(version):
    if 'asses' in version.lower() or 'ases' in version.lower() or 'acces' in version.lower() \
            or 'асес'.decode('utf-8') in version.lower():
        return True


def is_monitoring_version(version):
    if 'мониторинг'.decode('utf-8') in version.lower() or 'monitoring' in version.lower() \
            or 'регулярный'.decode('utf-8') in version.lower():
        return True


def is_last_month(finished_date):
    if finished_date >= dateLimit:
        return True
    return False


def is_not_empty(testruns):
    if not testruns:
        return False
    return True


def is_finished(single_run):
    if single_run['status'] == 'FINISHED':
        return True
    return False


def use_for_autotests_computing(version):
    if independentAutotestVersion:
        if 'autotest' in version.lower():
            return True
        else:
            return False
    return not is_assessor_version(version) and not is_monitoring_version(version)


def compute_finish_date(version_overview):
    version_finished_time = int(version_overview['version']["finishedTime"]) / 1000
    last_run = max(version_overview['testruns'], key=lambda run: run['finishedTime'])
    testrun_finished_time = int(last_run['finishedTime']) / 1000
    version_date = date.fromtimestamp(version_finished_time)
    testrun_date = date.fromtimestamp(testrun_finished_time)
    if abs((version_date - testrun_date).days) > 7:
        return str(testrun_date - timedelta(days=(testrun_date.day - 1)))
    return str(version_date - timedelta(days=(version_date.day - 1)))


def created_by_robot(testrun):
    return testrun['createdBy'] in robots


def is_autotest(testrun):
    return testrun['launcherInfo']['external'] and created_by_robot(testrun)


def cluster_runs(testruns):
    sorted_runs = sorted(testruns[:], key=lambda r: r['finishedTime'])
    cluster_set = []
    current_cluster = [sorted_runs[0]]
    for index in range(1, len(sorted_runs)):
        run = sorted_runs[index]
        if run['startedTime'] - current_cluster[len(current_cluster) - 1]['finishedTime'] < 120000:  # 3 минуты
            current_cluster.append(run)
        else:
            cluster_set.append(current_cluster)
            current_cluster = [run]
    cluster_set.append(current_cluster)
    return cluster_set


def cluster_date(testrun):
    fin_time = date.fromtimestamp(int(testrun['finishedTime']) / 1000)
    return fin_time


def testrun_cluster_key(testrun):
    """
    Создаем ключ вида <testsuiteid | имя рана> - <год-месяц-день> что бы отличать раны по разным дням
    :param testrun: объект рана из версии
    :return: ключ по которому будет идентифицировать ран.
    """
    run_title = compute_run_title(testrun)

    return run_title + ' - ' + cluster_date(testrun).strftime('%Y-%m-%d')


def compute_run_title(testrun):
    if 'testSuite' in testrun:
        run_title = testrun['testSuite']['id']
    else:
        run_title = testrun['title']
    return run_title


def cluster_runs_by_titles(testruns):
    """
    Get test run clusters. Only latest test run on the night for specific test suite or test run name
    must be in cluster
    :param testruns: list of runs for specific version
    :return: run_map
    """
    run_map = {}
    for run in testruns:
        cluster_key = compute_run_title(run)
        if not run_map.get(cluster_key):
            run_map[cluster_key] = run
            continue
        else:
            run_time = int(run['finishedTime']) / 1000
            current_saved_time = int(run_map[cluster_key]['finishedTime']) / 1000
            if run_time > current_saved_time:
                run_map[cluster_key] = run
            continue
    return run_map


def cluster_by_date(testruns):
    """
    Return runs clustered by date
    :param testruns: list of runs for specific version
    :return: run_map: Map<date, [testrun]>
    """
    run_map = {}
    for run in testruns:
        cluster_key = testrun_cluster_key(run)
        if not run_map.get(cluster_key):
            run_map[cluster_key] = run
            continue
        else:
            run_time = int(run['finishedTime']) / 1000
            current_saved_time = int(run_map[cluster_key]['finishedTime']) / 1000
            if run_time > current_saved_time:
                run_map[cluster_key] = run
            continue

    return run_map


def clusterize_by_suite(testruns):
    run_map = {}
    for run in testruns:
        cluster_key = compute_run_title(run)
        if not run_map.get(cluster_key):
            run_map[cluster_key] = [run]
            continue
        else:
            run_map[cluster_key].append(run)
            continue
    return run_map


@retry(stop_max_attempt_number=3, wait_fixed=100)
def assessor_failed_data():
    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    url = 'https://testpalm-api.yandex-team.ru/version/' + parentId
    all_versions = requests.get(url, headers=headers, verify=False).json()
    versions = list()
    assessor_failed = list()

    for single_version in all_versions:
        if is_last_month(single_version['finishedTime']) and is_assessor_version(single_version['title']):
            versions.append(single_version['title'])
        else:
            continue

    for assessor_version in versions:
        url2 = "https://testpalm-api.yandex-team.ru/testrun/%s/?version=%s&include=status,testSuite,resolution,executionTime" % (
        parentId, assessor_version)
        runs = requests.get(url2.encode('utf8'), headers=headers, verify=False).json()
        failed = 0

        for single_run in runs:
            if is_finished(single_run) and 'testSuite' in single_run and 'id' in single_run['testSuite'] \
                    and single_run['testSuite']['id'] in assessor_testplan:
                execution_time = int(single_run['executionTime'])

                if execution_time > 0:
                    failed_tc = int(single_run['resolution']['counter']['failed'])
                    broken_tc = int(single_run['resolution']['counter']['broken'])
                    knownbug_tc = int(single_run['resolution']['counter']['knownbug'])
                    skipped_tc = int(single_run['resolution']['counter']['skipped'])
                    total_tc = int(single_run['resolution']['counter']['total'])

                    if 'failed_tc' in tc_list:
                        failed += failed_tc
                    if 'broken_tc' in tc_list:
                        failed += broken_tc
                    if 'knownbug_tc' in tc_list:
                        failed += knownbug_tc
                    if 'skipped_tc' in tc_list and skipped_tc != total_tc:
                        failed += skipped_tc
                else:
                    continue

        failed = failed * parce_time_case
        if failed > parce_time_max:
            assessor_failed.append(parce_time_max)
        else:
            assessor_failed.append(failed)

    if assessor_failed:
        return {'assessor_failed': int(numpy.mean(assessor_failed))}
    return 0


@retry(stop_max_attempt_number=3, wait_fixed=100)
def manual_data():
    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    url = 'https://testpalm-api.yandex-team.ru/version/' + parentId
    all_versions = requests.get(url, headers=headers, verify=False).json()
    versions = list()
    manual = list()

    for single_version in all_versions:
        if is_last_month(single_version['finishedTime']) \
                and not is_assessor_version(single_version['title']) and 'toloka' not in single_version[
            'title'].lower():
            versions.append(single_version['title'])
        else:
            continue

    for manual_version in versions:
        url2 = "https://testpalm-api.yandex-team.ru/testrun/%s/?version=%s&include=status,testSuite,startedTime,finishedTime,estimate,executionTime" % (
        parentId, manual_version)
        runs = requests.get(url2.encode('utf8'), headers=headers, verify=False).json()

        start_time = list()
        finish_time = list()
        exec_time = 0

        for single_run in runs:
            if is_finished(single_run) and 'testSuite' in single_run and 'id' in single_run['testSuite'] \
                    and single_run['testSuite']['id'] in manual_testplan:
                start = round(single_run['startedTime'] / 1000 / 60)
                fin = round(single_run['finishedTime'] / 1000 / 60)

                stat_estimated = round(single_run['estimate']['avgDuration']) / 1000 / 60
                execution = round(single_run['executionTime']) / 1000 / 60

                if stat_estimated != 0 and execution > 60 and execution > stat_estimated * 3:
                    execution = stat_estimated

                if execution > 0 and fin > 0:
                    exec_time += execution
                    if start > 0 and fin > 0:
                        start_time.append(start)
                        finish_time.append(fin)
                    else:
                        continue
            else:
                continue

        if start_time and finish_time:
            url3 = "https://testpalm-api.yandex-team.ru/version/%s/%s" % (parentId, manual_version)
            version_info = requests.get(url3.encode('utf8'), headers=headers, verify=False).json()
            ver_start = round(version_info['startedTime'] / 1000 / 60)
            ver_fin = round(version_info['finishedTime'] / 1000 / 60)
            duration = ver_fin - ver_start
            runtime = min(duration, exec_time)
            # if runtime >= man_max:
            #     version_run_time = man_max
            # else:
            version_run_time = runtime
        else:
            continue
        manual.append(version_run_time)

    if manual:
        return {'manual': int(numpy.mean(manual))}
    return 0


@retry(stop_max_attempt_number=3, wait_fixed=100)
def assessor_data(parentId):
    queue = '\'' + parentId + '\''

    request = client.query(
        r"""
        SELECT started_ts, finished_ts
        FROM `home/assessor-production/qa/testing/link551/regress/main_2/versions` as T
        WHERE namespace LIKE """ + queue + """ AND finished_ts >= """ + str(dateLimit), syntax_version=1
    )
    request.run()

    request2 = client.query(
        r"""
        SELECT started_ts, finished_ts
        FROM `home/assessor-production/qa/testing/link551/regress/main_2/archived_data/versions` as T
        WHERE namespace LIKE """ + queue + """ AND finished_ts >= """ + str(dateLimit), syntax_version=1
    )
    request2.run()

    assessor_runs = list()
    for table in request.get_results():
        table.fetch_full_data()
        for row in table.rows:
            runs = list()
            for cell in row:
                runs.append(cell)
            assessor_runs.append(runs)

    for table in request2.get_results():
        table.fetch_full_data()
        for row in table.rows:
            runs = list()
            for cell in row:
                runs.append(cell)
            assessor_runs.append(runs)

    assessor_versions = list()
    for run in assessor_runs:
        runtime = (run[1] - run[0]) / 1000 / 60
        assessor_versions.append(runtime)

    if assessor_versions:
        return {'assessor': int(numpy.mean(assessor_versions))}
    return 0


@retry(stop_max_attempt_number=3, wait_fixed=100)
def autotest_data():
    url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    all_versions = requests.get(url, headers=req_headers).json()
    versions = list()
    version_times = list()
    version_research_times = list()

    for single_version in all_versions:
        if is_last_month(single_version['finishedTime']) \
                and use_for_autotests_computing(single_version['title']):
            versions.append(single_version['title'])
        else:
            continue

    for autotest_version in versions:
        url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId + '/overview/' + autotest_version
        req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
        response = requests.get(url, headers=req_headers)
        version_overview = response.json()
        ver_title = version_overview['version']['title']

        autotest_runs = list(filter(lambda r: is_autotest(r), version_overview['testruns']))

        if len(autotest_runs) == 0:
            logging.info('Skip empty version %s' % ver_title)
            continue

        if cluster_by_suite:
            test_run_clusters = clusterize_by_suite(autotest_runs)
            summary_execution_time = 0
            for cluster in test_run_clusters.values():
                cluster_execution_time = 0
                for run in cluster:
                    run_execution_time = run['duration']
                    run_start_time = min(cluster, key=lambda r: r['startedTime'])['startedTime']
                    run_end_time = max(cluster, key=lambda r: r['finishedTime'])['finishedTime']
                    exec_time = min(run_end_time - run_start_time, run_execution_time)
                    cluster_execution_time += exec_time
                cluster_average_time = cluster_execution_time / len(cluster)
                summary_execution_time += cluster_average_time
            version_run_time = summary_execution_time / 1000 / 60  # minutes
        else:
            test_run_clusters = cluster_runs(autotest_runs)
            summary_execution_time = 0
            for cluster in test_run_clusters:
                cluster_execution_time = 0
                for run in cluster:
                    cluster_execution_time += run['duration']
                run_start_time = min(cluster, key=lambda r: r['startedTime'])['startedTime']
                cluster_end_time = max(cluster, key=lambda r: r['finishedTime'])['finishedTime']
                exec_time = min(cluster_end_time - run_start_time, cluster_execution_time)

                summary_execution_time += min(exec_time, cluster_execution_time)
            average_execution_time = summary_execution_time / 1000 / 60 / len(test_run_clusters)
            version_run_time = average_execution_time  # minutes

        if cluster_by_suite:
            test_run_clusters = clusterize_by_suite(autotest_runs)
            fails = 0
            for cluster in test_run_clusters.values():
                cluster_fail = 0
                for run in cluster:
                    counters = run['resolution']['counter']
                    failed_cases = counters['failed'] + counters['broken'] + counters['knownbug']
                    if failed_cases <= counters['total'] / 2:
                        cluster_fail += failed_cases
                fails += (cluster_fail / len(cluster))
            fails_research_time = min(fails * research_multiplier, fails_research_limit)
        else:
            all_run_map = cluster_by_date(autotest_runs)
            cluster_fails = {}
            for run in all_run_map.values():
                counters = run['resolution']['counter']
                failed_cases = counters['failed'] + counters['broken'] + counters['knownbug']
                if failed_cases <= counters['total'] / 2:
                    date = cluster_date(run)
                    if cluster_fails.get(date) is None:
                        cluster_fails[date] = failed_cases
                    else:
                        cluster_fails[date] += failed_cases
            if len(cluster_fails.values()) != 0:
                fails_research_time = min(numpy.mean(list(cluster_fails.values())) * research_multiplier,
                                          fails_research_limit)
            else:
                fails_research_time = 0.0

        if version_run_time == 0:
            logging.info('Skip empty version %s' % ver_title)
            continue
        else:
            # logging.info('Computed autotest time for %s: %s ' % (ver_title, str(version_run_time)))
            version_times.append(version_run_time)
            version_research_times.append(fails_research_time)

    if version_times and version_research_times:
        return {'autotest': int(numpy.mean(version_times)), 'autotest_failed': int(numpy.mean(version_research_times))}
    return 0


all_queues = yaconfig['parentId']
for queue_data in all_queues:
    for parentId in queue_data:
        print('--------------------------------------')
        print(str(datetime.now()) + ' Run script for queue: ' + parentId)

        queue_params = queue_data[parentId]

        all_suites = get_suites(parentId)
        manual_testplan = all_suites[0]
        assessor_testplan = all_suites[1]

        tc_list = queue_params['tc_list']
        parce_time_case = queue_params['parce_time_case']
        parce_time_max = queue_params['parce_time_max']
        fails_research_limit = queue_params['fails_research_limit']
        independentAutotestVersion = queue_params['independentAutotestVersion']
        cluster_by_suite = queue_params['clusterBySuite']
        research_multiplier = queue_params.get('researchMultiplier', 5)

        manual = manual_data()
        assessor_failed = assessor_failed_data()
        assessor = assessor_data(parentId)
        # autotest = autotest_data()

        prepare_data = {
            'queue': parentId,
            'fielddate': reportDate
        }
        if manual:
            prepare_data.update(manual)
        if assessor_failed:
            prepare_data.update(assessor_failed)
        if assessor:
            prepare_data.update(assessor)
        # if autotest:
        #     prepare_data.update(autotest)

        data = [prepare_data]

        print(str(datetime.now()) + ' Final data is ready to be send')
        logging.info(' Data is ready %s' % data)

        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
            data={
                'name': 'Mail/Others/regression',
                'scale': 'm',
                'data': json.dumps({'values': data})
            }
        )
        logging.info(' Stat response: %s' % r.text)
