# -*- coding: utf-8 -*-
import json
import logging
import os
import time
from datetime import timedelta, date

import numpy
import requests
import urllib3
import yaml
from retrying import retry
from yql.api.v1.client import YqlClient

from SuitesByTag import get_suites

# Отдельный скрипт для диска фронта (diskfront, diskclient, diskpublic)
# Склеиваем 3 очереди в одну
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/RegressionStatGraph')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
client = YqlClient(db='hahn', token=yaconfig['YQL_TOKEN'])
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)

# получаем дату: 1 число текущего месяца и переводим ее в миллисекунды
month = date.today() - timedelta(days=(date.today().day - 1))
dateLimit = int(time.mktime(month.timetuple())) * 1000
# dateLimit = int(time.mktime(month.replace(month=5, day=1, year=2020).timetuple())) * 1000
# dateFinish = int(time.mktime(month.replace(month=6, day=1, year=2020).timetuple())) * 1000
reportDate = str(date.fromtimestamp(dateLimit / 1000))
robots = yaconfig['robots']
data = list()


def is_assessor_version(version):
    if 'asses' in version.lower() or 'ases' in version.lower() or 'acces' in version.lower() \
            or 'асес'.decode('utf-8') in version.lower():
        return True


def is_monitoring_version(version):
    if 'мониторинг'.decode('utf-8') in version.lower() or 'monitoring' in version.lower() \
            or 'регулярный'.decode('utf-8') in version.lower():
        return True


def is_last_month(finished_date):
    if finished_date >= dateLimit:
        return True
    return False


def is_not_empty(testruns):
    if not testruns:
        return False
    return True


def is_finished(single_run):
    if single_run['status'] == 'FINISHED':
        return True
    return False


@retry(stop_max_attempt_number=3, wait_fixed=100)
def assessor_failed_data(queue_name, index):
    queue_params = yaconfig['parentId'][index][queue_name]
    tc_list = queue_params['tc_list']
    parce_time_case = queue_params['parce_time_case']
    parce_time_max = queue_params['parce_time_max']

    all_suites = get_suites(queue_name)
    assessor_testplan = all_suites[1]

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    url = 'https://testpalm-api.yandex-team.ru/version/' + queue_name
    all_versions = requests.get(url, headers=headers, verify=False).json()
    versions = list()
    assessor_failed = list()

    for single_version in all_versions:
        if is_last_month(single_version['finishedTime']) \
                and is_assessor_version(single_version['title']):
            versions.append(single_version['title'])
        else:
            continue

    for assessor_version in versions:
        url2 = "https://testpalm-api.yandex-team.ru/testrun/%s/?version=%s&include=status,testSuite,resolution,executionTime" % (
            queue_name, assessor_version)
        runs = requests.get(url2.encode('utf8'), headers=headers, verify=False).json()
        failed = 0

        for single_run in runs:
            if is_finished(single_run) and 'testSuite' in single_run and 'id' in single_run['testSuite'] \
                    and single_run['testSuite']['id'] in assessor_testplan:
                execution_time = int(single_run['executionTime'])

                if execution_time > 0:
                    failed_tc = int(single_run['resolution']['counter']['failed'])
                    broken_tc = int(single_run['resolution']['counter']['broken'])
                    knownbug_tc = int(single_run['resolution']['counter']['knownbug'])
                    skipped_tc = int(single_run['resolution']['counter']['skipped'])
                    total_tc = int(single_run['resolution']['counter']['total'])

                    if 'failed_tc' in tc_list:
                        failed += failed_tc
                    if 'broken_tc' in tc_list:
                        failed += broken_tc
                    if 'knownbug_tc' in tc_list:
                        failed += knownbug_tc
                    if 'skipped_tc' in tc_list and skipped_tc != total_tc:
                        failed += skipped_tc
                else:
                    continue

        failed = failed * parce_time_case
        if failed > parce_time_max:
            assessor_failed.append(parce_time_max)
        else:
            assessor_failed.append(failed)

    if assessor_failed:
        return int(numpy.mean(assessor_failed))
    return 0


@retry(stop_max_attempt_number=3, wait_fixed=100)
def manual_data(queue_name):
    all_suites = get_suites(queue_name)
    manual_testplan = all_suites[0]

    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    url = 'https://testpalm-api.yandex-team.ru/version/' + queue_name
    all_versions = requests.get(url, headers=headers, verify=False).json()
    versions = list()
    manual = list()

    for single_version in all_versions:
        if is_last_month(single_version['finishedTime']) \
                and not is_assessor_version(single_version['title']) \
                and 'toloka' not in single_version['title'].lower():
            versions.append(single_version['title'])
        else:
            continue

    for manual_version in versions:
        url2 = "https://testpalm-api.yandex-team.ru/testrun/%s/?version=%s&include=status,testSuite,startedTime,finishedTime,estimate,executionTime" % (
            queue_name, manual_version)
        runs = requests.get(url2.encode('utf8'), headers=headers, verify=False).json()
        start_time = list()
        finish_time = list()
        exec_time = 0

        for single_run in runs:
            if is_finished(single_run) and 'testSuite' in single_run and 'id' in single_run['testSuite'] \
                    and single_run['testSuite']['id'] in manual_testplan:
                start = round(single_run['startedTime'] / 1000 / 60)
                fin = round(single_run['finishedTime'] / 1000 / 60)

                stat_estimated = round(single_run['estimate']['avgDuration']) / 1000 / 60
                execution = round(single_run['executionTime']) / 1000 / 60

                if stat_estimated != 0 and execution > 60 and execution > stat_estimated * 3:
                    execution = stat_estimated

                if execution > 0 and fin > 0:
                    exec_time += execution
                    if start > 0 and fin > 0:
                        start_time.append(start)
                        finish_time.append(fin)
                    else:
                        continue
            else:
                continue

        if start_time and finish_time:
            url3 = "https://testpalm-api.yandex-team.ru/version/%s/%s" % (queue_name, manual_version)
            version_info = requests.get(url3.encode('utf8'), headers=headers, verify=False).json()
            ver_start = round(version_info['startedTime'] / 1000 / 60)
            ver_fin = round(version_info['finishedTime'] / 1000 / 60)
            duration = ver_fin - ver_start
            version_run_time = min(duration, exec_time)
        else:
            continue

        manual.append(version_run_time)

    if manual:
        return int(numpy.mean(manual))
    return 0


@retry(stop_max_attempt_number=3, wait_fixed=100)
def assessor_data(queue_name):
    queue = '\'' + queue_name + '\''

    request = client.query(
        r"""
        SELECT started_ts, finished_ts
        FROM `home/assessor-production/qa/testing/link551/regress/main_2/versions` as T
        WHERE (status LIKE "%REPORT_BUILDING%" OR status LIKE "%FINISHED%") AND namespace LIKE """ + queue + """ AND finished_ts >= """ + str(
            dateLimit), syntax_version=1
    )
    request.run()

    request2 = client.query(
        r"""
        SELECT started_ts, finished_ts
        FROM `home/assessor-production/qa/testing/link551/regress/main_2/archived_data/versions` as T
        WHERE (status LIKE "%REPORT_BUILDING%" OR status LIKE "%FINISHED%") AND namespace LIKE """ + queue + """ AND finished_ts >= """ + str(
            dateLimit), syntax_version=1
    )
    request2.run()

    assessor_runs = list()
    for table in request.get_results():
        table.fetch_full_data()
        for row in table.rows:
            runs = list()
            for cell in row:
                runs.append(cell)
            assessor_runs.append(runs)

    for table in request2.get_results():
        table.fetch_full_data()
        for row in table.rows:
            runs = list()
            for cell in row:
                runs.append(cell)
            assessor_runs.append(runs)

    assessor_versions = list()
    for run in assessor_runs:
        runtime = (run[1] - run[0]) / 1000 / 60
        assessor_versions.append(runtime)

    if assessor_versions:
        return int(numpy.mean(assessor_versions))
    return 0


diskfront = {'diskfront': 3, 'diskclient': 4, 'diskpublic': 5}
manual = list()
assessor = list()
assessor_failed = list()
for queue_name in diskfront:
    single_manual = manual_data(queue_name)
    if single_manual != 0:
        manual.append(single_manual)

    single_ass = assessor_data(queue_name)
    if single_ass != 0:
        assessor.append(single_ass)

    single_ass_failed = assessor_failed_data(queue_name, diskfront[queue_name])
    if single_ass_failed != 0:
        assessor_failed.append(single_ass_failed)

prepare_data = {
    'queue': 'diskfront',
    'fielddate': reportDate
}

if manual:
    final_manual = numpy.mean(manual)
else:
    final_manual = 0
if assessor:
    final_ass = numpy.mean(assessor)
else:
    final_ass = 0
if assessor_failed:
    final_failed = numpy.mean(assessor_failed)
else:
    final_failed = 0

prepare_data.update({'manual': final_manual, 'assessor': final_ass, 'assessor_failed': final_failed})
data.append(prepare_data)

logging.info('Data is ready: %s' % data)
r = requests.post(
    'https://upload.stat.yandex-team.ru/_api/report/data',
    headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
    data={
        'name': 'Mail/Others/regression',
        'scale': 'm',
        'data': json.dumps({'values': data})
    }
)
logging.info(' Stat response: %s' % r.text)
