# -*- coding: utf-8 -*-
import json
import logging
import os
import time
from datetime import timedelta, date, datetime

import requests
import urllib3
import yaml
from retrying import retry

from SuitesByTag import get_suites

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
month = date.today() - timedelta(days=(date.today().day - 1))
dateLimit = int(time.mktime(month.timetuple())) * 1000


# dateLimit = int(time.mktime(month.replace(month=12, day=1, year=2019).timetuple())) * 1000
# dateFinish = int(time.mktime(month.replace(month=1, day=1, year=2020).timetuple())) * 1000


def is_assessor_version(version):
    if 'asses' in version.lower() or 'ases' in version.lower() or 'acces' in version.lower() \
            or 'асес'.decode('utf-8') in version.lower():
        return True


def is_autotest(testrun):
    return testrun['launcherInfo']['external'] == "True"


def is_last_month(finished_date):
    if finished_date >= dateLimit:
        return True
    return False


def is_not_empty(testruns):
    if not testruns:
        return False
    return True


def is_finished(single_run):
    if single_run['status'] == 'FINISHED':
        return True
    return False


def send_to_stat(data):
    logging.info(' Data is ready %s' % data)

    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
        data={
            'name': 'Mail/Others/ManualDetailed',
            'scale': 'd',
            'data': json.dumps({'values': data})
        }
    )
    logging.info(' Stat response: %s' % r.text)


def get_parent_id(parent_id, version):
    if parent_id == 'diskdesktop' or parent_id == 'disc3':
        if 'Mac' in version[2]:
            return 'disk_mac'
        if 'Win' or 'WIn' in version[2] or 'Notes' in version[2]:
            return 'disk_win'
    if parent_id == 'diskclient' or parent_id == 'diskpublic':
        return 'diskfront'
    else:
        return parent_id


@retry(stop_max_attempt_number=3, wait_fixed=100)
def manual_data(parentId):
    headers = {'Authorization': 'OAuth %s' % yaconfig["TP_TOKEN"]}
    url = 'https://testpalm-api.yandex-team.ru/version/' + parentId
    all_versions = requests.get(url, headers=headers, verify=False).json()
    versions = list()
    manual = list()

    for single_version in all_versions:
        if is_last_month(single_version['finishedTime']) \
                and not is_assessor_version(single_version['title']) and 'toloka' not in single_version[
            'title'].lower():
            versions.append(single_version['title'])
        else:
            continue

    for manual_version in versions:
        url2 = "https://testpalm-api.yandex-team.ru/testrun/%s/?version=%s&include=status,testSuite,startedTime,finishedTime,estimate,executionTime" % (
            parentId, manual_version)
        runs = requests.get(url2.encode('utf8'), headers=headers, verify=False).json()
        start_time = list()
        finish_time = list()
        version = dict()
        exec_time = 0

        for single_run in runs:
            if is_finished(single_run) and 'testSuite' in single_run and 'id' in single_run['testSuite'] \
                    and single_run['testSuite']['id'] in manual_testplan:
                start = round(single_run['startedTime'] / 1000 / 60)
                fin = round(single_run['finishedTime'] / 1000 / 60)
                execution = round(single_run['executionTime']) / 1000 / 60

                if execution > 0 and fin > 0:
                    exec_time += execution
                    if start > 0 and fin > 0:
                        start_time.append(start)
                        finish_time.append(fin)
                    else:
                        continue
            else:
                continue

        if start_time and finish_time:
            url3 = "https://testpalm-api.yandex-team.ru/version/%s/%s" % (parentId, manual_version)
            version_info = requests.get(url3.encode('utf8'), headers=headers, verify=False).json()
            ver_start = round(version_info['startedTime'] / 1000 / 60)
            ver_fin = round(version_info['finishedTime'] / 1000 / 60)
            time_from_json = int(version_info['finishedTime']) / 1000
            reportDate = str(date.fromtimestamp(time_from_json))

            duration = ver_fin - ver_start
            version_run_time = min(duration, exec_time)
            ver_title = runs['version']['title']
        else:
            continue

        version[ver_title] = version_run_time
        version = [reportDate, version_run_time, ver_title]
        manual.append(version)

    for version in manual:
        queue = get_parent_id(parentId, version)
        data = [
            {'queue': queue,
             'fielddate': version[0],
             'duration': version[1],
             'version': version[2]}
        ]
        send_to_stat(data)


all_queues = yaconfig['parentId']
for queue_data in all_queues:
    for parentId in queue_data:
        print('--------------------------------------')
        print(str(datetime.now()) + ' Run script for queue: ' + parentId)
        queue_params = queue_data[parentId]
        all_suites = get_suites(parentId)
        manual_testplan = all_suites[0]
        manual_data(parentId)
