# -*- coding: utf-8 -*-
import logging
import os
import time

import numpy
import requests
import urllib3
import yaml
from yql.api.v1.client import YqlClient
from datetime import datetime, timedelta, date
from retrying import retry

scriptPath = os.path.dirname(os.path.abspath(__file__) + '/RegressionStatGraph')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))


@retry(stop_max_attempt_number=3, wait_fixed=100)
def get_suites(parentId):
    url = 'https://testpalm.yandex-team.ru/api/testsuite/' + parentId
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    all_suites = requests.get(url, headers=req_headers).json()

    manual_tag = 'ManualReg'
    ass_tag = 'AssessorReg'

    manual_suites = list()
    assessor_suites = list()

    for suite in all_suites:
        if 'tags' in suite and suite['tags']:
            tags = suite['tags']
            if manual_tag in tags:
                manual_suites.append(suite['id'])
            if ass_tag in tags:
                assessor_suites.append(suite['id'])
        else:
            continue

    return manual_suites, assessor_suites
