# -*- coding: utf-8 -*-
import os
import datetime
from collections import defaultdict
import requests
import json

import numpy
from yql.api.v1.client import YqlClient
import yaml

scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
client = YqlClient(db='hahn', token=yaconfig['YQL_TOKEN'])

request = client.query(r"""
    SELECT namespace, version, started_ts, finished_ts
    FROM [//home/assessor-production/qa/link551/production/version_statuses/finished] as T
    WHERE namespace LIKE "%mail%" AND started_ts >= 1551398400000
    OR namespace LIKE "cal" AND started_ts >= 1551398400000
    OR namespace LIKE "'diskdv" AND started_ts >= 1551398400000
    OR namespace LIKE "adisk" AND started_ts >= 1551398400000
    OR namespace LIKE "idisk" AND started_ts >= 1551398400000
    OR namespace LIKE "diskfront" AND started_ts >= 1551398400000
    OR namespace LIKE "diskclient" AND started_ts >= 1551398400000
    OR namespace LIKE "%passport%" AND started_ts >= 1551398400000
    OR namespace LIKE "am-ios" AND started_ts >= 1551398400000
    OR namespace LIKE "am-android" AND started_ts >= 1551398400000
    """)

# request = client.query(r"""
#     SELECT namespace, version, started_ts, finished_ts
#     FROM [//home/assessor-production/qa/link551/production/version_statuses/finished] as T
#     WHERE namespace LIKE "%diskdesktop%" AND started_ts >= 1546290000000
#     OR namespace LIKE "'disc3" AND started_ts >= 1546290000000
#     """)

request.run()

assessor_runs = list()
for table in request.get_results():
    table.fetch_full_data()
    for row in table.rows:
        runs = list()
        for cell in row:
            runs.append(cell)
        assessor_runs.append(runs)

version_list_old = [
    'v16_2 Асессоры',
    'Секреты 1 регресс Асессоры',
    'Скорость mini Асессоры',
    'Тех релиз 16_0 Асессоры',
    'Тех релиз 16_1 Асессоры',
    'вложения регресс Асессоры',
    'метрика Асессоры',
    'секреты регресс Асессоры',
    'maya 1.47 asessors',
    'AssessorsiOS3760part6_regress_ML1_DarkTheme',
    'AssessorsiOS3760part7_regress_ML2_LightTheme',
    'AssessorsiOS3770part2_blBig',
    'AssessorsiOS3770part3_blBig',
    'AssessorsiOS3770part4_xmail',
    'AssessorsiOS3770part6_ShareExtention',
    'AssessorsiOS3770part7_ShareExtention',
    'AssessorsiOS3770part8_regress_Push',
    'AssessorsiOS3780part2_business_logic',
    'AssessorsiOS3780part4_compose_regress',
    'AssessorsiOS3780part5_notify_search_settings_regress',
    'AssessorsiOS3780partML_regress_Search',
    'AssessorsiOS3780part_2_regress_MLpart1',
    'AssessorsiOS3780partregress_MLpart1',
    'AssessorsiOS3780partregress_MLpart2',
    'AssessorsAndroid4130partpart10bl1',
    'AssessorsAndroid4130partpart11regress1',
    'AssessorsAndroid4130partpart6full_regress_part1',
    'AssessorsAndroid4130partpart7full_regress_part2',
    'AssessorsAndroid4130partpart9bl2',
    'AssessorsAndroid4140partbl1',
    'AssessorsAndroid4140partregress_am1',
    'AssessorsAndroid4141partbl2',
    'AssessorsAndroid4141partbl3',
    'AssessorsAndroid4141partregress1',
    'AssessorsAndroid4141partregress3',
    'AssessorsAndroid4150partpart2reactprerelease',
    'AssessorsAndroid4150partpart3bl1',
    'AssessorsAndroid4151partpart4bl2',
    'AssessorsAndroid4160partprerelise_am',
    'AssessorsAndroid4160partprerelise_bl1',
    'Public_TR11_desktop_assessors_Chrome',
    'Public_TR11_desktop_assessors_FF_Zhenya',
    'Public_TR11_desktop_assessors_IEandEDGE',
    'Public_TR11_desktop_assessors_Safari',
    'Public_TR11_touch_assessors_Android4x4',
    'Public_TR11_touch_assessors_Android5_8',
    'Public_TR11_touch_assessors_Safari',
    '3.78_7_TP_public_promo_ACCESSORS',
    '3.78_7_TechRelease_BL_ACCESSORS',
    '3.78_7_TechRelease_RG_ACCESSORS',
    '3.83_LG_Without_experiment_ACCESSORS',
    '0.2.103 Asessors',
    '5.0.0 Asessors',
    '5.0.1 Asessors',
    'Mac_3_0_9_As',
    'Win_3_0_9',
    'mobx_OF_actual Асессоры',
    'Техрелиз 5_16 Асессоры',
    'AM iOS Release 5.0.0 Smoke',
    'Android AM Release 7.0.1',
    'Public_TR11_desktop_NKandZhenya',
    'Public_TR11_desktop_assessors_Chrome',
    'Public_TR11_desktop_assessors_FF_Zhenya',
    'Public_TR11_desktop_assessors_IEandEDGE',
    'Public_TR11_desktop_assessors_Safari',
    'Public_TR11_touch_assessors_Android4x4',
    'Public_TR11_touch_assessors_Android5_8',
    'Public_TR11_touch_assessors_Safari',
    'smoke_28tech_desktop_and_touch',
    '16 7 регресс Асессоры',
    'Залипание кнопок Написать и Обновить Асессоры',
    'Реклама 14 регресс Асессоры',
    'Тех релиз 16_6 Асессоры',
    'отрыв домика Асессоры',
    'секреты 2 Асессоры',
    'maya 1.50.5 asessors',
    'maya 1.50.5 corp asessors',
    'maya 1.51 assesors',
    'maya 1.51 corp asessors',
    'web_rc_29_desktop_assessor_2',
    'web_rc_remember_block_desktop_assessor',
    '4.09_Dorabotki_BL_2_ACCESSORS',
    '4.10_editor_BL_Disk_ACCESSORS',
    '0.2.106_Asessors Asessors',
    '0.2.107 Asessors',
    '7.2.0 Asessors',
    '2.70_Tech9_BL_inHouse_ACCESSORS',
    'AssessorsiOS3790partregress_ML2_iteration2',
    'AssessorsiOS3800part1_blBig1',
    'AssessorsiOS3800partregress_ML2_iteration3',
    'AssessorsiOS3810partpre_release',
    'AssessorsAndroid4171part2bl1',
    'AssessorsAndroid4171part3regress',
    'AssessorsAndroid4171part4regress'
]

version_list = [
    '16 7 регресс Асессоры',
    'Залипание кнопок Написать и Обновить Асессоры',
    'Реклама 14 регресс Асессоры',
    'Тех релиз 16_6 Асессоры',
    'отрыв домика Асессоры',
    'секреты 2 Асессоры',
    'maya 1.50.5 asessors',
    'maya 1.50.5 corp asessors',
    'maya 1.51 assesors',
    'maya 1.51 corp asessors',
    'web_rc_29_desktop_assessor_2',
    'web_rc_remember_block_desktop_assessor',
    '4.09_Dorabotki_BL_2_ACCESSORS',
    '4.10_editor_BL_Disk_ACCESSORS',
    '0.2.106_Asessors Asessors',
    '0.2.107 Asessors',
    '7.2.0 Asessors',
    '2.70_Tech9_BL_inHouse_ACCESSORS',
    'AssessorsiOS3790partregress_ML2_iteration2',
    'AssessorsiOS3800part1_blBig1',
    'AssessorsiOS3800partregress_ML2_iteration3',
    'AssessorsiOS3810partpre_release',
    'AssessorsAndroid4171part2bl1',
    'AssessorsAndroid4171part3regress',
    'AssessorsAndroid4171part4regress',
    '0.2.106_Asessors Asessors',
    '0.2.107 Asessors',
    '7.2.0 Asessors'
]

assessor_versions = {
    'mail-touch': [], 'mail-liza': [], 'cal': [], 'diskdv': [], 'adisk': [], 'idisk': [], 'diskfront': [],
    'am-android': [], 'am-ios': [], 'passport': [], 'mobmail_android': [], 'mobmail_ios': []
}

# assessor_versions = {
#     'disk_mac': []
# }

for version in assessor_runs:
    queue = version[0]
    if queue == 'disc3':
        queue = 'diskdesktop'
    if queue == 'diskclient':
        queue = 'diskfront'

    version_name = version[1].replace('%20', ' ').encode('utf-8')
    # run = [version[2], version[3]]
    # assessor_versions[queue].append(run)

    # Фильтр по названию версии
    if version_name in version_list:
        run = [version[2], version[3]]
        assessor_versions[queue].append(run)
    else:
        continue

assessor_data = dict()
for queue in assessor_versions:
    versions = assessor_versions[queue]
    runs_month = defaultdict(list)
    for i in range(len(versions)):
        single_run = versions[i]
        time_from_json = single_run[0] / 1000
        date = datetime.date.fromtimestamp(time_from_json)
        month = str(date - datetime.timedelta(days=(date.day - 1)))
        duration = int(single_run[1] - single_run[0]) / 1000 / 60
        if month in runs_month:
            runs_month[month].append(duration)
        else:
            runs_month[month] = [duration]

    #print(runs_month)
    runs_average = dict()
    for month in runs_month:
        runs_average[month] = int(numpy.mean(runs_month[month]))

    if queue in assessor_data:
        assessor_data[queue].update(runs_average)
    else:
        assessor_data[queue] = runs_average

for queue in assessor_data:
    dates = assessor_data[queue]
    data = [
        {
            'fielddate': date,
            'queue': queue,
            'assessor': dates[date],
        }
        for date in dates
    ]

    print(data)

# r = requests.post(
#     'https://upload.stat.yandex-team.ru/_api/report/data',
#     headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
#     data={
#         'name': 'Mail/Others/regression',
#         'scale': 'm',
#         'data': json.dumps({'values': data})
#     }
# )
# print(' Stat response: %s' % r.text)
