# -*- coding: utf-8 -*-
import os
from collections import defaultdict
import requests
import json
import time
import logging

from yql.api.v1.client import YqlClient
from datetime import timedelta, date
import yaml

scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
client = YqlClient(db='hahn', token=yaconfig['YQL_TOKEN'])
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
month = date.today() - timedelta(days=(date.today().day - 1))
dateLimit = int(time.mktime(month.timetuple())) * 1000


def is_assessor_version(version):
    if 'мониторинг' in version.lower() or 'monitor' in version.lower() or 'feature' in version.lower() \
            or 'регулярный' in version.lower():
        return False
    return True


request = client.query(r"""
    SELECT namespace, version, started_ts, finished_ts
    FROM [//home/assessor-production/qa/link551/production/version_statuses/finished] as T
    WHERE namespace LIKE "%mail%" AND started_ts >= 1551398400000
    OR namespace LIKE "cal" AND started_ts >= 1551398400000
    OR namespace LIKE "'diskdv" AND started_ts >= 1551398400000
    OR namespace LIKE "adisk" AND started_ts >= 1551398400000
    OR namespace LIKE "idisk" AND started_ts >= 1551398400000
    OR namespace LIKE "diskfront" AND started_ts >= 1551398400000
    OR namespace LIKE "diskclient" AND started_ts >= 1551398400000
    OR namespace LIKE "%passport%" AND started_ts >= 1551398400000
    OR namespace LIKE "am-ios" AND started_ts >= 1551398400000
    OR namespace LIKE "am-android" AND started_ts >= 1551398400000
    """)

request.run()

# Собираем из таблицы список ранов в формате [очередь, версия, начало, конец]
assessor_runs = list()
for table in request.get_results():
    table.fetch_full_data()
    for row in table.rows:
        runs = list()
        for cell in row:
            runs.append(cell)
        assessor_runs.append(runs)

assessor_versions = {
    'mail-touch': [], 'mail-liza': [], 'cal': [],
    'diskdv': [], 'adisk': [], 'idisk': [], 'diskfront': [], 'diskdesktop': [],
    'am-android': [], 'am-ios': [],
    'passport': [],
    'mobmail_android': [], 'mobmail_ios': []
}

# Для каждой очереди формируем словарь: {очередь: [версия, начало, конец]}
for i in range(len(assessor_runs)):
    version = assessor_runs[i]
    queue = version[0]
    if queue == 'passport-asessors':
        queue = 'passport'
    if queue == 'disc3':
        queue = 'diskdesktop'
    if queue == 'diskclient':
        queue = 'diskfront'

    version_name = version[1].replace('%20', ' ').encode('utf-8')

    if queue == 'diskdesktop':
        if 'Mac' in version_name:
            queue = 'disk_mac'
        if 'Win' in version_name or 'Notes' in version_name:
            queue = 'disk_win'

    # Фильтр по названию версии
    if is_assessor_version(version_name):
        run = [version_name, version[2], version[3]]
        assessor_versions[queue].append(run)
    else:
        continue

# Расчитываем длительность каждой версии и делим их по месяцам
assessor_data = dict()
for queue in assessor_versions:
    versions = assessor_versions[queue]
    runs_month = defaultdict(list)
    for i in range(len(versions)):
        single_ver = versions[i]
        reportDate = str(date.fromtimestamp(single_ver[1] / 1000))
        duration = int(single_ver[2] - single_ver[1]) / 1000 / 60
        version_name = single_ver[0]
        version_stat = [reportDate, duration, version_name]

        if queue in assessor_data:
            assessor_data[queue].append(version_stat)
        else:
            assessor_data[queue] = [version_stat]

for queue in assessor_data:
    versions = assessor_data[queue]
    for single_version in range(len(versions)):
        version = versions[single_version]
        data = [
            {
                'fielddate': version[0],
                'queue': queue,
                'duration': version[1],
                'version': version[2]
            }
        ]
        print(data)
        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
            data={
                'name': 'Mail/Others/assessorversions',
                'scale': 'd',
                'data': json.dumps({'values': data})
            }
        )
        logging.info(' Stat response: %s' % r.text)
