# -*- coding: utf-8 -*-
import os
import logging

import urllib3
import yaml
import requests
import datetime
import json
import time

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))

# Project
parentId = yaconfig['parentId']


def is_assessor_version(version):
    if 'асессор' in version.lower() or 'asessors' in version.lower():
        if 'регулярный регресс' in version.lower():
            return False
        return True


# from 01.08.2018
def is_last_quarter(created_date):
    if created_date >= 1533070800000:
        return True
    return False


url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId
req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
response = requests.get(url, headers=req_headers)
all_versions = response.json()
versions = []

for i in all_versions:
    if is_assessor_version(i['title']) and is_last_quarter(i['finishedTime']):
        logging.info(' found assessor version: %s' % i['title'])
        versions.append(i['title'])

for i in versions:
    url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId + '/overview/' + i
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    response = requests.get(url, headers=req_headers)
    runs = response.json()

    for single_run in runs['testruns']:
        time_from_json = int(single_run['finishedTime']) / 1000
        finished_time = str(datetime.date.fromtimestamp(time_from_json))

        exec_time = round(single_run['executionTime']/1000/60)

        # Среднее время разбора бага от асессора: 20 минут
        count_fails = single_run['resolution']['counter']['failed']
        time_to_fails = round(int(count_fails*20))

        testrun = dict()
        testrun['fielddate'] = finished_time
        testrun['queue'] = parentId
        testrun['title'] = single_run['title']
        testrun['version'] = runs['version']['title']
        testrun['type_of_run'] = 'Assessor'
        testrun['run_id'] = single_run['id']
        testrun['exec_time'] = exec_time
        testrun['count_fails'] = count_fails
        testrun['time_to_fails'] = time_to_fails

        logging.info(' testrun ready to load: %s' % testrun)

        data = [
            testrun
        ]

        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
            data={
                'name': 'Mail/Others/RegressionMonth',
                'scale': 'm',
                'data': json.dumps({'values': data})
            }
        )
        logging.info(' Stat response: %s' % r.text)

