# -*- coding: utf-8 -*-
import os
import logging

import urllib3
import yaml
import requests
from datetime import datetime, timedelta, date
import json

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))

# Project
parentId = list(yaconfig['parentId'][0].keys())[0]  # get only key name


def is_not_assessor_version(version):
    if 'асессор' in version.lower() or 'asessors' in version.lower()\
            or 'регулярный регресс' in version.lower():
        return False
    return True


# from 01.08.2018
def is_last_quarter(created_date):
    if created_date >= 1533070800000:
        return True
    return False

# Не смотрим пустые версии без ранов (созданные по ошибке)
def is_not_empty(testruns):
    if not testruns:
        return False
    return True


# Создаем ключ вида <имя рана> - <год-месяц-день (00|12):00:00> что бы отличать раны разбираемые до обеда и после
def testrun_cluster_key(testrun):
    run_title = testrun['title']
    started_time = datetime.fromtimestamp(int(testrun['finishedTime']) / 1000)
    cluster_time = started_time - timedelta(hours=started_time.time().hour % 12)

    return run_title + ' - ' + cluster_time.strftime('%Y-%m-%d %H:00:00')


url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId
req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
response = requests.get(url, headers=req_headers)
all_versions = response.json()
versions = []

# Игнорируем служебные раны: Ответственному за релиз и Инструкция к новой фиче
ignored_suites = ['562e38c5e4b0ef8ed6d11333', '5b6bff692afa3ab633dfd994']

for i in all_versions:
    if is_not_assessor_version(i['title']) and is_last_quarter(i['finishedTime']) and is_not_empty(i['suites']):
        logging.info(' found manual version: %s' % i['title'])
        versions.append(i['title'])

for i in versions:
    url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId + '/overview/' + i
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    response = requests.get(url, headers=req_headers)
    runs = response.json()
    runMap = {}

    for single_run in runs['testruns']:
        if single_run['launcherInfo'] and not single_run['launcherInfo']['external']:
            # logging.info("Skip internal run {}".format(single_run['title']))
            continue
        cluster_key = testrun_cluster_key(single_run)

        if not runMap.get(cluster_key):
            runMap[cluster_key] = single_run
            continue
        else:
            time_from_json = int(single_run['finishedTime']) / 1000
            current_time = int(runMap[cluster_key]['finishedTime']) / 1000
            if time_from_json > current_time:
                runMap[cluster_key] = single_run
            continue

    for single_run in runMap.values():
        time_from_json = int(single_run['finishedTime']) / 1000
        finished_time = str(date.fromtimestamp(time_from_json))

        exec_time = round(single_run['executionTime'] / 1000 / 60)

        # Среднее время разбора бага автотестов: 5 минут
        count_fails = single_run['resolution']['counter']['failed'] + single_run['resolution']['counter']['broken']
        time_to_fails = round(int(count_fails * 5))

        testrun = dict()
        testrun['fielddate'] = finished_time
        testrun['queue'] = parentId
        testrun['title'] = single_run['title']
        testrun['version'] = runs['version']['title']
        testrun['type_of_run'] = 'Автотесты'
        testrun['run_id'] = single_run['id']
        testrun['exec_time'] = exec_time
        testrun['count_fails'] = count_fails
        testrun['time_to_fails'] = time_to_fails

        logging.info(' testrun ready to load: %s' % testrun)

        data = [
            testrun
        ]

        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
            data={
                'name': '/Mail/Others/RegressStatistics',
                'scale': 'd',
                'data': json.dumps({'values': data})
            }
        )
        logging.info(' Stat response: %s' % r.text)

