# -*- coding: utf-8 -*-
import os
import datetime
from collections import defaultdict
import requests
import json

import numpy
from yql.api.v1.client import YqlClient
import yaml

scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
client = YqlClient(db='hahn', token=yaconfig['YQL_TOKEN'])

request = client.query(r"""
    SELECT namespace, version, started_ts, finished_ts
    FROM [//home/assessor-production/qa/link551/production/version_statuses/finished] as T
    WHERE namespace LIKE "diskdesktop" AND started_ts >= 1551398400000
    OR namespace LIKE "disc3" AND started_ts >= 1551398400000
    """)

request.run()

assessor_runs = list()
for table in request.get_results():
    table.fetch_full_data()
    for row in table.rows:
        runs = list()
        for cell in row:
            runs.append(cell)
        assessor_runs.append(runs)

assessor_versions = {'disk_mac': [], 'disk_win': [], 'skipped': []}

for version in assessor_runs:
    queue = 'skipped'
    version_name = version[1].replace('%20', ' ').encode('utf-8')
    if 'Mac' in version_name:
        queue = 'disk_mac'
    if 'Win' in version_name:
        queue = 'disk_win'


    run = [version[2], version[3]]
    assessor_versions[queue].append(run)

    # Фильтр по названию версии
    # if version_name in version_list:
    #     run = [version[2], version[3]]
    #     assessor_versions[queue].append(run)
    # else:
    #     continue

assessor_data = dict()
for queue in assessor_versions:
    versions = assessor_versions[queue]
    runs_month = defaultdict(list)
    for i in range(len(versions)):
        single_run = versions[i]
        time_from_json = single_run[0] / 1000
        date = datetime.date.fromtimestamp(time_from_json)
        month = str(date - datetime.timedelta(days=(date.day - 1)))
        duration = int(single_run[1] - single_run[0]) / 1000 / 60
        if month in runs_month:
            runs_month[month].append(duration)
        else:
            runs_month[month] = [duration]

    #print(runs_month)
    runs_average = dict()
    for month in runs_month:
        runs_average[month] = int(numpy.mean(runs_month[month]))

    if queue in assessor_data:
        assessor_data[queue].update(runs_average)
    else:
        assessor_data[queue] = runs_average

for queue in assessor_data:
    dates = assessor_data[queue]
    data = [
        {
            'fielddate': date,
            'queue': queue,
            'assessor': dates[date],
        }
        for date in dates
    ]

    print(data)

# r = requests.post(
#     'https://upload.stat.yandex-team.ru/_api/report/data',
#     headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
#     data={
#         'name': 'Mail/Others/regression',
#         'scale': 'm',
#         'data': json.dumps({'values': data})
#     }
# )
# print(' Stat response: %s' % r.text)
