# -*- coding: utf-8 -*-
import os
import datetime
from collections import defaultdict
import requests
import json

import numpy
from yql.api.v1.client import YqlClient
import yaml

scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
client = YqlClient(db='hahn', token=yaconfig['YQL_TOKEN'])

request = client.query(r"""
    SELECT namespace, version, started_ts, finished_ts
    FROM [//home/assessor-production/qa/link551/production/version_statuses/finished] as T
    WHERE namespace LIKE "diskdesktop" AND started_ts >= 1551398400000
    OR namespace LIKE "disc3" AND started_ts >= 1551398400000
    """)

request.run()

# Собираем из таблицы список ранов в формате [очередь, версия, начало, конец]
assessor_runs = list()
for table in request.get_results():
    table.fetch_full_data()
    for row in table.rows:
        runs = list()
        for cell in row:
            runs.append(cell)
        assessor_runs.append(runs)

assessor_versions = {'disk_mac': [], 'disk_win': []}


# Для каждой очереди формируем словарь: {очередь: [версия, начало, конец]}
for i in range(len(assessor_runs)):
    version = assessor_runs[i]

    version_name = version[1].replace('%20', ' ').encode('utf-8')
    if 'Mac' in version_name:
        queue = 'disk_mac'
    if 'Win' in version_name:
        queue = 'disk_win'

    run = [version_name, version[2], version[3]]
    assessor_versions[queue].append(run)


# Расчитываем длительность каждой версии и делим их по месяцам
assessor_data = dict()
for queue in assessor_versions:
    versions = assessor_versions[queue]
    runs_month = defaultdict(list)
    for i in range(len(versions)):
        single_run = versions[i]
        time_from_json = single_run[1] / 1000
        date = str(datetime.date.fromtimestamp(time_from_json))
        # month = str(date - datetime.timedelta(days=(date.day - 1)))
        duration = int(single_run[2] - single_run[1]) / 1000 / 60
        version_name = single_run[0]
        version_stat = [date, duration, version_name]

        if queue in assessor_data:
            assessor_data[queue].append(version_stat)
        else:
            assessor_data[queue] = [version_stat]


for queue in assessor_data:
    versions = assessor_data[queue]
    for single_version in range(len(versions)):
        version = versions[single_version]
        data = [
            {
                'fielddate': version[0],
                'queue': queue,
                'duration': version[1],
                'version': version[2]
            }
        ]
        print(data)
        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
            data={
                'name': 'Mail/Others/assessorversions',
                'scale': 'd',
                'data': json.dumps({'values': data})
            }
        )
        logging.info(' Stat response: %s' % r.text)

