# -*- coding: utf-8 -*-
import datetime
import json
import logging
import os

import numpy
import requests
import urllib3
import yaml

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
dateLimit = yaconfig['dateLimit']


def is_assessor_version(version):
    if 'asses' in version.lower() or 'ases' in version.lower() or 'acces' in version.lower() \
            or 'асес'.decode('utf-8') in version.lower():
        return True


def is_autotest(testrun):
    return testrun['launcherInfo']['external'] == "True"


# from 01.08.2018
def is_last_quarter(created_date):
    if created_date >= dateLimit:
        return True
    return False


def is_not_empty(testruns):
    if not testruns:
        return False
    return True


def is_finished(single_run):
    if single_run['status'] == 'FINISHED':
        return True
    return False


# Для ручного считаем время начала первого рана и время окончания последнего, берем среднее по версии
def manual_data():
    url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    all_versions = requests.get(url, headers=req_headers).json()
    versions = list()
    manual = list()

    for single_version in all_versions:
        if is_last_quarter(single_version['finishedTime']) and is_not_empty(single_version['suites'])\
                and not is_assessor_version(single_version['title']):
            versions.append(single_version['title'])
            #print(single_version['title'])
        else:
            continue

    for manual_version in versions:
        url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId + '/overview/' + manual_version
        req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
        response = requests.get(url, headers=req_headers)
        runs = response.json()
        start_time = list()
        finish_time = list()
        version = dict()
        exec_time = 0

        for single_run in runs['testruns']:
            if is_last_quarter(single_run['startedTime']) \
                    and 'testSuite' in single_run and 'id' in single_run['testSuite'] \
                    and single_run['testSuite']['id'] in manual_testplan:
                start = round(single_run['startedTime'] / 1000 / 60)
                fin = round(single_run['finishedTime'] / 1000 / 60)
                execution = round(single_run['executionTime']) / 1000 / 60

                if execution > 0 and fin > 0:
                    exec_time += execution
                    if start > 0 and fin > 0:
                        start_time.append(start)
                        finish_time.append(fin)
                    else:
                        continue
            else:
                continue

        if start_time and finish_time:
            time_from_json = int(runs['version']['finishedTime']) / 1000  # ALERT ЗАМЕНА нужно finished
            date = str(datetime.date.fromtimestamp(time_from_json))

            ver_start = round(runs['version']['startedTime'] / 1000 / 60)
            ver_fin = round(runs['version']['finishedTime'] / 1000 / 60)
            duration = ver_fin - ver_start

            runtime = min(duration, exec_time)

            # if runtime >= man_max:
            #     version_run_time = man_max
            # else:

            version_run_time = runtime
            ver_title = runs['version']['title']

        else:
            continue

        version[ver_title] = version_run_time
        version = [date, version_run_time, ver_title]
        manual.append(version)

    for version in manual:
        data = [
            {'queue': parentId,
             'fielddate': version[0],
             'duration': version[1],
             'version': version[2]}
        ]

        logging.info(' Data is ready %s' % data)

        r = requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
            data={
                'name': 'Mail/Others/ManualDetailed',
                'scale': 'd',
                'data': json.dumps({'values': data})
            }
        )

        logging.info(' Stat response: %s' % r.text)


all_queues = yaconfig['parentId']
for queue_data in all_queues:
    for parentId in queue_data:
        queue_params = queue_data[parentId]
        assessor_testplan = queue_params['assessor_testplan']
        manual_testplan = queue_params['manual_testplan']
        as_max = int(queue_params['as_max'])
        man_max = int(queue_params['man_max'])

        manual_data()
