# -*- coding: utf-8 -*-
import datetime
import logging
import os

import numpy
import requests
import urllib3
import yaml

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
dateLimit = yaconfig['dateLimit']


# from 01.08.2018
def is_last_quarter(created_date):
    if created_date >= dateLimit:
        return True
    return False


# Кастомные раны АМ (ручной регресс) - НЕ сьюты

android_testruns = [
    '5c45e541f557091ad66f7760',
    '5b683ce32afa3a2d20596725',
    '5b7e69257986336ac5826021',
    '5bc61974a5e5ed4ac0025b36',
    '5b3b919a176ea2776c5cda8f',
    '5b7162bb2afa3ac58d70b681',
    '5b925d732afa3a1d0b34a474',
    '5bbf499fa632ea59d4e9fa37',
    '5bcdd1c479863380a18876af',
    '5beea2d7ac472f90d162451b',
    '5c18bfec798633ce83ffbcb7'
]

ios_testruns = [
    '5c4ae4497082980a49348b62',
    '5bffd871ac472f27f2290f7a',
    '5c261c76f55709a58443ecf4',
    '5b5727eda5e5ed41b527e7a7',
    '5bab8b26e0368c90f36b8b22',
    '5bf2cbbeac472f90d164b60e'
]

release_tickets = [
    'MOBDEVAUTH-5551',
    'MOBDEVAUTH-5351',
    'MOBDEVAUTH-5274',
    'MOBDEVAUTH-5060',
    'MOBDEVAUTH-5001',
    'MOBDEVAUTH-5215',
    'MOBDEVAUTH-4944',
    'MOBDEVAUTH-5518',
    'MOBDEVAUTH-5411',
    'MOBDEVAUTH-5127',
    'MOBDEVAUTH-4966',
    'MOBDEVAUTH-4872',
    'MOBDEVAUTH-5647',
    'MOBDEVAUTH-5646'
]

# url = 'https://testpalm.yandex-team.ru:443/api/testrun/am-ios/preview'
url = 'https://testpalm.yandex-team.ru:443/api/testrun/am-android/preview'
req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
runs = requests.get(url, headers=req_headers).json()
all_manual_runs = []
manual = dict(list())

for single_run in runs:
    if single_run['id'] in android_testruns:  # android_testruns: #ios_testruns:
        all_manual_runs.append(single_run)

run_for_issue = dict()
for ticket in release_tickets:
    runs_in_issue = list()
    for manual_run in all_manual_runs:
        parent_issue = manual_run['parentIssue']['id']
        if ticket == parent_issue:
            runs_in_issue.append(manual_run)
            run_for_issue[parent_issue] = runs_in_issue
        else:
            continue

release_timings = dict(list())
for issue in run_for_issue:
    issue_runs = run_for_issue[issue]
    for one_run in range(len(issue_runs)):
        testrun = issue_runs[one_run]
        status = testrun['status']

        if status == 'FINISHED':
            start = round(testrun['startedTime'] / 1000 / 60)
            fin = round(testrun['finishedTime'] / 1000 / 60)
            duration = fin - start
            execution = round(testrun['executionTime']) / 1000 / 60
            runtime = min(duration, execution, 5000)

            time_from_json = int(testrun['finishedTime']) / 1000

            run_data = [time_from_json, runtime]

            if issue in release_timings:
                release_timings[issue].append(run_data)
            else:
                release_timings[issue] = [run_data]
        else:
            continue

print(release_timings)

final_data = dict()
for release in release_timings:
    runs = release_timings[release]
    time = 0
    date = 0
    for run in runs:
        time += run[1]
        new_date = run[0]
        if new_date > date:
            date = new_date
    common_date = datetime.date.fromtimestamp(date)
    month = str(common_date - datetime.timedelta(days=(common_date.day - 1)))
    if month in final_data:
        final_data[month].append(time)
    else:
        final_data[month] = [time]

print(final_data)

# am_stat = dict()
# for month in final_data:
#     time = final_data[month]
#     am_stat[month] = int(numpy.mean(time))
#
# print(am_stat)
