# -*- coding: utf-8 -*-
import datetime
import json
import logging
import os

import numpy
import requests
import urllib3
import yaml

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
dateLimit = yaconfig['dateLimit']

# from 01.08.2018
def is_last_quarter(created_date):
    if created_date >= dateLimit:
        return True
    return False


# Релизные тикеты диска десктоп для поиска ранов, не привязанных к версии
# disk_release_tickets = [
#     'DISCSW-14218',
#     'DISCSW-14058',
#     'DISCSW-14170',
#     'DISCSW-14075'
# ]

disk_win = [
    'DISCSW-14218',
    'DISCSW-14058'
]

disk_mac = [
    'DISCSW-14170',
    'DISCSW-14075'
]

diskdesktop = ['58ad7445c6123328462c9143', '589d7c4cc612333268b56a23','5b6052739ddb47daa81e5605', '5b7543e8a5e5ed2bcfaa7c0d']

#url = 'https://testpalm.yandex-team.ru:443/api/testrun/diskdesktop/preview'
url = 'https://testpalm.yandex-team.ru:443/api/testrun/disc3/preview'
req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
runs = requests.get(url, headers=req_headers).json()
all_manual_runs = []
manual = dict(list())


for single_run in runs:
    if 'testSuite' in single_run and 'id' in single_run['testSuite'] \
            and 'id' in single_run['parentIssue'] \
            and single_run['testSuite']['id'] in diskdesktop:
        all_manual_runs.append(single_run)

run_for_issue = dict()

for ticket in disk_win:
    runs_in_issue = list()
    for manual_run in all_manual_runs:
        parent_issue = manual_run['parentIssue']['id']
        if ticket == parent_issue:
            runs_in_issue.append(manual_run)
            run_for_issue[parent_issue] = runs_in_issue
        else:
            continue

release_timings = dict(list())
for issue in run_for_issue:
    issue_runs = run_for_issue[issue]
    for one_run in range(len(issue_runs)):
        testrun = issue_runs[one_run]
        status = testrun['status']

        if status == 'FINISHED':
            start = round(testrun['startedTime'] / 1000 / 60)
            fin = round(testrun['finishedTime'] / 1000 / 60)
            duration = fin - start
            execution = round(testrun['executionTime']) / 1000 / 60
            runtime = min(duration, execution, 5000)

            time_from_json = int(testrun['finishedTime']) / 1000

            run_data = [time_from_json, runtime]

            if issue in release_timings:
                release_timings[issue].append(run_data)
            else:
                release_timings[issue] = [run_data]
        else:
            continue

final_data = dict()
for release in release_timings:
    runs = release_timings[release]
    time = 0
    date = 0
    for run in range(len(runs)):
        time += runs[run][1]
        new_date = runs[run][0]
        if new_date > date:
            date = new_date
    common_date = str(datetime.date.fromtimestamp(date))

    data = [
        {'queue': 'disk_win',
         'fielddate': common_date,
         'duration': time,
         'version': release}
    ]

    logging.info(' Data is ready %s' % data)
    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
        data={
            'name': 'Mail/Others/ManualDetailed',
            'scale': 'd',
            'data': json.dumps({'values': data})
        }
    )

    print(' Stat response: %s' % r.text)

