# -*- coding: utf-8 -*-
import datetime
import json
import logging
import os

import numpy
import requests
import urllib3
import yaml

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
dateLimit = yaconfig['dateLimit']


# from 01.08.2018
def is_last_quarter(created_date):
    if created_date >= dateLimit:
        return True
    return False


passport_manual_run = '5b360c8b176ea2d34c16c207'

url = 'https://testpalm.yandex-team.ru:443/api/testrun/passport/preview'
req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
runs = requests.get(url, headers=req_headers).json()
manual = list()

for i in range(len(runs)):
    single_run = runs[i]
    if 'testSuite' in single_run and 'id' in single_run['testSuite'] \
            and single_run['testSuite']['id'] == passport_manual_run:
        execution = round(single_run['executionTime']) / 1000 / 60
        if execution > 0:
            time_from_json = int(single_run['finishedTime']) / 1000
            date = str(datetime.date.fromtimestamp(time_from_json))
            # date = datetime.date.fromtimestamp(time_from_json)
            # month = str(date - datetime.timedelta(days=(date.day - 1)))

            start = round(single_run['startedTime'] / 1000 / 60)
            fin = round(single_run['finishedTime'] / 1000 / 60)
            duration = fin - start

            runtime = min(duration, execution)
            # print(single_run['title'])
            # print(month)
            # print('original runtime %s' % runtime)

            # if date in manual:
            #     manual[date].append(runtime)
            # else:
            #     manual[date] = [runtime]

            run = [date, single_run['title'], runtime]
            manual.append(run)

for run in manual:
    data = [
        {'queue': 'passport',
         'fielddate': run[0],
         'duration': run[2],
         'version': run[1]}
    ]
    print(data)

    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
        data={
            'name': 'Mail/Others/ManualDetailed',
            'scale': 'd',
            'data': json.dumps({'values': data})
        }
    )

    print(' Stat response: %s' % r.text)

#passport_stat = dict()
# for month in manual:
#     time = manual[month]
    #passport_stat[month] = int(numpy.mean(time))
