# -*- coding: utf-8 -*-
import datetime
import json
import logging
import os

import numpy
import requests
import urllib3
import yaml

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))

dateLimit = yaconfig['dateLimit']
assessor_namings = ['асессор'.decode('utf-8'), 'assessor', 'asess', 'asessors']


def is_assessor_version(version):
    for name in assessor_namings:
        if name in version.lower() and 'регулярный регресс'.decode('utf-8') not in version.lower():
            return True
    return False


def is_autotest(testrun):
    return testrun['launcherInfo']['external'] == "True"


# from 01.08.2018
def is_last_quarter(created_date):
    return created_date >= dateLimit


def is_not_empty(testruns):
    if not testruns:
        return False
    return True


# Для асессоров считаем время начала первого рана и время окончания последнего, берем среднее по версии
def assessor_data():
    url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    all_versions = requests.get(url, headers=req_headers).json()
    versions = list()
    assessor = dict()
    assessor_failed = dict()

    for single_version in all_versions:
        if is_assessor_version(single_version['title']) and is_last_quarter(single_version['finishedTime']) \
                and is_not_empty(single_version['suites']):
            logging.info(' found assessor version: %s' % single_version['title'])
            versions.append(single_version['title'])

    for assessor_version in versions:
        url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId + '/overview/' + assessor_version
        req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
        response = requests.get(url, headers=req_headers)
        runs = response.json()
        start_time = list()
        finish_time = list()
        version = dict()
        version_failed = dict()
        failed = 0

        for single_run in runs['testruns']:
            if 'testSuite' in single_run and 'id' in single_run['testSuite'] \
                    and single_run['testSuite']['id'] in assessor_testplan:
                start_time.append(round(single_run['startedTime'] / 1000 / 60))
                finish_time.append(round(single_run['finishedTime'] / 1000 / 60))

                # Среднее время разбора бага от асессора: 20 минут
                failed += int(single_run['resolution']['counter']['failed']) * 20
            else:
                continue

        if start_time and finish_time:
            time_from_json = int(runs['version']['finishedTime']) / 1000
            date = datetime.date.fromtimestamp(time_from_json)
            fin_date = str(date - datetime.timedelta(days=(date.day - 1)))
            runtime = max(finish_time) - min(start_time)
            if runtime >= as_max:
                version_run_time = as_max
            else:
                version_run_time = runtime
            ver_title = runs['version']['title']
        else:
            continue

        if version_run_time == 0:
            logging.info('Skip empty version %s' % ver_title)
            continue
        else:
            version[ver_title] = version_run_time

        version_failed[ver_title] = failed

        if fin_date in assessor:
            assessor[fin_date].update(version)
        else:
            assessor[fin_date] = version

        if fin_date in assessor_failed:
            assessor_failed[fin_date].update(version_failed)
        else:
            assessor_failed[fin_date] = version_failed

    # Расчитываем среднее время рана асессоров по месяцам
    assessor_dict = dict()
    for fin_date in assessor:
        assessor_average_time = list()
        for key in assessor[fin_date]:
            assessor_average_time.append(assessor[fin_date][key])
        assessor_dict[fin_date] = assessor_average_time

    assessor_average = dict()
    for fin_date in assessor_dict:
        assessor_average[fin_date] = int(numpy.mean(assessor_dict[fin_date]))

    # Рассчитываем среднее время, затраченное на разбор багов от асессоров, по месяцам
    failed_dict = dict()
    for fin_date in assessor_failed:
        failed_average_time = list()
        for key in assessor_failed[fin_date]:
            failed_average_time.append(assessor_failed[fin_date][key])
        failed_dict[fin_date] = failed_average_time

    assessor_failed_average = dict()
    for fin_date in failed_dict:
        assessor_failed_average[fin_date] = int(numpy.mean(failed_dict[fin_date]))

    return assessor_average, assessor_failed_average


# Для ручного считаем время начала первого рана и время окончания последнего, берем среднее по версии
def manual_data():
    url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    all_versions = requests.get(url, headers=req_headers).json()
    versions = list()
    manual = dict()

    for single_version in all_versions:
        if is_last_quarter(single_version['finishedTime']) and is_not_empty(single_version['suites']) \
                and not is_assessor_version(single_version['title']):
            # ing.info(' found manual version: %s' % single_version['title'])
            versions.append(single_version['title'])

    for manual_version in versions:
        url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId + '/overview/' + manual_version
        req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
        response = requests.get(url, headers=req_headers)
        runs = response.json()
        start_time = list()
        finish_time = list()
        version = dict()

        for single_run in runs['testruns']:
            if 'testSuite' in single_run and 'id' in single_run['testSuite'] \
                    and single_run['testSuite']['id'] in manual_testplan:
                if single_run['launcherInfo'] and single_run['launcherInfo']['external']:
                    # logging.info("Skip external run {}".format(single_run['title']))
                    continue
                start_time.append(round(single_run['startedTime'] / 1000 / 60))
                finish_time.append(round(single_run['finishedTime'] / 1000 / 60))
            else:
                continue

        if start_time and finish_time:
            time_from_json = int(runs['version']['finishedTime']) / 1000
            date = datetime.date.fromtimestamp(time_from_json)
            fin_date = str(date - datetime.timedelta(days=(date.day - 1)))
            runtime = max(finish_time) - min(start_time)
            if runtime >= man_max:
                version_run_time = man_max
            else:
                version_run_time = runtime
            ver_title = runs['version']['title']
        else:
            continue

        if version_run_time == 0:
            # logging.info('Skip empty version %s' % ver_title)
            continue
        else:
            version[ver_title] = version_run_time

        if fin_date in manual:
            manual[fin_date].update(version)
        else:
            manual[fin_date] = version

    # Расчитываем среднее время рана асессоров по месяцам
    manual_dict = dict()
    for fin_date in manual:
        manual_average_time = list()
        for key in manual[fin_date]:
            manual_average_time.append(manual[fin_date][key])
        manual_dict[fin_date] = manual_average_time

    manual_average = dict()
    for fin_date in manual_dict:
        manual_average[fin_date] = int(numpy.mean(manual_dict[fin_date]))

    return manual_average


def send_data(assessor, manual):
    assessor_average = assessor[0]
    assessor_failed_average = assessor[1]

    dates = ['2018-08-01', '2018-09-01', '2018-10-01', '2018-11-01', '2018-12-01']

    for date in dates:
        if date not in manual:
            manual[date] = 0
        elif date not in assessor_average:
            assessor_average[date] = 0
        elif date not in assessor_failed_average:
            assessor_failed_average[date] = 0
        else:
            continue

    data = [
        {
            'fielddate': date,
            'queue': parentId,
            'assessor': assessor_average[date],
            'assessor_failed': assessor_failed_average[date],
            'manual': manual[date]
        }
        for date in dates
    ]

    logging.info(' Data is ready %s' % data)

    # r = requests.post(
    #     'https://upload.stat.yandex-team.ru/_api/report/data',
    #     headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
    #     data={
    #         'name': 'Mail/Others/regression',
    #         'scale': 'm',
    #         'data': json.dumps({'values': data})
    #     }
    # )
    # logging.info(' Stat response: %s' % r.text)


all_queues = yaconfig['parentId']
for queue_data in all_queues:
    for parentId in queue_data:
        queue_params = queue_data[parentId]
        assessor_testplan = queue_params['assessor_testplan']
        manual_testplan = queue_params['manual_testplan']
        as_max = int(queue_params['as_max'])
        man_max = int(queue_params['man_max'])

        send_data(assessor_data(), manual_data())
