# -*- coding: utf-8 -*-
import datetime
import logging
import os
from datetime import timedelta

import requests
import urllib3
import yaml

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
logging.basicConfig(
    format='%(filename)s[LINE:%(lineno)d]# %(levelname)-8s [%(asctime)s]  %(message)s', level=logging.INFO)
scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))

# Project
parentId = yaconfig['parentId']


def is_assessor_version(version):
    if 'асессор' in version.lower() or 'asessors' in version.lower():
        if 'регулярный регресс' in version.lower():
            return False
        return True


def is_not_assessor_version(version):
    if 'асессор' in version.lower() or 'asessors' in version.lower() \
            or 'регулярный регресс' in version.lower():
        return False
    return True


def is_autotest(testrun):
    if testrun['launcherInfo']['external'] == "True":
        return True
    return False


# from 01.08.2018
def is_last_quarter(created_date):
    if created_date >= 1533070800000:
        return True
    return False


def is_not_empty(testruns):
    if not testruns:
        return False
    return True


def assessor_data():
    url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    response = requests.get(url, headers=req_headers)
    all_versions = response.json()
    versions = list()
    assessor = dict()
    assessor_failed = dict()

    for i in all_versions:
        if is_assessor_version(i['title']) and is_last_quarter(i['finishedTime']) and is_not_empty(i['suites']):
            logging.info(' found assessor version: %s' % i['title'])
            versions.append(i['title'])

    for i in versions:
        url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId + '/overview/' + i
        req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
        response = requests.get(url, headers=req_headers)
        runs = response.json()
        start_time = list()
        finish_time = list()
        version_run_time = 0
        failed = 0

        for single_run in runs['testruns']:
            start_time.append(round(single_run['startedTime'] / 1000 / 60))
            finish_time.append(round(single_run['finishedTime'] / 1000 / 60))

            # Среднее время разбора бага от асессора: 20 минут
            failed += int(single_run['resolution']['counter']['failed']) * 20

        if start_time and finish_time:
            time_from_json = int(runs['version']['finishedTime']) / 1000
            date = datetime.date.fromtimestamp(time_from_json)
            fin_date = str(date - datetime.timedelta(days=(date.day - 1)))
            runtime = max(finish_time) - min(start_time)
            if runtime >= 500:
                version_run_time += 500
            else:
                version_run_time += runtime

        if fin_date in assessor:
            assessor[fin_date] += version_run_time
        else:
            assessor[fin_date] = version_run_time

        if fin_date in assessor_failed:
            assessor_failed[fin_date] += failed
        else:
            assessor_failed[fin_date] = failed

    print(assessor)
    print(assessor_failed)
    return assessor, assessor_failed


def manual_data():
    url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    response = requests.get(url, headers=req_headers)
    all_versions = response.json()
    versions = []

    # Игнорируем служебные раны: Ответственному за релиз и Инструкция к новой фиче
    ignored_suites = ['562e38c5e4b0ef8ed6d11333', '5b6bff692afa3ab633dfd994']

    for i in all_versions:
        if is_not_assessor_version(i['title']) and is_last_quarter(i['finishedTime']) and is_not_empty(i['suites']):
            logging.info(' found manual version: %s' % i['title'])
            versions.append(i['title'])

    for i in versions:
        url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId + '/overview/' + i
        req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
        response = requests.get(url, headers=req_headers)
        runs = response.json()

        for single_run in runs['testruns']:
            if 'testSuite' not in single_run or 'id' not in single_run['testSuite'] \
                    or single_run['testSuite']['id'] not in ignored_suites:
                if single_run['launcherInfo'] and single_run['launcherInfo']['external']:
                    logging.info("Skip external run {}".format(single_run['title']))
                    continue

                time_from_json = int(runs['version']['finishedTime']) / 1000
                date = datetime.date.fromtimestamp(time_from_json)
                fin_date = str(datetime.date.fromtimestamp(time_from_json) - datetime.timedelta(days=(date.day - 1)))

                runtime = round(single_run['executionTime'] / 1000 / 60)
                if runtime >= 100:
                    exec_time += 100
                else:
                    exec_time += runtime

                if start_date in manual:
                    manual[start_date] += run_time
                else:
                    manual[start_date] = run_time

    return manual


def autotest_data():
    url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId
    req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
    response = requests.get(url, headers=req_headers)
    all_versions = response.json()
    versions = []

    # Игнорируем служебные раны: Ответственному за релиз и Инструкция к новой фиче
    ignored_suites = ['562e38c5e4b0ef8ed6d11333', '5b6bff692afa3ab633dfd994']

    for i in all_versions:
        if is_not_assessor_version(i['title']) and is_last_quarter(i['finishedTime']) and is_not_empty(i['suites']):
            logging.info(' found manual version: %s' % i['title'])
            versions.append(i['title'])

    for i in versions:
        url = 'https://testpalm.yandex-team.ru:443/api/version/' + parentId + '/overview/' + i
        req_headers = {'TestPalm-Api-Token': yaconfig['AUTH_TP'], 'Content-Type': 'application/json'}
        response = requests.get(url, headers=req_headers)
        runs = response.json()
        runMap = {}

        for single_run in runs['testruns']:
            if single_run['launcherInfo'] and not single_run['launcherInfo']['external']:
                logging.info("Skip internal run {}".format(single_run['title']))
                continue
            title = single_run['title']

            if not runMap.get(title):
                runMap[title] = single_run
                continue
            else:
                time_from_json = int(single_run['finishedTime']) / 1000
                current_time = int(runMap[title]['finishedTime']) / 1000
                if time_from_json > current_time:
                    runMap[title] = single_run
                continue

        for single_run in runMap.values():
            time_from_json = int(single_run['finishedTime']) / 1000
            finished_time = str(datetime.date.fromtimestamp(time_from_json))

            exec_time = round(single_run['executionTime'] / 1000 / 60)
            count_fails = single_run['resolution']['counter']['failed'] + single_run['resolution']['counter']['broken']
            # Среднее время разбора бага автотестов: 5 минут
            time_to_fails = round(int(count_fails * 5))

            run_time = exec_time + time_to_fails

            if finished_time in autotest:
                autotest[finished_time] += run_time
            else:
                autotest[finished_time] = run_time

    return autotest


def send_data(assessor, manual, autotest):
    dates = assessor.keys()
    data = [
        {
            'fielddate': date,
            'queue': parentId,
            'assessor': assessor[date],
            'manual': manual[date],
            'autotest': autotest[date]
        }
        for date in dates
    ]

    logging.info(' Data is ready %s' % data)

    # r = requests.post(
    #     'https://upload.stat.yandex-team.ru/_api/report/data',
    #     headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
    #     data={
    #         'name': 'Mail/Others/regression',
    #         'scale': 'm',
    #         'data': json.dumps({'values': data})
    #     }
    # )
    # logging.info(' Stat response: %s' % r.text)


send_data(assessor_data(), manual_data(), autotest_data())
