# -*- coding: utf-8 -*-
import os
from collections import defaultdict
import requests
import json
import time

from yql.api.v1.client import YqlClient
from datetime import timedelta, date
import yaml

scriptPath = os.path.dirname(os.path.abspath(__file__) + '/SupportQueueMonitoring')
yaconfig = yaml.load(open(os.path.dirname(scriptPath) + '/config.yaml'))
client = YqlClient(db='hahn', token=yaconfig['YQL_TOKEN'])

month = date.today() - timedelta(days=(date.today().day - 1))
dateLimit = int(time.mktime(month.timetuple())) * 1000

# /Mail/Others/regression   m
# /Mail/Others/ManualDetailed  d


all_data = [
    [{'queue': 'cal', 'fielddate': '2019-03-19', 'duration': 0, 'version': ' '}]
]

for data in all_data:
    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers={'Authorization': 'OAuth %s' % yaconfig['AUTH_STAT']},
        data={
            'name': '/Mail/Others/ManualDetailed',
            'scale': 'd',
            'data': json.dumps({'values': data})
        }
    )
    print(' Stat response: %s' % r.text)
