# -*- coding: utf-8 -*-
import os
import random

import telebot

from set_secret import set_secret

set_secret.set_secrets()
bot = telebot.TeleBot(os.environ["TELEBOT_TOKEN"])


@bot.message_handler(content_types=['text'])
def start(message):
    if message.text != "":
        bot.send_message(message.from_user.id, 'Вот смоуки:\n\n' + random_smoke())
    else:
        bot.send_message(message.from_user.id, 'Напиши что-нибудь')


def random_smoke():
    browsers = ['FF', 'Safari', 'Chrome']
    domains = ['ru', 'com', 'com.tr']
    panes = ['2pane', '3pane-vertical', '3pane-horizontal']
    smokes = {}
    main_message = ''

    for pane in panes:
        browser = random.choice(browsers)
        browsers.remove(browser)
        domain = random.choice(domains)
        domains.remove(domain)
        if pane == '2pane':
            checkbox = False
            message_in_list = False
            show_avatars = True
        else:
            checkbox = True
            message_in_list = True
            show_avatars = False
        compact_mode = bool(random.getrandbits(1))
        threads = bool(random.getrandbits(1))
        compose = bool(random.getrandbits(1))

        smoke = {'browser': browser, 'pane': pane, 'domain': domain, 'checkbox': checkbox,
                 'message_in_list': message_in_list, 'show_avatars': show_avatars, 'compact_mode': compact_mode,
                 'threads': threads, 'compose': compose}
        smokes[pane] = smoke

    smokes['3pane-horizontal']['show_avatars'] = not smokes['3pane-vertical'].get('show_avatars')
    smokes['3pane-horizontal']['compact_mode'] = not smokes['2pane'].get('compact_mode')
    smokes['3pane-horizontal']['threads'] = not smokes['3pane-vertical'].get('threads')
    smokes['3pane-horizontal']['compose'] = not smokes['3pane-vertical'].get('compose')

    for value in smokes.values():
        message = "Бро: {0}\nВид: {1}\nДомен: {2}\nНастройки:\nАватарки в чекбоксах: {3}, Письмо в списке писем:" \
                  " {4}, Показывать аватарки: {5}, Компактный режим: {6}, Треды включены: {7}," \
                  " Маленький размер композа: {8}\n\n" \
            .format(value.get('browser'), value.get('pane'), value.get('domain'), value.get('checkbox'),
                    value.get('message_in_list'),
                    value.get('show_avatars'), value.get('compact_mode'), value.get('threads'),
                    value.get('compose'))
        main_message += message

    return main_message


bot.polling(none_stop=True, interval=0)
