import json
import os

with open(f'{os.path.dirname(os.path.realpath(__file__))}/settings.json') as f:
    settings = json.load(f)

with open(f'{os.path.dirname(os.path.realpath(__file__))}/default_user.json') as f:
    default_settings = json.load(f)

print('PARAMETERS SETTINGS')
for setting in settings[0]['settings']['parameters']['single_settings']:
    setting_default = settings[0]['settings']['parameters']['single_settings'][setting]
    if default_settings['settings']['parameters']['single_settings'].get(setting, None) == setting_default:
        continue
    is_equal = True
    for user in settings:
        if user['settings']['parameters']['single_settings'].get(setting, None) != setting_default:
            is_equal = False
            break
    if is_equal:
        print(f'{setting}:{setting_default}')

print('PROFILE SETTINGS')
for setting in settings[0]['settings']['profile']['single_settings']:
    setting_default = settings[0]['settings']['profile']['single_settings'][setting]
    if default_settings['settings']['profile']['single_settings'].get(setting, None) == setting_default:
        continue
    is_equal = True
    for user in settings:
        if user['settings']['profile']['single_settings'].get(setting, None) != setting_default:
            is_equal = False
            break
    if is_equal:
        print(f'{setting}:{setting_default}')


