#pragma once

#include <boost/format.hpp>

#include <string>

namespace NRateSrv {

template <typename... Args>
std::string Format(const char* str, Args&&... args) {
    auto format = boost::format(str);
    ((format % std::forward<Args>(args)), ...);
    return format.str();
}

} // namespace NRateSrv
