#include "input_segment_stream.h"

namespace NRateSrv {

TInputSegmentStream::TInputSegmentStream(const TSegment& segment)
    : Segment(segment)
    , Iter(Segment.cbegin())
{}

size_t TInputSegmentStream::DoRead(void* buf, size_t len) {
    auto charBuf = static_cast<char*>(buf);
    size_t count = 0;

    while (count < len && Iter != Segment.cend()) {
        charBuf[count++] = *Iter++;
    }

    return count;
}

} // namespace NRateSrv
