#pragma once

#include <yplatform/zerocopy/segment.h>

#include <util/stream/input.h>

namespace NRateSrv {

class TInputSegmentStream : public IInputStream {
public:
    using TSegment = yplatform::zerocopy::segment;

    explicit TInputSegmentStream(const TSegment& segment);

    TInputSegmentStream(TInputSegmentStream&& other) noexcept = default;
    TInputSegmentStream& operator=(TInputSegmentStream&& other) noexcept = default;

protected:
    size_t DoRead(void* buf, size_t len) override;

private:
    const TSegment& Segment;
    TSegment::const_iterator Iter;
};

} // namespace NRateSrv
