#pragma once

#include <util/stream/output.h>

#include <string>

namespace NRateSrv {

class TOutputStringStream : public IOutputStream {
public:
    explicit TOutputStringStream(std::string& str);

    TOutputStringStream(TOutputStringStream&& other) noexcept = default;
    TOutputStringStream& operator=(TOutputStringStream&& other) noexcept = default;

protected:
    void DoWrite(const void* buf, size_t len) override;
    void DoWriteC(char c) override;

private:
    std::string& Str;
};

} // namespace NRateSrv
