#pragma once

#include <boost/asio/post.hpp>

#include <functional>
#include <memory>
#include <type_traits>

namespace NRateSrv {

template <typename TExecutor, typename TCallable>
class TPostWrapper {
public:
    using THandler = std::remove_cv_t<std::remove_reference_t<TCallable>>;

    TPostWrapper(TExecutor&& executor, THandler handler)
        : Executor(std::forward<TExecutor>(executor))
        , Handler(std::make_shared<THandler>(std::move(handler)))
    {}

    template <typename... TArgs>
    void operator()(TArgs&&... args) const {
        auto f = [args = std::make_tuple(std::forward<TArgs>(args)...), handler = Handler]() mutable {
            std::apply(
                [handler = std::move(handler)](auto&&... args) {
                    (*handler)(std::forward<decltype(args)>(args)...);
                },
                std::move(args));
        };
        boost::asio::post(Executor, std::move(f));
    }

private:
    TExecutor Executor;
    std::shared_ptr<THandler> Handler;
};

template <typename TExecutor, typename TFunc>
auto MakePostWrapper(TExecutor&& executor, TFunc&& func) {
    return TPostWrapper<TExecutor, TFunc>(std::forward<TExecutor>(executor), std::forward<TFunc>(func));
}

} // namespace NRateSrv
