#pragma once

#include <util/system/types.h>
#include <library/cpp/json/json_value.h>
#include <util/string/cast.h>

#include <string>
#include <unordered_map>

namespace NRateSrv {

enum class ECounterState {
    Ok /* "ok" */,
    GroupNotFound /* "group not found" */,
    LimitNotFound /* "limit not found" */,
    InvalidName /* "invalid name" */,
    NetworkProblem /* "network problem" */,
    Exceeded /* "exceeded" */,
    Unknown /* unknown */
};

struct TCounterValue {
    ECounterState State = ECounterState::Unknown;
    ui64 Current = 0;
    i64 Available = 0;

    [[nodiscard]] NJson::TJsonValue ToJson() const noexcept {
        NJson::TJsonValue json;
        json["state"] = ToString(State);
        json["current"] = Current;
        json["available"] = Available;
        return json;
    }

    bool operator==(const TCounterValue& other) const {
        return State == other.State && Current == other.Current && Available == other.Available;
    }
};

struct TCounterData {
    std::string Name;
    ui64 Value = 0;

    bool operator==(const TCounterData& other) const {
        return Name == other.Name && Value == other.Value;
    }
};

using TCounterRequest = std::unordered_map<std::string, TCounterData>;
using TCounterResponse = std::unordered_map<std::string, TCounterValue>;

enum class ERequestMode {
    Get /* "get" */,
    Increase /* "increase" */
};

} // namespace NRateSrv
