#pragma once

#include "json/callbacks.h"

#include <mail/ratesrv/src/common/types.h>
#include <mail/ratesrv/src/context.h>

#include <ymod_webserver/server.h>
#include <yplatform/coroutine.h>
#include <yplatform/time_traits.h>

#include <functional>
#include <memory>

namespace NRateSrv::NHandlers {

class TCountersWorker {
public:
    enum class EStatus {
        Ok,
        FailToParse,
        Aborted,
    };

    using TYieldCtx = yplatform::yield_context<TCountersWorker>;
    using THttpStreamPtr = ymod_webserver::http::stream_ptr;
    using TCallback = std::function<void(EStatus status)>;

    TCountersWorker(THttpStreamPtr httpStream, ERequestMode mode);

    void operator()(TYieldCtx yieldCtx, EStatus status = EStatus::Ok);

private:
    void ParseRequest(TCallback callback);
    void SendToRouter(TCallback callback);
    void Complete(EStatus status);

private:
    TContextPtr Ctx;
    THttpStreamPtr HttpStream;
    ERequestMode Mode;
    yplatform::time_traits::time_point StartedAt;
    std::unique_ptr<NJson::TCallbacks> Callbacks;
    TCounterResponse Response;
};

} // namespace NRateSrv::NHandlers
