#include "counters_get.h"

#include <mail/ratesrv/src/handlers/counters_worker.h>

#include <yplatform/coroutine.h>
#include <yplatform/find.h>

#include <memory>

namespace NRateSrv::NHandlers::NHttp {

TCountersGet::TCountersGet(yplatform::reactor& reactor)
    : Reactor(reactor)
{}

THttpPaths TCountersGet::Paths() const {
    return {"/counters"};
}

EHttpMethod TCountersGet::Method() const {
    return EHttpMethod::mth_post;
}

bool TCountersGet::NeedTvm() const {
    return true;
}

void TCountersGet::Execute(THttpStreamPtr stream) {
    // TODO: make common request context, without HTTP
    auto getter = std::make_shared<TCountersWorker>(std::move(stream), ERequestMode::Get);
    yplatform::spawn(Reactor.io()->get_executor(), getter);
}

} // namespace NRateSrv::NHandlers::NHttp
