#include "counters_increase.h"

#include <mail/ratesrv/src/handlers/counters_worker.h>

#include <yplatform/coroutine.h>
#include <yplatform/find.h>

#include <memory>

namespace NRateSrv::NHandlers::NHttp {

TCountersIncrease::TCountersIncrease(yplatform::reactor& reactor)
    : Reactor(reactor)
{}

THttpPaths TCountersIncrease::Paths() const {
    return {"/counters/increase"};
}

EHttpMethod TCountersIncrease::Method() const {
    return EHttpMethod::mth_post;
}

bool TCountersIncrease::NeedTvm() const {
    return true;
}

void TCountersIncrease::Execute(THttpStreamPtr stream) {
    // TODO: make common request context, without HTTP
    auto setter = std::make_shared<TCountersWorker>(std::move(stream), ERequestMode::Increase);
    yplatform::spawn(Reactor.io()->get_executor(), setter);
}

} // namespace NRateSrv::NHandlers::NHttp
